/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.UpperCaseTextField;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.CreateContextIndexFinishState;

public class CreateContextIndexSettingsPanel
extends GriddedPanel {
    CreateContextIndexFinishState m_state;
    DM4JDialog m_parentDialog;
    String m_indexName;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    MultiLineLabel mlblFormatHint = new MultiLineLabel();
    JLabel lblIndexName = new JLabel();
    JTextField txtIndexName = new UpperCaseTextField();
    JLabel lblFiller = new JLabel();

    public CreateContextIndexSettingsPanel(DM4JDialog dM4JDialog, CreateContextIndexFinishState createContextIndexFinishState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = createContextIndexFinishState;
        this.txtIndexName = new JTextField();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("INDEX_SETTINGS_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblIndexName.setText(ResourceUtilities.getUILabel("INDEX_SETTINGS_INDEX_NAME"));
        this.lblIndexName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("INDEX_SETTINGS_INDEX_NAME"));
        this.lblIndexName.setLabelFor(this.txtIndexName);
        this.addComponent(this.lblIndexName, COL1_LABEL, n, 0);
        this.addFilledComponent(this.txtIndexName, COL_VALUE, n++, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
        JComponent[] jComponentArray = new JComponent[]{this.txtIndexName};
        CreateContextIndexSettingsPanel.setPreferredSize(jComponentArray, 260, 20);
        this.addOKHelpCancelListeners();
        this.savePriorState();
        this.loadState();
    }

    protected void loadState() {
        this.savePriorState();
        this.txtIndexName.setText(this.m_state.getIndexName());
    }

    protected void savePriorState() {
        this.m_indexName = this.m_state.getIndexName();
    }

    protected void restorePriorState() {
        this.m_state.setIndexName(this.m_indexName);
    }

    protected void processUserInput() {
        this.m_state.setIndexName(this.txtIndexName.getText());
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CreateContextIndexSettingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = null;
            try {
                this.processUserInput();
                vector = this.m_state.validateIndexName();
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if ("cancel" == string) {
            this.restorePriorState();
        }
    }
}

