/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenTargetFileState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class CodeGenTargetFilePanel
extends DM4JStep {
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private JLabel m_lblDirectoryName = new JLabel();
    private JLabel m_lblDirectoryValue = new JLabel();
    private JLabel m_lblFileName = new JLabel();
    private JTextField m_edFileName = new JTextField();
    private JButton m_btnBrowse = new JButton();

    public CodeGenTargetFilePanel(CodeGenTargetFileState codeGenTargetFileState) throws Exception {
        super(codeGenTargetFileState);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CG_CHOOSE_TARGET_FILE_DIRECTORY_NAME"));
        this.addFilledComponent(this.mlblStepDescription, new Insets(1, 1, 19, 1), n++, 0, 2, 1, 1);
        this.m_lblDirectoryName.setText(ResourceUtilities.getUILabel("CG_TARGET_DIRECTORY_NAME"));
        this.m_lblDirectoryName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CG_TARGET_DIRECTORY_NAME"));
        this.m_lblDirectoryName.setLabelFor(this.m_lblDirectoryValue);
        this.addFilledComponent(this.m_lblDirectoryName, new Insets(1, 1, 5, 15), n, 0, 1, 1, 2);
        this.addFilledComponent(this.m_lblDirectoryValue, new Insets(1, 10, 5, 1), n, 1, 1, 1, 2);
        this.m_btnBrowse.setEnabled(true);
        this.m_btnBrowse.setText(ResourceUtilities.getUILabel("CG_BROWSE_BUTTON"));
        this.m_btnBrowse.setMnemonic(ResourceUtilities.getUIMnemonic("CG_BROWSE_BUTTON"));
        this.m_btnBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeGenTargetFilePanel.this.butBrowse_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.m_btnBrowse, COL1_CONTROL, n++, 2, 1, 1, 11, 0);
        this.m_lblFileName.setText(ResourceUtilities.getUILabel("CG_TARGET_FILE_NAME"));
        this.m_lblFileName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CG_TARGET_FILE_NAME"));
        this.m_lblFileName.setLabelFor(this.m_edFileName);
        this.addFilledComponent(this.m_lblFileName, new Insets(1, 1, 5, 15), n, 0, 1, 1, 2);
        this.addFilledComponent(this.m_edFileName, new Insets(1, 10, 5, 1), n, 1, 1, 1, 2);
        this.addFilledComponent(new JLabel(), new Insets(1, 10, 5, 1), ++n, 0, 3, 3, 1);
        JButton[] jButtonArray = new JButton[]{this.m_btnBrowse};
        DM4JResourceUtilities.setPreferredSize(jButtonArray);
    }

    public void reinit() throws Exception {
        this.init();
    }

    public void init() throws Exception {
        this.m_lblDirectoryValue.setText(((CodeGenTargetFileState)this.m_state).getDirectory());
        this.m_edFileName.setText(((CodeGenTargetFileState)this.m_state).getFilename());
    }

    protected void butBrowse_actionPerformed(ActionEvent actionEvent) {
        File file;
        DMFileChooser dMFileChooser = new DMFileChooser(((CodeGenTargetFileState)this.m_state).getDirectory());
        dMFileChooser.setFileSelectionMode(0);
        dMFileChooser.setApproveButtonText(DM4JResourceUtilities.getUIString("COMMON_SELECT"));
        dMFileChooser.setDialogTitle(DM4JResourceUtilities.getUIString("COMMON_SELECT_FILE"));
        dMFileChooser.addChoosableFileFilter(new SqlFilter());
        dMFileChooser.setSelectedFile(new File(((CodeGenTargetFileState)this.m_state).getDirectory(), this.m_edFileName.getText()));
        dMFileChooser.setMultiSelectionEnabled(false);
        int n = dMFileChooser.showOpenDialog(this);
        if (n == 0 && (file = dMFileChooser.getSelectedFile()) != null) {
            String string = null;
            if (file.isDirectory()) {
                string = file.getAbsolutePath();
            } else {
                string = file.getParent();
                String string2 = file.getName();
                this.m_edFileName.setText(string2);
                ((CodeGenTargetFileState)this.m_state).setFilename(string2);
            }
            this.m_lblDirectoryValue.setText(string);
            ((CodeGenTargetFileState)this.m_state).setDirectory(string);
        }
    }

    protected void processUserInput() {
        ((CodeGenTargetFileState)this.m_state).setDirectory(this.m_lblDirectoryValue.getText());
        ((CodeGenTargetFileState)this.m_state).setFilename(this.m_edFileName.getText());
    }

    class SqlFilter
    extends FileFilter {
        SqlFilter() {
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = this.getExtension(file);
            if (string != null) {
                return string.equals("sql");
            }
            return false;
        }

        public String getDescription() {
            return ResourceUtilities.getUILabel("CG_PLSQL_FILE_TYPE");
        }

        public String getExtension(File file) {
            String string = null;
            String string2 = file.getName();
            int n = string2.lastIndexOf(46);
            if (n > 0 && n < string2.length() - 1) {
                string = string2.substring(n + 1).toLowerCase();
            }
            return string;
        }
    }

    class DMFileChooser
    extends JFileChooser {
        DMFileChooser(String string) {
            super(string);
        }

        public void approveSelection() {
            String string;
            int n;
            File file = this.getSelectedFile();
            if (file.exists() && 1 == (n = JOptionPane.showConfirmDialog(CodeGenTargetFilePanel.this, string = MessageFormat.format(DM4JResourceUtilities.getUIString("CG_OVEWWRITE_FILE"), file.getAbsolutePath()), DM4JResourceUtilities.getUIString("COMMON_SELECT_FILE"), 0, 2))) {
                return;
            }
            super.approveSelection();
        }
    }
}

