/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.browser.viewer.table.ModelUtil;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenResultsState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenResultsPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.UpdateProgress;
import oracle.dmt.dm4j.wizard.transforms.CodeGenWizard;

public class CodeGenResultsPanel
extends DM4JStep
implements ActionListener,
Runnable,
UpdateProgress {
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private CodeGenDataSource m_dataSource;
    private JButton m_btnCancel = new JButton();
    private JPanel _statusPanel;
    private JLabel _progressLabel = new JLabel();
    private String _progressText;
    private JLabel _stepLabel = new JLabel();
    private String _stepText;
    private JProgressBar _progressBar;
    private int _completionStatus;
    private Timer _labelTimer;
    private Timer _completionTimer;
    private boolean _userCancelled = false;
    private boolean _done = false;
    private CodeGenResultsPage m_page;

    public CodeGenResultsPanel(CodeGenResultsPage codeGenResultsPage, CodeGenResultsState codeGenResultsState) throws Exception {
        super(codeGenResultsState);
        try {
            CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
            this.m_dataSource = codeGenState.getDataSource();
            this.m_page = codeGenResultsPage;
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.addFilledComponent(this.mlblStepDescription, new Insets(1, 1, 19, 1), 0, 0, 3, 1, 1);
        this.initializeProgressBar("", "");
        this.addFilledComponent(new JLabel(), new Insets(1, 1, 1, 1), 1, 0, 3, 10, 1);
        int n = 2;
        this.addFilledComponent(this._statusPanel, new Insets(1, 1, 1, 1), n++, 0, 3, 1, 1);
        this.m_btnCancel.setEnabled(true);
        this.m_btnCancel.setText(ResourceUtilities.getUILabel("CG_CANCEL_GENERATE_CODE"));
        this.m_btnCancel.setMnemonic(ResourceUtilities.getUIMnemonic("CG_CANCEL_GENERATE_CODE"));
        this.m_btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeGenResultsPanel.this.butCancel_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.m_btnCancel, new Insets(1, 20, 0, 0), n++, 3, 1, 1, 11, 0);
    }

    private void changeLayout() {
        boolean bl = false;
        this.showProgressUI(false);
        if (this._done) {
            if (this._userCancelled) {
                this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CODE_GEN_RESULTS_STEP_ABORTED"));
                this.m_state.setState(StepStateType.UNLOADED);
            } else if (((CodeGenResultsState)this.m_state).isClean()) {
                this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CODE_GEN_RESULTS_SUCCESFULLY_GENERATED"));
                this.m_state.setState(StepStateType.VALIDATED);
                bl = true;
            } else {
                this.showDetails();
                Vector vector = ((CodeGenResultsState)this.m_state).getValidatedActivities();
                bl = !vector.isEmpty();
                this.m_state.setState(StepStateType.VALIDATED);
            }
            ((CodeGenResultsState)this.m_state).setCanGoBack(this._done);
        }
        ((CodeGenResultsState)this.m_state).setCanAdvance(bl);
    }

    protected void butCancel_actionPerformed(ActionEvent actionEvent) {
        this._userCancelled = true;
    }

    private void showProgressUI(boolean bl) {
        this._statusPanel.setVisible(bl);
        this.m_btnCancel.setVisible(bl);
    }

    private void showDetails() {
        this.m_page.showDetailsPanel();
    }

    public void initializeProgressBar(String string, String string2) {
        this._progressText = string;
        this._stepText = string2;
        this._statusPanel = new JPanel(new GridBagLayout());
        this._progressLabel.setText(this._progressText);
        this._progressLabel.setLabelFor(this._progressBar);
        this._stepLabel.setText(this._stepText);
        this._progressBar = new JProgressBar();
        this._progressBar.setValue(0);
        this._progressBar.setStringPainted(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0);
        this._statusPanel.add((Component)this._progressLabel, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        this._statusPanel.add((Component)this._progressBar, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        this._statusPanel.add((Component)this._stepLabel, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this._statusPanel.add(Box.createHorizontalStrut(300), gridBagConstraints);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._labelTimer) {
            if (ModelUtil.hasLength(this._progressText)) {
                this._progressLabel.setText(this._progressText);
            }
            if (ModelUtil.hasLength(this._stepText)) {
                this._stepLabel.setText(this._stepText);
            }
            if (this._progressBar != null) {
                this._progressBar.setValue(this._completionStatus);
            }
        } else if (object == this._completionTimer) {
            if (this._labelTimer != null) {
                this._labelTimer.stop();
                this._labelTimer.removeActionListener(this);
                this._labelTimer = null;
            }
            this._completionTimer.stop();
            this._completionTimer.removeActionListener(this);
            this._completionTimer = null;
            if (this._userCancelled) {
                this._progressBar.setValue(0);
                this._progressLabel.setText(ResourceUtilities.getUILabel("CODE_GEN_RESULTS_STEP_ABORTED"));
                this._stepLabel.setText(null);
            }
        }
    }

    public void init() throws Exception {
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CODE_GEN_RESULTS_STEP_NAME_LABEL"));
        this.showProgressUI(true);
        this._done = false;
        ((CodeGenResultsState)this.m_state).setCanGoBack(this._done);
        this._userCancelled = false;
        this.enableWizardNavigationButtons();
        this._progressBar.setMaximum(((CodeGenResultsState)this.m_state).getAllStepsCount());
        this._labelTimer = new Timer(1, this);
        this._labelTimer.setRepeats(true);
        this._completionTimer = new Timer(1, this);
        this._completionTimer.setRepeats(false);
        Thread thread = new Thread(this);
        thread.setPriority(5);
        thread.start();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void processUserInput() {
    }

    public void updateProgress(int n, String string, String string2) {
        if (this._userCancelled) {
            return;
        }
        if (this._progressBar == null) {
            return;
        }
        this._completionStatus = n;
        if (ModelUtil.hasLength(string)) {
            this._progressText = string;
        }
        if (ModelUtil.hasLength(string2)) {
            this._stepText = string2;
        }
        if (this._labelTimer != null) {
            this._labelTimer.start();
        }
    }

    public boolean hasUserCancelled() {
        if (this._userCancelled) {
            this.setDoneStatus();
        }
        return this._userCancelled;
    }

    public boolean isUserCancelled() {
        return this._userCancelled;
    }

    public synchronized void setDoneStatus() {
        this._done = true;
        this.notifyAll();
        this.end();
        this.changeLayout();
        this.enableWizardNavigationButtons();
    }

    private void enableWizardNavigationButtons() {
        CodeGenWizard codeGenWizard = (CodeGenWizard)this.getparentWizardState().getWizard();
        if (codeGenWizard != null) {
            codeGenWizard.enableWizardButtons();
        }
    }

    public boolean isDone() {
        return this._done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (this._userCancelled) {
            return;
        }
        try {
            block5: {
                try {
                    ((CodeGenResultsState)this.m_state).generateCode(this);
                    if (((CodeGenResultsState)this.m_state).isClean()) break block5;
                    ((CodeGenResultsState)this.m_state).loadActivities();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var3_2 = null;
                    this.setDoneStatus();
                }
            }
            Object var3_1 = null;
            this.setDoneStatus();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setDoneStatus();
            throw throwable;
        }
    }

    private void end() {
        if (this._completionTimer != null) {
            this._completionTimer.start();
        }
    }
}

