/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenProcNameTableSorter;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenTargetState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class CodeGenEditProcNamePanel
extends GriddedPanel {
    private DM4JDialog m_parentDialog;
    private CodeGenTargetState m_state = null;
    private String m_procName;
    private int m_selRow = -1;
    private CodeGenProcNameTableSorter m_tableModel;
    private String m_recordType;
    private String m_tableType;
    private JLabel m_lblProcName = new JLabel();
    private JTextField m_edtProcName = new JTextField();
    private JCheckBox m_chkBoxRealTime;
    private JLabel m_lblRecordTypeName;
    private JTextField m_edRecordTypeName;
    private JLabel m_lblTableTypeName;
    private JTextField m_edTableTypeName;
    private static int LIMIT = 27;

    public CodeGenEditProcNamePanel(DM4JDialog dM4JDialog, CodeGenTargetState codeGenTargetState, CodeGenProcNameTableSorter codeGenProcNameTableSorter, int n) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = codeGenTargetState;
        this.m_tableModel = codeGenProcNameTableSorter;
        this.m_selRow = n;
        this.m_procName = codeGenProcNameTableSorter.getProcedureName(n);
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.m_lblProcName.setText(ResourceUtilities.getUILabel("CG_EDIT_PROC_NAME"));
        this.m_lblProcName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CG_EDIT_PROC_NAME"));
        this.m_lblProcName.setLabelFor(this.m_edtProcName);
        this.m_edtProcName.setColumns(LIMIT);
        this.m_edtProcName.setDocument(new SQLField(LIMIT));
        this.addComponent(this.m_lblProcName, COL1_LABEL, n, 0, 1, 1, 12, 2);
        this.addComponent(this.m_edtProcName, COL1_CONTROL, n++, 1, 2, 1, 12, 2);
        this.m_parentDialog.setInitialFocus(this.m_edtProcName);
        this.addOKHelpCancelListeners();
        this.m_edtProcName.setText(this.m_procName);
        if (!this.m_tableModel.isApplyActivity(this.m_selRow)) {
            return;
        }
        this.m_chkBoxRealTime = new JCheckBox();
        this.m_chkBoxRealTime.setText(ResourceUtilities.getUILabel("CODE_GEN_SQL_INTEGRATION"));
        boolean bl = this.m_tableModel.isRealTimeSupport(this.m_selRow);
        this.m_chkBoxRealTime.setSelected(bl);
        this.m_chkBoxRealTime.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JCheckBox jCheckBox = (JCheckBox)actionEvent.getSource();
                CodeGenEditProcNamePanel.this.enableTypes(jCheckBox.isSelected());
            }
        });
        this.addComponent(this.m_chkBoxRealTime, COL1_LABEL, n++, 0, 2, 1, 12, 2);
        this.m_lblRecordTypeName = new JLabel();
        this.m_edRecordTypeName = new JTextField(LIMIT);
        this.m_edRecordTypeName.setDocument(new SQLField(LIMIT));
        this.m_lblRecordTypeName.setText(ResourceUtilities.getUILabel("CG_EDIT_PROC_RECORD_TYPE"));
        this.m_lblRecordTypeName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CG_EDIT_PROC_RECORD_TYPE"));
        this.m_lblRecordTypeName.setLabelFor(this.m_edRecordTypeName);
        this.addComponent(this.m_lblRecordTypeName, COL1_INDENTED1_LABEL, n, 0, 1, 1, 12, 2);
        this.addComponent(this.m_edRecordTypeName, COL1_CONTROL, n++, 1, 2, 1, 12, 2);
        this.m_lblTableTypeName = new JLabel();
        this.m_edTableTypeName = new JTextField(LIMIT);
        this.m_edTableTypeName.setDocument(new SQLField(LIMIT));
        this.m_lblTableTypeName.setText(ResourceUtilities.getUILabel("CG_EDIT_PROC_TABLE_TYPE"));
        this.m_lblTableTypeName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CG_EDIT_PROC_TABLE_TYPE"));
        this.m_lblTableTypeName.setLabelFor(this.m_edTableTypeName);
        this.m_recordType = this.m_tableModel.getRecordTypeName(this.m_procName);
        this.m_tableType = this.m_tableModel.getTableTypeName(this.m_procName);
        this.m_edRecordTypeName.setText(this.m_recordType);
        this.m_edTableTypeName.setText(this.m_tableType);
        this.addComponent(this.m_lblTableTypeName, COL1_INDENTED1_LABEL, n, 0, 1, 1, 12, 2);
        this.addComponent(this.m_edTableTypeName, COL1_CONTROL, n, 1, 2, 1, 12, 2);
        this.enableTypes(bl);
    }

    private void enableTypes(boolean bl) {
        this.m_edRecordTypeName.setEnabled(bl);
        this.m_edTableTypeName.setEnabled(bl);
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeGenEditProcNamePanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        block6: {
            String string = actionEvent.getActionCommand();
            if ("ok" == string) {
                Vector vector = new Vector();
                String string2 = this.m_tableModel.getRecordTypeName(this.m_procName);
                String string3 = this.m_tableModel.getTableTypeName(this.m_procName);
                String string4 = this.m_procName;
                try {
                    this.validate(vector);
                    DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                    DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                    if (vector.isEmpty()) {
                        this.processUserInput();
                        break block6;
                    }
                    this.m_procName = string4;
                    this.m_tableModel.setRealTimeSupportTypes(this.m_procName, string2, string3);
                }
                catch (Exception exception) {
                    this.m_procName = string4;
                    this.m_tableModel.setRealTimeSupportTypes(this.m_procName, string2, string3);
                    exception.printStackTrace();
                }
            } else if ("cancel" == string) {
                // empty if block
            }
        }
    }

    private String convertToUpper(String string) {
        String string2 = DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase();
        return string2;
    }

    protected void validate(Vector vector) throws Exception {
        String string = this.convertToUpper(this.m_edtProcName.getText());
        if (string == null || 0 == string.length()) {
            vector.add(new StateValidation(DataStateError.CG_PROCEDURE_NAME_NON_EMPTY));
            return;
        }
        if (0 != this.m_procName.compareToIgnoreCase(string)) {
            this.m_state.validateProcedureName(string, vector);
            if (!vector.isEmpty()) {
                return;
            }
        }
        if (this.m_chkBoxRealTime == null || !this.m_chkBoxRealTime.isSelected()) {
            return;
        }
        String string2 = this.convertToUpper(this.m_edRecordTypeName.getText());
        if (string2 == null || 0 == string2.length()) {
            vector.add(new StateValidation(DataStateError.CG_RECORD_TYPE_NAME_NON_EMPTY));
            return;
        }
        if (!this.m_state.isValidDbNameName(string2)) {
            vector.add(new StateValidation(DataStateError.CG_RECORD_TYPE_NAME_INVALID));
            return;
        }
        String string3 = this.convertToUpper(this.m_edTableTypeName.getText());
        if (string3 == null || 0 == string3.length()) {
            vector.add(new StateValidation(DataStateError.CG_TABLE_TYPE_NAME_NON_EMPTY));
            return;
        }
        if (!this.m_state.isValidDbNameName(string3)) {
            vector.add(new StateValidation(DataStateError.CG_TABLE_TYPE_NAME_INVALID));
            return;
        }
        if (0 == string3.compareToIgnoreCase(string2)) {
            vector.add(new StateValidation(DataStateError.CG_TYPE_NAMES_EQUAL));
        }
    }

    protected void processUserInput() {
        String string = this.convertToUpper(this.m_edtProcName.getText());
        if (!DM4JStringUtils.isDoubleQuotedString(string)) {
            string = string.toUpperCase();
        }
        if (0 != this.m_procName.compareToIgnoreCase(string)) {
            this.m_tableModel.setProcedureName(string, this.m_selRow);
        }
        if (this.m_chkBoxRealTime == null) {
            this.m_procName = string;
            return;
        }
        boolean bl = this.m_chkBoxRealTime.isSelected();
        this.m_tableModel.setRealTimeSupport(this.m_selRow, bl);
        if (bl) {
            String string2;
            String string3 = this.convertToUpper(this.m_edRecordTypeName.getText());
            if (!DM4JStringUtils.isDoubleQuotedString(string3)) {
                string3 = string3.toUpperCase();
            }
            if (!DM4JStringUtils.isDoubleQuotedString(string2 = this.convertToUpper(this.m_edTableTypeName.getText()))) {
                string2 = string2.toUpperCase();
            }
            this.m_tableModel.removeRealTimeSupportTypes(this.m_procName);
            this.m_tableModel.setRealTimeSupportTypes(string, string3, string2);
            this.m_procName = string;
        }
    }

    public class SQLField
    extends PlainDocument {
        private int m_limit;

        SQLField(int n) {
            this.m_limit = n;
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string == null) {
                return;
            }
            if (this.getLength() + string.length() <= this.m_limit) {
                super.insertString(n, string, attributeSet);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

