/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenConnectionState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class CodeGenConnectionPanel
extends DM4JStep {
    private BorderLayout m_mainLayout = new BorderLayout();
    private MultiLineLabel m_connectionPrompt = new MultiLineLabel();
    private JPanel m_subPanel = new JPanel();
    private GridBagLayout m_subLayout = new GridBagLayout();
    private DefaultComboBoxModel m_connectionsModel = new DefaultComboBoxModel();
    protected JComboBox m_connectionsCombo = new JComboBox();
    private JLabel m_connectionLabel = new JLabel();
    private JPanel m_detailsPanel = new JPanel();
    private GridBagLayout m_detailsLayout = new GridBagLayout();
    private JLabel m_usernameLabel = new JLabel();
    private JLabel m_usernameField = new JLabel();
    private JLabel m_driverLabel = new JLabel();
    private JLabel m_driverField = new JLabel();
    private JLabel m_urlLabel = new JLabel();
    private JLabel m_urlField = new JLabel();

    public CodeGenConnectionPanel(CodeGenConnectionState codeGenConnectionState) throws Exception {
        super(codeGenConnectionState);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.m_connectionPrompt.setText(ResourceUtilities.getUILabel("CG_CHOOSE_CONNECTION"));
        this.m_connectionPrompt.setBorder(BorderFactory.createEmptyBorder(0, 0, 19, 0));
        Vector vector = ((CodeGenConnectionState)this.m_state).getConnectionNames();
        if (vector != null && 0 != vector.size()) {
            for (int i = 0; i < vector.size(); ++i) {
                this.m_connectionsModel.addElement(vector.elementAt(i));
            }
        }
        this.m_usernameLabel.setText(ResourceUtilities.getUILabel("CG_CONNECTION_DETAILS_USER"));
        this.m_driverLabel.setText(ResourceUtilities.getUILabel("CG_CONNECTION_DETAILS_DRIVER"));
        this.m_urlLabel.setText(ResourceUtilities.getUILabel("CG_CONNECTION_DETAILS_URL"));
        this.m_connectionsCombo = new JComboBox(this.m_connectionsModel);
        this.m_connectionsCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CodeGenConnectionPanel.this.updateConnDetails();
            }
        });
        String string = ((CodeGenConnectionState)this.m_state).getContextConnName();
        if (string != null) {
            this.m_connectionsModel.setSelectedItem(string);
        } else {
            this.m_connectionsCombo.setSelectedIndex(0);
        }
        this.updateConnDetails();
        this.m_connectionLabel.setText(ResourceUtilities.getUILabel("CG_CONNECTION_NAME"));
        this.m_connectionLabel.setLabelFor(this.m_connectionsCombo);
        this.m_detailsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.m_detailsPanel.setLayout(this.m_detailsLayout);
        this.m_detailsPanel.add((Component)this.m_usernameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_usernameField, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_driverLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_driverField, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_urlLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_detailsPanel.add((Component)this.m_urlField, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_subPanel.setLayout(this.m_subLayout);
        this.m_subPanel.add((Component)this.m_connectionLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.m_subPanel.add((Component)this.m_connectionsCombo, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.m_subPanel.add((Component)this.m_detailsPanel, new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 11, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.setLayout(this.m_mainLayout);
        this.add((Component)this.m_connectionPrompt, "North");
        this.add((Component)this.m_subPanel, "Center");
    }

    private void updateConnDetails() {
        String string = (String)this.m_connectionsCombo.getSelectedItem();
        this.m_usernameField.setText(((CodeGenConnectionState)this.m_state).getUserName(string));
        this.m_driverField.setText(((CodeGenConnectionState)this.m_state).getDriver(string));
        this.m_urlField.setText(((CodeGenConnectionState)this.m_state).getURL(string));
    }

    public void validate(Vector vector) throws Exception {
        this.m_state.validate(vector);
    }

    protected void processUserInput() {
        ((CodeGenConnectionState)this.m_state).setConnectionName((String)this.m_connectionsCombo.getSelectedItem());
    }
}

