/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricalDiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class CategoricalGenerateBinBoundsPanel
extends GriddedPanel {
    protected DM4JDialog m_parentDialog;
    protected WizardState m_state = null;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected SpreadTable m_spreadTable;
    protected JPanel pnlNumberOfBins = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblNumberOfBins = new JLabel();
    protected CustomNumberTextField txtNumberOfBins = new CustomNumberTextField();
    protected CategoricalDiscretizationSettingsState m_settingsState;

    public CategoricalGenerateBinBoundsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setColumns(10);
        this.txtNumberOfBins.setDataType(Integer.TYPE);
        this.txtNumberOfBins.setSigned(false);
        this.lblNumberOfBins.setLabelFor(this.txtNumberOfBins);
        this.pnlNumberOfBins.add(this.lblNumberOfBins);
        this.pnlNumberOfBins.add(this.txtNumberOfBins);
        this.m_parentDialog.setInitialFocus(this.txtNumberOfBins);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoricalGenerateBinBoundsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void validate(Vector vector) throws Exception {
        this.m_settingsState.validateBinNumberValue(vector);
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        this.m_settingsState.setRecalculate(true);
    }

    protected void loadState() throws Exception {
        if (this.m_state == null) {
            throw new Exception();
        }
        this.m_settingsState = (CategoricalDiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_2);
        int n = this.m_settingsState.getCurrentNumberOfBins();
        this.txtNumberOfBins.setNumber(new Integer(n));
    }

    protected void updateNumberOfBins(Number number) {
        this.m_settingsState.setCurrentNumberOfBins(number.intValue());
    }

    protected class CustomNumberTextField
    extends NumberTextField {
        CustomNumberTextField() {
            this.setLocale(Locale.getDefault());
            this.addKeyListener(new KeyAdapter(){

                public void keyReleased(KeyEvent keyEvent) {
                    super.keyReleased(keyEvent);
                    if (127 == keyEvent.getKeyCode() || 8 == keyEvent.getKeyCode()) {
                        Number number = CustomNumberTextField.this.getNumber();
                        int n = 0;
                        if (number != null) {
                            n = number.intValue();
                        }
                        Integer n2 = new Integer(n);
                        CustomNumberTextField.this.validateNumber(n2);
                    }
                }
            });
        }

        protected boolean validateNumber(Number number) {
            boolean bl = super.validateNumber(number);
            if (bl && number != null) {
                CategoricalGenerateBinBoundsPanel.this.updateNumberOfBins(number);
            }
            return bl;
        }
    }
}

