/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.DiscretizeState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricalDiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.GenerateDefaultsDialog;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.BinningStrategyDialog;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;
import oracle.dmt.odm.binning.BinningType;

public class CategoricDiscretizationSettingsPanel
extends DM4JStep
implements ItemListener {
    CategoricalDiscretizationSettingsState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JScrollPane paneSpread = new JScrollPane();
    SpreadTable spreadTable = new SpreadTable();
    JButton butEdit = new JButton();
    JButton butTopN = new JButton();
    JButton butHistogram = new JButton();
    JButton butRestore = new JButton();
    JButton butClear = new JButton();
    private CategoricDiscretizeDataSource m_model = null;
    private ComponentAdapter m_componentListener = null;
    JLabel lblFiller = new JLabel();
    private int[] m_columnWidths = new int[]{35, 0, 0, 0, 0, 0, 13, 13, 13, 0, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private ArrayOneDModel m_colModel = null;
    private int[] m_columnWidthsPercent = null;
    private boolean m_isWidthsPercent = false;
    private UserPreferences m_preferences = null;

    public CategoricDiscretizationSettingsPanel(CategoricalDiscretizationSettingsState categoricalDiscretizationSettingsState) throws Exception {
        super(categoricalDiscretizationSettingsState);
        this.m_state = categoricalDiscretizationSettingsState;
        this.jbInit();
        this.m_preferences = UserPreferences.getInstance();
    }

    private void jbInit() throws Exception {
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("DISCRETIZE_SETTINGS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        int n = 0;
        int n2 = 0;
        int n3 = 6;
        int n4 = 1;
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n, n2, n3, n4, 1);
        BrowserContext browserContext = this.m_state.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CategoricDiscretizationSettingsPanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
        } else {
            this.butRestore.setText(ResourceUtilities.getUILabel("GENERATE_DEFAULTS"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("GENERATE_DEFAULTS"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    CategoricDiscretizationSettingsPanel.this.butGenerateDefaults_actionPerformed(actionEvent);
                }
            });
        }
        n = 1;
        n2 = 4;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butRestore, COL1_CONTROL, n, n2, n3, n4, 13, 0);
        this.paneSpread.getViewport().add((Component)this.spreadTable, null);
        n = 2;
        n2 = 0;
        n3 = 5;
        n4 = 5;
        this.addComponent(this.paneSpread, COL1_CONTROL, n, n2, n3, n4, 17, 1);
        this.butEdit.setText(ResourceUtilities.getUILabel("DEFINE_BUTTON"));
        this.butEdit.setEnabled(false);
        this.butEdit.setMnemonic(ResourceUtilities.getUIMnemonic("DEFINE_BUTTON"));
        this.butEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoricDiscretizationSettingsPanel.this.butEdit_actionPerformed(actionEvent);
            }
        });
        n = 2;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butEdit, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butTopN.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_TOP_N_OPTION"));
        this.butTopN.setEnabled(false);
        this.butTopN.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_TOP_N_OPTION"));
        n = 3;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butTopN, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butTopN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoricDiscretizationSettingsPanel.this.butTopN_actionPerformed(actionEvent);
            }
        });
        this.butClear.setText(ResourceUtilities.getUILabel("CLEAR_BUTTON"));
        this.butClear.setMnemonic(ResourceUtilities.getUIMnemonic("CLEAR_BUTTON"));
        n = 4;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butClear, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoricDiscretizationSettingsPanel.this.butClearAll_actionPerformed(actionEvent);
            }
        });
        this.butHistogram.setText(ResourceUtilities.getUILabel("DISCRETIZATION_HISTOGRAM"));
        this.butHistogram.setEnabled(false);
        this.butHistogram.setMnemonic(ResourceUtilities.getUIMnemonic("DISCRETIZATION_HISTOGRAM"));
        n = 5;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butHistogram, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CategoricDiscretizationSettingsPanel.this.butHistogram_actionPerformed(actionEvent);
            }
        });
        n = 6;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, n2, n3, n4, 3);
        JButton[] jButtonArray = new JButton[]{this.butEdit, this.butHistogram, this.butRestore, this.butClear, this.butTopN};
        DM4JResourceUtilities.setPreferredSize(jButtonArray);
    }

    public void init() throws Exception {
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void loadDefaultValues() throws Exception {
        if (this.m_state != null) {
            DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
            this.m_model = discretizationDataUsageState.getCategoricModel();
            this.m_colModel = this.m_model.getColumnDataSource();
            this.spreadTable.setModels(this.m_model, this.m_model.getColumnDataSource(), null);
            TwoDSelection twoDSelection = this.getOldSelection();
            this.setSpread();
            this.restoreSelection(twoDSelection);
        }
    }

    private TwoDSelection getOldSelection() {
        return this.spreadTable.getSelection();
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            // empty if block
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        System.out.println(itemEvent.toString());
    }

    protected void setSpread() throws Exception {
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance());
        this.spreadTable.getGrid().setColumnPainter(CategoricDiscretizeDataSource.COLUMN_NAMES.TOTAL, dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(CategoricDiscretizeDataSource.COLUMN_NAMES.DISTINCT, dM4JTruncatingNumberFormatPainter);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.MTYPE, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.DTYPE, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.BINNUMBER, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.BINBOUNDS, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.VIEW_DEFN, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.DISPLAY_NAMES, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.MISSING_PERCENT, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.DROP_ATTRIBUTE, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_3, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_4, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_5, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.DEFAULT_ALGORITHM, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.SPARSITY_FLAG, false);
        this.spreadTable.setColumnVisible(CategoricDiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_6, false);
        Header header = this.spreadTable.getColumnHeader();
        if (header != null) {
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setCanMoveItems(false);
            header.setHeaderKeyHandler(new KeyHandler());
        }
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        generalGridSelectionManager.addPropertyChangeListener(new SelectionListener());
        this.spreadTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
        Header header2 = this.spreadTable.getRowHeader();
        if (header2 != null) {
            header2.setCanMoveItems(false);
            header2.setCanResizeItems(false);
            header2.setHeaderSelectionManager(new GeneralHeaderSelectionManager(2));
            this.spreadTable.setRowHeaderWidth(50);
        }
        this.m_state.getparentWizardState().getDialog().pack();
        if (this.m_isWidthsPercent) {
            this.setColumnWidthsPercent(this.m_columnWidthsPercent);
        } else {
            this.setColumnWidths(this.m_columnWidths, true);
        }
    }

    protected void butClearAll_actionPerformed(ActionEvent actionEvent) {
        try {
            OneDSelection oneDSelection;
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(true);
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            TwoDSelection twoDSelection = this.spreadTable.getSelection();
            if (twoDSelection != null && (oneDSelection = twoDSelection.getRowSelection()) != null) {
                Range[] rangeArray = oneDSelection.getRanges();
                if (rangeArray != null) {
                    for (int i = 0; i < rangeArray.length; ++i) {
                        int n = rangeArray[i].getLowerLimit();
                        int n2 = rangeArray[i].getUpperLimit();
                        for (int j = n; j <= n2; ++j) {
                            if (!this.m_model.isAttributeBinned(j)) continue;
                            this.m_model.markAttributeUnBinned(j);
                            String string = this.m_model.getAttributeName(j);
                            string = this.m_model.getColumnName(string);
                            vector.add(string);
                            hashtable.put(string, new Integer(j));
                        }
                    }
                } else {
                    DialogUtilities.createUIErrorDialog(this.getparentWizardState().getDialog(), "ATTRIBUTE_SELECTION_REQUIRED");
                }
                this.m_state.invalidate();
            }
            this.m_model.addCatedoricStats(vector, hashtable, null);
            this.spreadTable.deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        if (this.m_model.getRowCount() == 0) {
            return;
        }
        int n = JOptionPane.showOptionDialog(this, ResourceUtilities.getUILabel("DISCRETIZATION_SETTINGS_RESTORE"), ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null);
        if (n == 1 || n == -1) {
            return;
        }
        try {
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(true);
            this.m_model.restoreDefaultTreatment();
            Object var4_3 = null;
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
            throw throwable;
        }
    }

    protected void butGenerateDefaults_actionPerformed(ActionEvent actionEvent) {
        block2: {
            try {
                GenerateDefaultsDialog generateDefaultsDialog = GenerateDefaultsDialog.createCategoricalDiscretizeDefaultsDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), this.spreadTable, this.m_model);
                this.m_state.invalidate();
            }
            catch (Exception exception) {
                if (!CategoricDiscretizeDataSource.isDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    protected void butEdit_actionPerformed(ActionEvent actionEvent) {
        this.butShortCut_actionPerformed(actionEvent, BinningType.CUSTOM);
    }

    protected void butTopN_actionPerformed(ActionEvent actionEvent) {
        this.butShortCut_actionPerformed(actionEvent, BinningType.TOPN);
    }

    protected void butShortCut_actionPerformed(ActionEvent actionEvent, BinningType binningType) {
        block2: {
            try {
                BinningStrategyDialog binningStrategyDialog = new BinningStrategyDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), this.spreadTable, binningType);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
                if (!CategoricDiscretizeDataSource.isDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void butHistogram_actionPerformed(ActionEvent actionEvent) {
        block2: {
            try {
                DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
                discretizationDataUsageState.setHistogramNumeric(false);
                DiscretizeState discretizeState = (DiscretizeState)this.m_state.getparentWizardState();
                HistogramDialog histogramDialog = new HistogramDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), this.spreadTable, discretizeState.getGraph());
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
                if (!CategoricDiscretizeDataSource.isDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void validatePercentageAllocation(int[] nArray) throws Exception {
        int n = this.m_colModel.getItemCount();
        if (nArray.length != n) {
            throw new Exception("Number of columns does not match the number of percentage items");
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 += nArray[i];
        }
        if (n2 > 100) {
            throw new Exception("Total percentage exceeds 100 percent - check percentages");
        }
    }

    public void setColumnWidths(int[] nArray, boolean bl) throws Exception {
        if (bl && null != nArray) {
            this.validatePercentageAllocation(nArray);
            this.setColumnWidthsPercent(nArray);
        } else {
            this.resizeColumns(nArray);
        }
        if (null != this.m_componentListener) {
            this.spreadTable.getGrid().removeComponentListener(this.m_componentListener);
            this.m_componentListener = null;
        }
        this.m_componentListener = new Resizer(this.spreadTable);
        Container container = this.getParent().getParent();
        container.addComponentListener(this.m_componentListener);
    }

    private void setColumnWidthsPercent(int[] nArray) {
        int n = this.m_colModel.getItemCount();
        JViewport jViewport = this.spreadTable.getViewport();
        if (jViewport == null) {
            return;
        }
        int n2 = jViewport.getExtentSize().width;
        this.m_columnWidthsPercent = new int[nArray.length];
        System.arraycopy(nArray, 0, this.m_columnWidthsPercent, 0, nArray.length);
        this.m_columnWidths = new int[nArray.length];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = (int)((float)n2 / 100.0f * (float)nArray[i]);
            if (i == n - 1) {
                n4 = n2 < n3 + n4 ? n4 : n2 - n3 - this.m_colModel.getItemCount();
            }
            n3 += n4;
            this.m_columnWidths[i] = n4;
        }
        this.m_isWidthsPercent = true;
        this.resizeColumns(this.m_columnWidths);
    }

    private void resizeColumns(int[] nArray) {
        this.m_columnWidths = nArray;
        if (null == nArray) {
            int n = this.m_colModel.getItemCount();
            JViewport jViewport = this.spreadTable.getViewport();
            int n2 = jViewport.getExtentSize().width;
            if (0 == n2) {
                return;
            }
            int n3 = n2 / n;
            int n4 = n2 % n;
            for (int i = 0; i < n; ++i) {
                this.spreadTable.setColumnWidth(i, i == n - 1 ? n3 + n4 - this.m_colModel.getItemCount() : n3);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.spreadTable.setColumnWidth(i, this.m_columnWidths[i]);
            }
        }
    }

    private void restoreSelection(TwoDSelection twoDSelection) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (twoDSelection != null) {
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            Range[] rangeArray = oneDSelection.getRanges();
            boolean bl4 = bl = rangeArray != null;
            if (rangeArray == null || rangeArray.length != 1) {
                bl2 = false;
                bl3 = false;
            } else if (rangeArray[0].getLowerLimit() != rangeArray[0].getUpperLimit()) {
                bl2 = false;
                bl3 = false;
            } else if (!this.m_model.isNumeric(rangeArray[0].getLowerLimit())) {
                bl2 = false;
                bl3 = false;
            }
            try {
                this.spreadTable.setSelection(twoDSelection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.butEdit.setEnabled(bl2);
        this.butHistogram.setEnabled(bl3);
        this.butTopN.setEnabled(bl);
    }

    class Resizer
    extends ComponentAdapter {
        private SpreadTable _spreadTable;

        public Resizer(SpreadTable spreadTable) {
            this._spreadTable = spreadTable;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this._spreadTable.invalidate();
            if (CategoricDiscretizationSettingsPanel.this.m_isWidthsPercent) {
                CategoricDiscretizationSettingsPanel.this.setColumnWidthsPercent(CategoricDiscretizationSettingsPanel.this.m_columnWidthsPercent);
            } else {
                CategoricDiscretizationSettingsPanel.this.resizeColumns(null);
            }
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = true;
            boolean bl2 = true;
            boolean bl3 = true;
            TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getNewValue();
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            Range[] rangeArray = oneDSelection.getRanges();
            boolean bl4 = bl = rangeArray != null;
            if (rangeArray == null || rangeArray.length != 1) {
                bl2 = false;
                bl3 = false;
            } else if (rangeArray[0].getLowerLimit() != rangeArray[0].getUpperLimit()) {
                bl2 = false;
                bl3 = false;
            }
            CategoricDiscretizationSettingsPanel.this.butEdit.setEnabled(bl2);
            CategoricDiscretizationSettingsPanel.this.butHistogram.setEnabled(bl3);
            CategoricDiscretizationSettingsPanel.this.butTopN.setEnabled(bl);
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                SortInputHandler sortInputHandler = (SortInputHandler)header.getItemInputHandler();
                sortInputHandler.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }
}

