/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundaryTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;

public class AddNewCategoricalBinPanel
extends GriddedPanel {
    protected DM4JDialog m_parentDialog;
    protected WizardState m_state = null;
    protected CategoricDiscretizeDataSource m_model;
    protected CategoricBinBoundaryTableModel m_tableModel;
    protected int m_selectedRow;
    protected Vector m_UnbinnedList = null;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected JLabel lblDistinctValues = new JLabel();
    protected JComboBox comboDistincts = new JComboBox();
    protected DefaultComboBoxModel m_Distincts = new DefaultComboBoxModel();
    protected JLabel lblBinValues = new JLabel();
    protected JTextField txtBinCategory = new JTextField();

    public AddNewCategoricalBinPanel(DM4JDialog dM4JDialog, WizardState wizardState, CategoricBinBoundaryTableModel categoricBinBoundaryTableModel, int n, Vector vector) throws Exception {
        try {
            this.m_parentDialog = dM4JDialog;
            this.m_state = wizardState;
            this.m_tableModel = categoricBinBoundaryTableModel;
            DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.m_state.getStep(StepType.DATA_USAGE_STEP);
            this.m_model = discretizationDataUsageState.getCategoricModel();
            this.m_selectedRow = n;
            this.m_UnbinnedList = vector;
            this.jbInit();
        }
        catch (Exception exception) {
            if (CategoricDiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
            throw exception;
        }
    }

    protected void loadCombo() {
        this.m_Distincts = new DefaultComboBoxModel(this.m_UnbinnedList);
        this.comboDistincts.setModel(this.m_Distincts);
    }

    protected void jbInit() throws Exception {
        this.loadCombo();
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ADDING_NEW_CATEGORICAL_BIN_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 4, 1, 1);
        this.lblDistinctValues.setText(ResourceUtilities.getUILabel("BINNING_ADD_CATEGORICAL_DISTINCT_VALUES"));
        this.addComponent(this.lblDistinctValues, COL1_INDENTED1_LABEL, n, 0, 1, 1, 12, 1);
        this.addComponent(this.comboDistincts, COL1_CONTROL, n, 1, 2, 1, 18, 1);
        this.addComponent(new JLabel(), COL1_CONTROL, n++, 3, 1, 1, 18, 1);
        this.lblBinValues.setText(ResourceUtilities.getUILabel("CUSTOM_BINNING_BIN_NUMBER"));
        this.lblBinValues.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CUSTOM_BINNING_BIN_NUMBER"));
        this.addComponent(this.lblBinValues, COL1_INDENTED1_LABEL, n, 0, 1, 1, 12, 1);
        this.addComponent(this.txtBinCategory, COL1_CONTROL, n, 1, 2, 1, 18, 1);
        this.addComponent(new JLabel(), COL1_CONTROL, n++, 3, 1, 1, 18, 1);
        this.addOKHelpCancelListeners();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddNewCategoricalBinPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        block7: {
            String string = actionEvent.getActionCommand();
            if ("ok" == string) {
                Vector<StateValidation> vector = new Vector<StateValidation>();
                try {
                    String string2 = this.txtBinCategory.getText();
                    if (string2 == null || string2.length() == 0) {
                        vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_EMPTY_BIN_BOUNDARIES));
                    } else if (-1 != this.m_tableModel.getBinCategoryPosition(string2)) {
                        vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZATION_CATEGORICAL_EXISTING_CATEGORY));
                    }
                    String string3 = (String)this.comboDistincts.getSelectedItem();
                    DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                    DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                    if (vector.isEmpty()) {
                        this.processUserInput();
                    }
                }
                catch (Exception exception) {
                    if (!CategoricDiscretizeDataSource.isDebug()) break block7;
                    exception.printStackTrace();
                }
            }
        }
    }

    protected void processUserInput() {
        Vector<String> vector = new Vector<String>();
        String string = this.txtBinCategory.getText();
        vector.add((String)this.comboDistincts.getSelectedItem());
        this.m_tableModel.addEntry(new CategoricBinBoundary(string, vector));
    }
}

