/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundaryTableModel;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;

public class AddNewBinPanel
extends GriddedPanel {
    protected DM4JDialog m_parentDialog;
    protected WizardState m_state = null;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected JPanel pnlLowerBoundValue = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblLowerBoundValue = new JLabel();
    protected JTextField txtLowerBoundValue;
    protected JSlider binRange = new JSlider(0);
    protected BinBoundaryTableModel m_tableModel;
    protected int m_min;
    protected int m_max;
    protected boolean m_update = true;

    public AddNewBinPanel(DM4JDialog dM4JDialog, WizardState wizardState, BinBoundaryTableModel binBoundaryTableModel, int n, int n2) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_tableModel = binBoundaryTableModel;
        this.m_min = n;
        this.m_max = n2;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        Serializable serializable;
        int n = 0;
        if (this.m_tableModel.getRowCount() > 0) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ADDING_NEW_BIN_DIALOG_DESCRIPTION"));
        } else {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ADDING_DEFAULT_BIN_DIALOG_DESCRIPTION"));
        }
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        int n2 = (this.m_max + this.m_min) / 2;
        this.addFilledComponent(this.pnlLowerBoundValue, COL1_INDENTED1_LABEL, n++, 0, 1, 1, 1);
        this.lblLowerBoundValue.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_LOWER_BOUND"));
        this.lblLowerBoundValue.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_LOWER_BOUND"));
        if (this.m_tableModel.getRowCount() > 0) {
            this.txtLowerBoundValue = new CustomNumberTextField();
            serializable = (CustomNumberTextField)this.txtLowerBoundValue;
            ((JTextField)serializable).setColumns(10);
            ((NumberTextField)serializable).setDataType(Double.TYPE);
            ((NumberTextField)serializable).setNumber(new Double(n2));
            this.m_parentDialog.setInitialFocus((Component)serializable);
            ((Component)serializable).addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    AddNewBinPanel.this.m_update = false;
                }

                public void keyReleased(KeyEvent keyEvent) {
                    AddNewBinPanel.this.m_update = true;
                }
            });
        } else {
            this.txtLowerBoundValue = new JTextField(ResourceUtilities.getUILabel("BINNING_STRATEGY_NO_UPPER_BOUND"));
            this.txtLowerBoundValue.setEnabled(false);
            this.binRange.setEnabled(false);
        }
        this.lblLowerBoundValue.setLabelFor(this.txtLowerBoundValue);
        this.pnlLowerBoundValue.add(this.lblLowerBoundValue);
        this.pnlLowerBoundValue.add(this.txtLowerBoundValue);
        this.binRange.setMinimum(this.m_min);
        this.binRange.setMaximum(this.m_max);
        this.binRange.setValue(n2);
        serializable = new Hashtable();
        ((Hashtable)serializable).put(new Integer(this.m_min), new JLabel(ResourceUtilities.getUILabel("ADDING_NEW_BIN_MIN")));
        ((Hashtable)serializable).put(new Integer(this.m_max), new JLabel(ResourceUtilities.getUILabel("ADDING_NEW_BIN_MAX")));
        this.binRange.setLabelTable((Dictionary)((Object)serializable));
        this.binRange.setPaintLabels(true);
        this.binRange.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AddNewBinPanel.this.slider_actionPerformed(changeEvent);
            }
        });
        this.addFilledComponent(this.binRange, COL1_CONTROL, ++n, 0, 4, 1, 1);
        this.addOKHelpCancelListeners();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddNewBinPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector<StateValidation> vector = new Vector<StateValidation>();
            try {
                double d;
                Serializable serializable;
                if (this.txtLowerBoundValue instanceof CustomNumberTextField) {
                    serializable = (CustomNumberTextField)this.txtLowerBoundValue;
                    Double d2 = (Double)serializable.getNumber();
                    double d3 = d = d2 == null ? 0.0 : d2;
                    if (d < (double)this.m_min || d > (double)this.m_max) {
                        String string2 = ResourceUtilities.getstateExceptionMessage("DISCRETIZE_INVALID_BIN_BOUNDARIES");
                        vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_BOUNDARIES, string2, new String[]{String.valueOf((double)this.m_min), String.valueOf((double)this.m_max)}));
                    }
                } else {
                    d = this.m_min;
                }
                serializable = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, (DM4JEvent)serializable, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput(d);
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    protected void processUserInput(double d) {
        int n = this.m_tableModel.getRowCount();
        if (n == 0) {
            this.m_tableModel.addEntry(new BinBoundary(new Integer(1), new Double(d)));
            return;
        }
        BinBoundary binBoundary = this.m_tableModel.getFieldEntry(0);
        double d2 = binBoundary.getLowerBound();
        if (d < d2) {
            this.m_tableModel.addEntry(0, new BinBoundary(new Integer(1), new Double(d)));
            return;
        }
        BinBoundary binBoundary2 = this.m_tableModel.getFieldEntry(n - 1);
        double d3 = binBoundary2.getLowerBound();
        if (d > d3) {
            this.m_tableModel.addEntry(n, new BinBoundary(new Integer(n + 1), new Double(d)));
            return;
        }
        if (n > 0 && n < 3) {
            for (int i = 0; i < n; ++i) {
                BinBoundary binBoundary3 = this.m_tableModel.getFieldEntry(i);
                double d4 = binBoundary3.getLowerBound();
                if (!(d < d4)) continue;
                this.m_tableModel.addEntry(i, new BinBoundary(new Integer(i + 1), new Double(d)));
                return;
            }
        } else {
            int n2 = 0;
            int n3 = n - 1;
            int n4 = n2;
            int n5 = n3 / 2;
            while (n4 < n5) {
                BinBoundary binBoundary4 = this.m_tableModel.getFieldEntry(n4);
                BinBoundary binBoundary5 = this.m_tableModel.getFieldEntry(n5);
                double d5 = binBoundary4.getLowerBound();
                double d6 = binBoundary5.getLowerBound();
                if (d == d5 || d == d6) break;
                if (d > d5 && d < d6) {
                    if (n5 - n4 == 1) {
                        this.m_tableModel.addEntry(n5, new BinBoundary(new Integer(n5 + 1), new Double(d)));
                        break;
                    }
                    n3 = n5;
                    n5 = (n4 + n5) / 2;
                    continue;
                }
                n4 = n5;
                n5 = n3;
            }
        }
    }

    protected void slider_actionPerformed(ChangeEvent changeEvent) {
        if (!this.m_update) {
            return;
        }
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        CustomNumberTextField customNumberTextField = (CustomNumberTextField)this.txtLowerBoundValue;
        customNumberTextField.setNumber(new Double(n));
    }

    protected class CustomNumberTextField
    extends NumberTextField {
        CustomNumberTextField() {
            this.setLocale(Locale.getDefault());
        }

        protected boolean validateNumber(Number number) {
            boolean bl = super.validateNumber(number);
            if (bl && number != null && !AddNewBinPanel.this.binRange.getValueIsAdjusting()) {
                AddNewBinPanel.this.binRange.setValue(number.intValue());
            }
            return bl;
        }
    }
}

