/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.miningsteps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.wizard.dialogs.GeneralizedLinearModelDialog;
import oracle.dmt.dm4j.wizard.dialogs.SupportVectorMachineDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JStep;

public class RegressionAlgorithmPanel
extends DM4JStep {
    RegressionAlgorithmState m_state;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblAttributeCount = new JLabel();
    JLabel lblSelectedAttributeCountValue = new JLabel();
    JLabel lblCaseCount = new JLabel();
    JLabel lblCaseCountValue = new JLabel();
    JLabel lblAlgoSVM = new JLabel();
    JLabel lblAlgoGLM = new JLabel();
    JLabel lblAlgorithmTypes = new JLabel();
    JComboBox comboAlgorithmTypes = new JComboBox();
    DefaultComboBoxModel AlgorithmTypesModel;
    JLabel lblAlgorithmTypesHint1 = new JLabel();
    JLabel lblSVMHint1 = new JLabel();
    JLabel lblSVMHint2 = new JLabel();
    JLabel lblSVMHint3 = new JLabel();
    JLabel lblGLMHint1 = new JLabel();
    JButton butSettingsSVM = new JButton();
    JButton butSettingsGLM = new JButton();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreAlgorithmTypeEvent;

    public RegressionAlgorithmPanel(WizardState wizardState, RegressionAlgorithmState regressionAlgorithmState) throws Exception {
        super(wizardState, regressionAlgorithmState);
        this.m_state = regressionAlgorithmState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 60;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setPreferredColumns(n11);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblAttributeCount.setText(ResourceUtilities.getUILabel("SELECTED_ATTRIBUTE_COUNT"));
        this.lblAttributeCount.setLabelFor(this.lblSelectedAttributeCountValue);
        this.add((Component)this.lblAttributeCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n10, n4, n5, n6), n7, n8));
        ++n2;
        this.add((Component)this.lblSelectedAttributeCountValue, new GridBagConstraints(n2, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(n3 + n10, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblCaseCount.setText(ResourceUtilities.getUILabel("SAMPLE_CASE_COUNT"));
        this.lblCaseCount.setLabelFor(this.lblCaseCountValue);
        this.add((Component)this.lblCaseCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        ++n2;
        this.add((Component)this.lblCaseCountValue, new GridBagConstraints(n2, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblAlgorithmTypes.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_ALGORITHM"));
        this.lblAlgorithmTypes.setLabelFor(this.lblAlgoSVM);
        this.add((Component)this.lblAlgorithmTypes, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        n2 = 1;
        if (this.m_state.isSupportVectorMachineSelected()) {
            this.lblAlgoSVM.setText(ResourceUtilities.getUILabel("SVM_OPTION_NAME"));
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoSVM);
            this.add((Component)this.lblAlgoSVM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isGeneralizedLinearModelSelected()) {
            this.lblAlgoGLM.setText(ResourceUtilities.getUILabel("GLM_OPTION_NAME"));
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoGLM);
            this.add((Component)this.lblAlgoGLM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isSupportVectorMachineSelected()) {
            ++n;
            this.lblSVMHint1.setText(ResourceUtilities.getUILabel("SVM_HINT1"));
            this.add((Component)this.lblSVMHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.butSettingsSVM.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsSVM.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsSVM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RegressionAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsSVM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isGeneralizedLinearModelSelected()) {
            ++n;
            this.lblGLMHint1.setText(ResourceUtilities.getUILabel("GLM_HINT1"));
            this.add((Component)this.lblGLMHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.butSettingsGLM.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsGLM.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsGLM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    RegressionAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsGLM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        ++n;
        n2 = 0;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 2, 1, 0.5, 0.5, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
    }

    protected void processUserInput() {
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() {
        this.setCounts();
        this.loadDetails();
    }

    public void reinit() {
        this.init();
    }

    protected void setCounts() {
        this.lblSelectedAttributeCountValue.setText(DM4JNumericFormat.format(this.m_state.getActiveAttributeCountExcludingTargets()));
        this.lblCaseCountValue.setText(DM4JNumericFormat.format(this.m_state.getCaseCount()));
    }

    protected void displayAlgorithmTypeRelatedControls() {
        this.lblSVMHint1.setVisible(this.m_state.isSupportVectorMachineSelected());
        this.butSettingsSVM.setVisible(this.m_state.isSupportVectorMachineSelected());
        this.lblGLMHint1.setVisible(this.m_state.isGeneralizedLinearModelSelected());
        this.butSettingsGLM.setVisible(this.m_state.isGeneralizedLinearModelSelected());
    }

    protected void loadAlgorithmTypesCombo() {
        this.m_ignoreAlgorithmTypeEvent = true;
        Vector<String> vector = new Vector<String>();
        vector.add("Support Vector Machine");
        vector.add("Generalized Linear Model");
        this.AlgorithmTypesModel = new DefaultComboBoxModel(vector);
        this.comboAlgorithmTypes.setModel(this.AlgorithmTypesModel);
        if (this.m_state.isSupportVectorMachineSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("Support Vector Machine");
        } else if (this.m_state.isGeneralizedLinearModelSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("Generalized Linear Model");
        }
        this.m_ignoreAlgorithmTypeEvent = false;
    }

    protected void comboAlgorithmTypes_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreAlgorithmTypeEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                this.m_state.setSupportVectorMachineSelected(string.equals("Support Vector Machine"));
                this.m_state.setGeneralizedLinearModelSelected(string.equals("Generalized Linear Model"));
                this.displayAlgorithmTypeRelatedControls();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void loadDetails() {
        this.loadAlgorithmTypesCombo();
        this.displayAlgorithmTypeRelatedControls();
    }

    protected void butSettings_actionPerformed(ActionEvent actionEvent) {
        if (this.m_state.isSupportVectorMachineSelected()) {
            try {
                SupportVectorMachineDialog supportVectorMachineDialog = new SupportVectorMachineDialog(this.getparentWizardState().getDialog(), this.m_state.getSupportVectorMachine());
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if (this.m_state.isGeneralizedLinearModelSelected()) {
            try {
                GeneralizedLinearModelDialog generalizedLinearModelDialog = new GeneralizedLinearModelDialog(this.getparentWizardState().getDialog(), this.m_state);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        }
    }

    public void clear() {
        this.loadDetails();
    }
}

