/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.miningsteps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.datamining.MiningAlgorithm;
import javax.datamining.base.Model;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.AnomalyDetectionModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelLiftState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelTestState;
import oracle.dmt.dm4j.wizard.state.minings.ClusteringModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.FeatureExtractionModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.RegressionModelApplyState;
import oracle.dmt.dm4j.wizard.state.minings.RegressionModelTestState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationTestSettingState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;

public class ModelPanel
extends DM4JStep {
    ModelState m_state;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblModelName = new JLabel();
    JLabel lblModelNameValue = new JLabel();
    JComboBox comboModel = new JComboBox();
    DefaultComboBoxModel modelModel;
    JLabel lblModelAlgorithm = new JLabel();
    JLabel lblModelAlgorithmValue = new JLabel();
    JLabel lblModelInputData = new JLabel();
    JLabel lblModelInputDataSchema = new JLabel();
    JLabel lblModelInputDataSchemaValue = new JLabel();
    JLabel lblModelInputDataTable = new JLabel();
    JLabel lblModelInputDataTableValue = new JLabel();
    JLabel lblModelBuildDate = new JLabel();
    JLabel lblModelBuildDateValue = new JLabel();
    JLabel lblModelBuildTime = new JLabel();
    JLabel lblModelBuildTimeValue = new JLabel();
    String m_notAvailable;
    JLabel lblFiller = new JLabel();
    boolean m_ignoreComboEvent = false;

    public ModelPanel(WizardState wizardState, ModelState modelState) throws Exception {
        super(wizardState, modelState);
        this.m_state = modelState;
        this.jbInit();
        this.setState();
    }

    private void setState() throws Exception {
        Class<ClassificationModelLiftState> clazz = ClassificationModelLiftState.class;
        Class<ClassificationModelTestState> clazz2 = ClassificationModelTestState.class;
        Class<RegressionModelTestState> clazz3 = RegressionModelTestState.class;
        Class<ClassificationModelApplyState> clazz4 = ClassificationModelApplyState.class;
        Class<RegressionModelApplyState> clazz5 = RegressionModelApplyState.class;
        Class<FeatureExtractionModelApplyState> clazz6 = FeatureExtractionModelApplyState.class;
        Class<ClusteringModelApplyState> clazz7 = ClusteringModelApplyState.class;
        Class<AnomalyDetectionModelApplyState> clazz8 = AnomalyDetectionModelApplyState.class;
        if (clazz2.isInstance(this.m_state.getparentWizardState()) || clazz3.isInstance(this.m_state.getparentWizardState())) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("MODEL_STEP_TEST_DESCRIPTION"));
        } else if (clazz.isInstance(this.m_state.getparentWizardState())) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("MODEL_STEP_LIFT_DESCRIPTION"));
        } else if (clazz4.isInstance(this.m_state.getparentWizardState()) || clazz7.isInstance(this.m_state.getparentWizardState()) || clazz5.isInstance(this.m_state.getparentWizardState()) || clazz6.isInstance(this.m_state.getparentWizardState()) || clazz8.isInstance(this.m_state.getparentWizardState())) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("MODEL_STEP_APPLY_DESCRIPTION"));
        } else {
            this.mlblStepDescription.setText("Unknown wizard.");
        }
    }

    private void jbInit() throws Exception {
        DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        n2 = 0;
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 0.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblModelName.setText(ResourceUtilities.getUILabel("MODEL_NAME"));
        this.lblModelName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("MODEL_NAME"));
        if (((WizardState)this.getparentWizardState()).isNew()) {
            this.lblModelName.setLabelFor(this.comboModel);
        } else {
            this.lblModelName.setLabelFor(this.lblModelNameValue);
        }
        this.add((Component)this.lblModelName, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, TOPLABELITEMINSETS, n7, n8));
        n2 = 1;
        if (((WizardState)this.getparentWizardState()).isNew() && this.m_state.allowModelSelection()) {
            this.comboModel.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ModelPanel.this.comboModel_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.comboModel, new GridBagConstraints(n2, n, 1, 1, 1.0, 0.0, 17, 2, TOPVALUEITEMINSETS, n7, n8));
        } else {
            this.add((Component)this.lblModelNameValue, new GridBagConstraints(n2, n, 1, 1, 1.0, 0.0, 17, 2, TOPVALUEITEMINSETS, n7, n8));
        }
        this.lblModelAlgorithm.setText(ResourceUtilities.getUILabel("MODEL_STEP_ALGORITHM"));
        this.lblModelAlgorithm.setLabelFor(this.lblModelAlgorithmValue);
        this.addComponent(this.lblModelAlgorithm, TOPLABELITEMINSETS, ++n, 0);
        this.addComponent(this.lblModelAlgorithmValue, TOPVALUEITEMINSETS, n++, 1);
        this.lblModelBuildDate.setText(ResourceUtilities.getUILabel("MODEL_STEP_COMP_BUILD_DATE"));
        this.lblModelBuildDate.setLabelFor(this.lblModelBuildDateValue);
        this.addComponent(this.lblModelBuildDate, TOPLABELITEMINSETS, n, 0);
        this.addComponent(this.lblModelBuildDateValue, TOPVALUEITEMINSETS, n++, 1);
        this.lblModelBuildTime.setText(ResourceUtilities.getUILabel("MODEL_STEP_COMP_BUILD_TIME"));
        this.lblModelBuildTime.setLabelFor(this.lblModelBuildTimeValue);
        this.addComponent(this.lblModelBuildTime, MIDLABELITEMINSETS, n, 0);
        this.addComponent(this.lblModelBuildTimeValue, MIDVALUEITEMINSETS, n++, 1);
        this.lblModelInputData.setText(ResourceUtilities.getUILabel("MODEL_STEP_INPUT_DATA"));
        this.addComponent(this.lblModelInputData, TOPLABELITEMINSETS, n++, 0);
        this.lblModelInputDataSchema.setText(ResourceUtilities.getUILabel("MODEL_STEP_INPUT_SCHEMA"));
        this.lblModelInputDataSchema.setLabelFor(this.lblModelInputDataSchemaValue);
        this.addComponent(this.lblModelInputDataSchema, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.lblModelInputDataSchemaValue, MIDVALUEITEMINSETS, n++, 1);
        this.lblModelInputDataTable.setText(ResourceUtilities.getUILabel("MODEL_STEP_INPUT_TABLE"));
        this.lblModelInputDataTable.setLabelFor(this.lblModelInputDataTableValue);
        this.addComponent(this.lblModelInputDataTable, MIDINDENTEDLABELITEMINSETS, n, 0);
        this.addComponent(this.lblModelInputDataTableValue, MIDVALUEITEMINSETS, n++, 1);
        this.m_notAvailable = dM4JListResourceBundle.getString("COMMON_NOT_AVAILABLE");
        ++n;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 3, 1, 1.0, 1.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void comboModel_actionPerformed(ActionEvent actionEvent) {
        try {
            block4: {
                try {
                    if (this.m_ignoreComboEvent) break block4;
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    this.m_state.setSelectedModelName((String)jComboBox.getSelectedItem());
                    this.loadModelDetails();
                }
                catch (Exception exception) {
                    ((WizardState)this.getparentWizardState()).doAbortCancel(exception);
                    Object var4_5 = null;
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            throw throwable;
        }
    }

    protected void focusOnErrorField(Vector vector) {
    }

    protected void processUserInput() {
        WizardState wizardState = (WizardState)this.getparentWizardState();
        if (wizardState instanceof ClassificationModelTestState) {
            try {
                Model model = this.m_state.restoreModel();
                if (model.getMiningAlgorithm().compareTo(MiningAlgorithm.naiveBayes) == 0) {
                    this.enableTestSettingsPage(true);
                } else {
                    ClassificationTestSettingState classificationTestSettingState = (ClassificationTestSettingState)this.m_state.getparentWizardState().getStep(StepType.TEST_STEP);
                    classificationTestSettingState.setCrossValidationMFSName("CrossValidateTestMFSName");
                    classificationTestSettingState.setStandardTest(true);
                    this.enableTestSettingsPage(false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadModelDetails() {
        if (this.m_state.getModelAlgorithm().length() > 0) {
            this.lblModelAlgorithmValue.setText(this.m_state.getModelAlgorithm());
        } else {
            this.lblModelAlgorithmValue.setText(this.m_notAvailable);
        }
        if (this.m_state.getModelBuildCompletionDate().length() > 0) {
            this.lblModelBuildDateValue.setText(this.m_state.getModelBuildCompletionDate());
        } else {
            this.lblModelBuildDateValue.setText(this.m_notAvailable);
        }
        if (this.m_state.getModelBuildCompletionTime().length() > 0) {
            this.lblModelBuildTimeValue.setText(this.m_state.getModelBuildCompletionTime());
        } else {
            this.lblModelBuildTimeValue.setText(this.m_notAvailable);
        }
        if (this.m_state.getModelInputDataSchemaName().length() > 0) {
            this.lblModelInputDataSchemaValue.setText(this.m_state.getModelInputDataSchemaName());
        } else {
            this.lblModelInputDataSchemaValue.setText(this.m_notAvailable);
        }
        if (this.m_state.getModelInputDataTableName().length() > 0) {
            this.lblModelInputDataTableValue.setText(this.m_state.getModelInputDataTableName());
        } else {
            this.lblModelInputDataTableValue.setText(this.m_notAvailable);
        }
    }

    public void init() {
        if (((WizardState)this.getparentWizardState()).isNew() && this.m_state.allowModelSelection()) {
            this.loadModelCombo();
        } else {
            this.lblModelNameValue.setText(this.m_state.getSelectedModelName());
            this.loadModelDetails();
        }
    }

    public void reinit() {
        this.init();
    }

    protected void loadModelCombo() {
        this.m_ignoreComboEvent = true;
        this.modelModel = new DefaultComboBoxModel<String>(this.m_state.getModelNames());
        this.comboModel.setModel(this.modelModel);
        if (this.m_state.getModelNames().length > 0) {
            this.comboModel.setSelectedItem(this.m_state.getSelectedModelName());
            this.loadModelDetails();
        }
        this.m_ignoreComboEvent = false;
    }

    public void clear() {
        if (((WizardState)this.getparentWizardState()).isNew()) {
            this.modelModel.removeAllElements();
        }
    }

    protected void enableTestSettingsPage(boolean bl) throws Exception {
        DM4JWizard dM4JWizard = this.m_state.getparentWizardState().getWizard();
        int n = dM4JWizard.getPageCount();
        Class<DM4JPage> clazz = DM4JPage.class;
        DM4JPage dM4JPage = null;
        WizardPage wizardPage = null;
        for (int i = 0; i < n; ++i) {
            wizardPage = dM4JWizard.getPageAt(i);
            if (!clazz.isInstance(wizardPage) || !(dM4JPage = (DM4JPage)wizardPage).getStepType().equals(StepType.TEST_STEP)) continue;
            dM4JPage.getDM4JStep().refreshFromCurrent();
            dM4JPage.setEnabled(bl);
        }
    }
}

