/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.miningsteps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.wizard.dialogs.KMeansDialog;
import oracle.dmt.dm4j.wizard.dialogs.OClusterDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClusteringAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JStep;

public class ClusteringAlgorithmPanel
extends DM4JStep {
    ClusteringAlgorithmState m_state;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblAttributeCount = new JLabel();
    JLabel lblSelectedAttributeCountValue = new JLabel();
    JLabel lblCaseCount = new JLabel();
    JLabel lblCaseCountValue = new JLabel();
    JLabel lblAlgorithmTypes = new JLabel();
    JComboBox comboAlgorithmTypes = new JComboBox();
    DefaultComboBoxModel AlgorithmTypesModel;
    JLabel lblAlgoOCluster = new JLabel();
    JLabel lblAlgoKMeans = new JLabel();
    JLabel lblOClusterHint1 = new JLabel();
    JLabel lblOClusterHint2 = new JLabel();
    JLabel lblOClusterHint3 = new JLabel();
    JLabel lblOClusterHint4 = new JLabel();
    JLabel lblOClusterMaxNumberOfClusters = new JLabel();
    DM4JNumberTextField txtOClusterMaxNumberOfClusters = new DM4JNumberTextField();
    JLabel lblKMeansHint1 = new JLabel();
    JLabel lblKMeansHint2 = new JLabel();
    JLabel lblKMeansHint3 = new JLabel();
    JLabel lblKMeansHint4 = new JLabel();
    JLabel lblKMeansMaxNumberOfClusters = new JLabel();
    DM4JNumberTextField txtKMeansMaxNumberOfClusters = new DM4JNumberTextField();
    JButton butSettingsOCluster = new JButton();
    JButton butSettingsKMeans = new JButton();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreAlgorithmTypeEvent = false;

    public ClusteringAlgorithmPanel(WizardState wizardState, ClusteringAlgorithmState clusteringAlgorithmState) throws Exception {
        super(wizardState, clusteringAlgorithmState);
        this.m_state = clusteringAlgorithmState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 10;
        int n12 = 60;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(n12);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 3, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblAttributeCount.setText(ResourceUtilities.getUILabel("SELECTED_ATTRIBUTE_COUNT"));
        this.lblAttributeCount.setLabelFor(this.lblSelectedAttributeCountValue);
        this.add((Component)this.lblAttributeCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.add((Component)this.lblSelectedAttributeCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblCaseCount.setText(ResourceUtilities.getUILabel("SAMPLE_CASE_COUNT"));
        this.lblCaseCount.setLabelFor(this.lblCaseCountValue);
        this.add((Component)this.lblCaseCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
        ++n2;
        this.add((Component)this.lblCaseCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblAlgorithmTypes.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_ALGORITHM"));
        this.lblAlgorithmTypes.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_STEP_ALGORITHM"));
        this.add((Component)this.lblAlgorithmTypes, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        n2 = 1;
        if (this.m_state.allowAlgorithmSelection()) {
            this.lblAlgorithmTypes.setLabelFor(this.comboAlgorithmTypes);
            this.comboAlgorithmTypes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClusteringAlgorithmPanel.this.comboAlgorithmTypes_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.comboAlgorithmTypes, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isOClusterSelected()) {
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoOCluster);
            this.lblAlgoOCluster.setText(ResourceUtilities.getUILabel("OCLUSTER_OPTION_NAME"));
            this.add((Component)this.lblAlgoOCluster, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isKMeansSelected()) {
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoKMeans);
            this.lblAlgoKMeans.setText(ResourceUtilities.getUILabel("KMEANS_OPTION_NAME"));
            this.add((Component)this.lblAlgoKMeans, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isOClusterSelected()) {
            ++n;
            this.lblOClusterHint1.setText(ResourceUtilities.getUILabel("OCLUSTER_HINT1"));
            this.add((Component)this.lblOClusterHint1, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.lblOClusterHint2.setText(ResourceUtilities.getUILabel("OCLUSTER_HINT2"));
            this.add((Component)this.lblOClusterHint2, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.lblOClusterMaxNumberOfClusters.setText(ResourceUtilities.getUILabel("OCLUSTER_MAX_NUMBER_CLUSTERS"));
            this.lblOClusterMaxNumberOfClusters.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OCLUSTER_MAX_NUMBER_CLUSTERS"));
            this.lblOClusterMaxNumberOfClusters.setLabelFor(this.txtOClusterMaxNumberOfClusters);
            this.add((Component)this.lblOClusterMaxNumberOfClusters, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
            this.txtOClusterMaxNumberOfClusters.setLocale(Locale.getDefault());
            this.txtOClusterMaxNumberOfClusters.setDataType(Integer.TYPE);
            this.txtOClusterMaxNumberOfClusters.setSigned(false);
            this.add((Component)this.txtOClusterMaxNumberOfClusters, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
            ++n;
            this.butSettingsOCluster.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsOCluster.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsOCluster.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClusteringAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsOCluster, new GridBagConstraints(--n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isKMeansSelected()) {
            ++n;
            this.lblKMeansHint1.setText(ResourceUtilities.getUILabel("KMEANS_HINT1"));
            this.add((Component)this.lblKMeansHint1, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.lblKMeansHint2.setText(ResourceUtilities.getUILabel("KMEANS_HINT2"));
            this.add((Component)this.lblKMeansHint2, new GridBagConstraints(n2, n, 2, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.lblKMeansMaxNumberOfClusters.setText(ResourceUtilities.getUILabel("KMEANS_NUMBER_CLUSTERS"));
            this.lblKMeansMaxNumberOfClusters.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("KMEANS_NUMBER_CLUSTERS"));
            this.lblKMeansMaxNumberOfClusters.setLabelFor(this.txtKMeansMaxNumberOfClusters);
            this.add((Component)this.lblKMeansMaxNumberOfClusters, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
            this.txtKMeansMaxNumberOfClusters.setLocale(Locale.getDefault());
            this.txtKMeansMaxNumberOfClusters.setDataType(Integer.TYPE);
            this.txtKMeansMaxNumberOfClusters.setSigned(false);
            this.add((Component)this.txtKMeansMaxNumberOfClusters, new GridBagConstraints(++n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
            ++n;
            this.butSettingsKMeans.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsKMeans.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsKMeans.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClusteringAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsKMeans, new GridBagConstraints(--n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        ++n;
        n2 = 0;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 2, 1, 0.5, 0.5, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        JComponent[] jComponentArray = new JComponent[]{this.txtOClusterMaxNumberOfClusters, this.txtKMeansMaxNumberOfClusters};
        ResourceUtilities.setTextBoxSize(jComponentArray, 100, 20);
    }

    protected void processUserInput() {
        if (this.m_state.isKMeansSelected()) {
            this.m_state.setKMeansNumberOfClusters((Integer)this.txtKMeansMaxNumberOfClusters.getNumber());
        } else {
            this.m_state.setOClusterNumberOfClusters((Integer)this.txtOClusterMaxNumberOfClusters.getNumber());
        }
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() {
        this.setCounts();
        this.loadDetails();
    }

    public void reinit() {
        this.init();
    }

    protected void setCounts() {
        this.lblSelectedAttributeCountValue.setText(DM4JNumericFormat.format(this.m_state.getActiveAttributeCountExcludingTargetsInteger()));
        this.lblCaseCountValue.setText(DM4JNumericFormat.format(this.m_state.getCaseCountInteger()));
    }

    protected void loadDetails() {
        this.loadAlgorithmTypesCombo();
        this.displayAlgorithmTypeRelatedControls();
    }

    protected void butSettings_actionPerformed(ActionEvent actionEvent) {
        if (this.m_state.isOClusterSelected()) {
            try {
                OClusterDialog oClusterDialog = new OClusterDialog(this.m_wizardState.getDialog(), this.m_state);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else {
            try {
                KMeansDialog kMeansDialog = new KMeansDialog(this.m_wizardState.getDialog(), this.m_state);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        }
    }

    protected void displayAlgorithmTypeRelatedControls() {
        if (this.m_state.isKMeansSelected()) {
            this.txtKMeansMaxNumberOfClusters.setNumber(this.m_state.getKMeansNumberOfClusters());
        } else {
            this.txtOClusterMaxNumberOfClusters.setNumber(this.m_state.getOClusterNumberOfClusters());
        }
        this.lblKMeansHint1.setVisible(this.m_state.isKMeansSelected());
        this.lblKMeansHint2.setVisible(this.m_state.isKMeansSelected());
        this.lblKMeansHint3.setVisible(this.m_state.isKMeansSelected());
        this.lblKMeansHint4.setVisible(this.m_state.isKMeansSelected());
        this.lblKMeansMaxNumberOfClusters.setVisible(this.m_state.isKMeansSelected());
        this.txtKMeansMaxNumberOfClusters.setVisible(this.m_state.isKMeansSelected());
        this.butSettingsKMeans.setVisible(this.m_state.isKMeansSelected());
        this.lblOClusterHint1.setVisible(this.m_state.isOClusterSelected());
        this.lblOClusterHint2.setVisible(this.m_state.isOClusterSelected());
        this.lblOClusterHint3.setVisible(this.m_state.isOClusterSelected());
        this.lblOClusterHint4.setVisible(this.m_state.isOClusterSelected());
        this.lblOClusterMaxNumberOfClusters.setVisible(this.m_state.isOClusterSelected());
        this.txtOClusterMaxNumberOfClusters.setVisible(this.m_state.isOClusterSelected());
        this.butSettingsOCluster.setVisible(this.m_state.isOClusterSelected());
    }

    public void clear() {
        this.loadDetails();
    }

    protected void loadAlgorithmTypesCombo() {
        this.m_ignoreAlgorithmTypeEvent = true;
        Vector<String> vector = new Vector<String>();
        vector.add("OCluster");
        vector.add("KMeans");
        this.AlgorithmTypesModel = new DefaultComboBoxModel(vector);
        this.comboAlgorithmTypes.setModel(this.AlgorithmTypesModel);
        if (this.m_state.isOClusterSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("OCluster");
        } else if (this.m_state.isKMeansSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("KMeans");
        }
        this.m_ignoreAlgorithmTypeEvent = false;
    }

    protected void comboAlgorithmTypes_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreAlgorithmTypeEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                this.m_state.setOClusterSelected(string.equals("OCluster"));
                this.m_state.setKMeansSelected(string.equals("KMeans"));
                this.displayAlgorithmTypeRelatedControls();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class CheckForIncludeChanges
    extends TwoDModelAdapter {
        private CheckForIncludeChanges() {
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            ClusteringAlgorithmPanel.this.lblSelectedAttributeCountValue.setText(ClusteringAlgorithmPanel.this.m_state.getActiveAttributeCountExcludingTargets());
        }
    }
}

