/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.miningsteps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.wizard.dialogs.AdaptiveBayesNetworkDialog;
import oracle.dmt.dm4j.wizard.dialogs.DecisionTreeDialog;
import oracle.dmt.dm4j.wizard.dialogs.GeneralizedLinearModelDialog;
import oracle.dmt.dm4j.wizard.dialogs.NaiveBayesDialog;
import oracle.dmt.dm4j.wizard.dialogs.SupportVectorMachineDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JStep;

public class ClassificationAlgorithmPanel
extends DM4JStep {
    ClassificationAlgorithmState m_state;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblAttributeCount = new JLabel();
    JLabel lblSelectedAttributeCountValue = new JLabel();
    JLabel lblCaseCount = new JLabel();
    JLabel lblCaseCountValue = new JLabel();
    JLabel lblAlgorithmTypes = new JLabel();
    JComboBox comboAlgorithmTypes = new JComboBox();
    DefaultComboBoxModel AlgorithmTypesModel;
    JLabel lblAlgorithmTypesHint1 = new JLabel();
    JLabel lblAlgoABN = new JLabel();
    JLabel lblAlgoNB = new JLabel();
    JLabel lblAlgoSVM = new JLabel();
    JLabel lblAlgoDT = new JLabel();
    JLabel lblAlgoGLM = new JLabel();
    JLabel lblABNHint1 = new JLabel();
    JLabel lblABNHint2 = new JLabel();
    JLabel lblABNHint3 = new JLabel();
    JLabel lblNBHint1 = new JLabel();
    JLabel lblSVMHint1 = new JLabel();
    JLabel lblSVMHint2 = new JLabel();
    JLabel lblSVMHint3 = new JLabel();
    JLabel lblGLMHint1 = new JLabel();
    JLabel lblDTHint1 = new JLabel();
    JButton butSettingsABN = new JButton();
    JButton butSettingsNB = new JButton();
    JButton butSettingsSVM = new JButton();
    JButton butSettingsGLM = new JButton();
    JButton butSettingsDT = new JButton();
    JLabel lblFiller = new JLabel();
    boolean m_ignoreAlgorithmTypeEvent = false;

    public ClassificationAlgorithmPanel(WizardState wizardState, ClassificationAlgorithmState classificationAlgorithmState) throws Exception {
        super(wizardState, classificationAlgorithmState);
        this.m_state = classificationAlgorithmState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 10;
        int n5 = 0;
        int n6 = 10;
        int n7 = 0;
        int n8 = 0;
        int n9 = 24;
        int n10 = 10;
        int n11 = 10;
        int n12 = 60;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setPreferredColumns(n12);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblAttributeCount.setText(ResourceUtilities.getUILabel("SELECTED_ATTRIBUTE_COUNT"));
        this.lblAttributeCount.setLabelFor(this.lblSelectedAttributeCountValue);
        this.add((Component)this.lblAttributeCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n2;
        this.lblSelectedAttributeCountValue.setToolTipText(this.lblAttributeCount.getText());
        this.add((Component)this.lblSelectedAttributeCountValue, new GridBagConstraints(n2, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(n3 + n11, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblCaseCount.setText(ResourceUtilities.getUILabel("SAMPLE_CASE_COUNT"));
        this.lblCaseCount.setLabelFor(this.lblCaseCountValue);
        this.add((Component)this.lblCaseCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        ++n2;
        this.lblCaseCountValue.setToolTipText(this.lblCaseCount.getText());
        this.add((Component)this.lblCaseCountValue, new GridBagConstraints(n2, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(n3, n4, n5, n6), n7, n8));
        ++n;
        n2 = 0;
        this.lblAlgorithmTypes.setText(ResourceUtilities.getUILabel("ALGORITHM_STEP_ALGORITHM"));
        this.lblAlgorithmTypes.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_STEP_ALGORITHM"));
        this.add((Component)this.lblAlgorithmTypes, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        n2 = 1;
        if (this.m_state.allowAlgorithmSelection()) {
            this.lblAlgorithmTypes.setLabelFor(this.comboAlgorithmTypes);
            this.comboAlgorithmTypes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationAlgorithmPanel.this.comboAlgorithmTypes_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.comboAlgorithmTypes, new GridBagConstraints(n2, n, 2, 1, 1.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isNaiveBayesSelected()) {
            this.lblAlgoNB.setText(ResourceUtilities.getUILabel("NB_OPTION_NAME"));
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoNB);
            this.add((Component)this.lblAlgoNB, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isAdaptiveNaiveBayesSelected()) {
            this.lblAlgoABN.setText(ResourceUtilities.getUILabel("ABN_OPTION_NAME"));
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoABN);
            this.add((Component)this.lblAlgoABN, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isSupportVectorMachineSelected()) {
            this.lblAlgoSVM.setText(ResourceUtilities.getUILabel("SVM_OPTION_NAME"));
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoSVM);
            this.add((Component)this.lblAlgoSVM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isGenerializedLinearModelSelected()) {
            this.lblAlgoGLM.setText(ResourceUtilities.getUILabel("GLM_OPTION_NAME"));
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoGLM);
            this.add((Component)this.lblAlgoGLM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        } else if (this.m_state.isDecisionTreeSelected()) {
            this.lblAlgoDT.setText(ResourceUtilities.getUILabel("DT_OPTION_NAME"));
            this.lblAlgorithmTypes.setLabelFor(this.lblAlgoDT);
            this.add((Component)this.lblAlgoDT, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n4, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isAdaptiveNaiveBayesSelected()) {
            ++n;
            this.lblABNHint1.setText(ResourceUtilities.getUILabel("ABN_HINT1"));
            this.add((Component)this.lblABNHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.butSettingsABN.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsABN.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsABN.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsABN, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isNaiveBayesSelected()) {
            ++n;
            this.lblNBHint1.setText(ResourceUtilities.getUILabel("NB_HINT1"));
            this.add((Component)this.lblNBHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.butSettingsNB.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsNB.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsNB.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsNB, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isSupportVectorMachineSelected()) {
            ++n;
            this.lblSVMHint1.setText(ResourceUtilities.getUILabel("SVM_HINT1"));
            this.add((Component)this.lblSVMHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.butSettingsSVM.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsSVM.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsSVM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsSVM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isGenerializedLinearModelSelected()) {
            ++n;
            this.lblGLMHint1.setText(ResourceUtilities.getUILabel("GLM_HINT1"));
            this.add((Component)this.lblGLMHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.butSettingsGLM.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsGLM.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsGLM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsGLM, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        if (this.m_state.allowAlgorithmSelection() || !this.m_state.allowAlgorithmSelection() && this.m_state.isDecisionTreeSelected()) {
            ++n;
            this.lblDTHint1.setText(ResourceUtilities.getUILabel("DT_HINT1"));
            this.add((Component)this.lblDTHint1, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n3, n9, n5, n6), n7, n8));
            ++n;
            this.butSettingsDT.setText(ResourceUtilities.getUILabel("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsDT.setMnemonic(ResourceUtilities.getUIMnemonic("ALGORITHM_SETTINGS_BUTTON"));
            this.butSettingsDT.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ClassificationAlgorithmPanel.this.butSettings_actionPerformed(actionEvent);
                }
            });
            this.add((Component)this.butSettingsDT, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n3, n9, n5, n6), n7, n8));
        }
        ++n;
        n2 = 0;
        this.add((Component)this.lblFiller, new GridBagConstraints(n2, n, 2, 1, 0.5, 0.5, 17, 1, new Insets(n3, n4, n5, n6), n7, n8));
    }

    protected void processUserInput() {
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() {
        this.setCounts();
        this.loadDetails();
    }

    public void reinit() {
        this.init();
    }

    protected void setCounts() {
        this.lblSelectedAttributeCountValue.setText(DM4JNumericFormat.format(this.m_state.getActiveAttributeCountExcludingTargetsInteger()));
        this.lblCaseCountValue.setText(DM4JNumericFormat.format(this.m_state.getCaseCountInteger()));
    }

    protected void loadDetails() {
        this.loadAlgorithmTypesCombo();
        this.displayAlgorithmTypeRelatedControls();
    }

    protected void butSettings_actionPerformed(ActionEvent actionEvent) {
        if (this.m_state.isAdaptiveNaiveBayesSelected()) {
            try {
                AdaptiveBayesNetworkDialog adaptiveBayesNetworkDialog = new AdaptiveBayesNetworkDialog(this.getparentWizardState().getDialog(), this.m_state);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if (this.m_state.isNaiveBayesSelected()) {
            try {
                NaiveBayesDialog naiveBayesDialog = new NaiveBayesDialog(this.getparentWizardState().getDialog(), this.m_state);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if (this.m_state.isSupportVectorMachineSelected()) {
            try {
                SupportVectorMachineDialog supportVectorMachineDialog = new SupportVectorMachineDialog(this.getparentWizardState().getDialog(), this.m_state.getSupportVectorMachine());
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if (this.m_state.isGenerializedLinearModelSelected()) {
            try {
                GeneralizedLinearModelDialog generalizedLinearModelDialog = new GeneralizedLinearModelDialog(this.getparentWizardState().getDialog(), this.m_state);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        } else if (this.m_state.isDecisionTreeSelected()) {
            try {
                DecisionTreeDialog decisionTreeDialog = new DecisionTreeDialog(this.getparentWizardState().getDialog(), this.m_state);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
            }
        }
    }

    public void clear() {
        this.loadDetails();
    }

    protected void loadAlgorithmTypesCombo() {
        this.m_ignoreAlgorithmTypeEvent = true;
        Vector<String> vector = new Vector<String>();
        vector.add("Naive Bayes");
        vector.add("Adaptive Bayes Network");
        vector.add("Support Vector Machine");
        vector.add("Decision Tree");
        vector.add("Generalized Linear Model");
        this.AlgorithmTypesModel = new DefaultComboBoxModel(vector);
        this.comboAlgorithmTypes.setModel(this.AlgorithmTypesModel);
        if (this.m_state.isNaiveBayesSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("Naive Bayes");
        } else if (this.m_state.isAdaptiveNaiveBayesSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("Adaptive Bayes Network");
        } else if (this.m_state.isSupportVectorMachineSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("Support Vector Machine");
        } else if (this.m_state.isDecisionTreeSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("Decision Tree");
        } else if (this.m_state.isGenerializedLinearModelSelected()) {
            this.comboAlgorithmTypes.setSelectedItem("Generalized Linear Model");
        }
        this.m_ignoreAlgorithmTypeEvent = false;
    }

    protected void comboAlgorithmTypes_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreAlgorithmTypeEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                this.m_state.setNaiveBayesSelected(string.equals("Naive Bayes"));
                this.m_state.setAdaptiveNaiveBayesSelected(string.equals("Adaptive Bayes Network"));
                this.m_state.setSupportVectorMachineSelected(string.equals("Support Vector Machine"));
                this.m_state.setDecisionTreeSelected(string.equals("Decision Tree"));
                this.m_state.setDecisionTreeSelected(string.equals("Generalized Linear Model"));
                this.displayAlgorithmTypeRelatedControls();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void displayAlgorithmTypeRelatedControls() {
        this.lblNBHint1.setVisible(this.m_state.isNaiveBayesSelected());
        this.butSettingsNB.setVisible(this.m_state.isNaiveBayesSelected());
        this.lblABNHint1.setVisible(this.m_state.isAdaptiveNaiveBayesSelected());
        this.butSettingsABN.setVisible(this.m_state.isAdaptiveNaiveBayesSelected());
        this.lblSVMHint1.setVisible(this.m_state.isSupportVectorMachineSelected());
        this.butSettingsSVM.setVisible(this.m_state.isSupportVectorMachineSelected());
        this.lblDTHint1.setVisible(this.m_state.isDecisionTreeSelected());
        this.butSettingsDT.setVisible(this.m_state.isDecisionTreeSelected());
        this.lblGLMHint1.setVisible(this.m_state.isGenerializedLinearModelSelected());
        this.butSettingsGLM.setVisible(this.m_state.isGenerializedLinearModelSelected());
    }

    private class CheckForIncludeChanges
    extends TwoDModelAdapter {
        private CheckForIncludeChanges() {
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            ClassificationAlgorithmPanel.this.lblSelectedAttributeCountValue.setText(ClassificationAlgorithmPanel.this.m_state.getActiveAttributeCountExcludingTargets());
        }
    }
}

