/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.miningsteps;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import java.text.Collator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.BooleanInputHandler;
import oracle.bali.ewt.grid.CheckPainter;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.SortableTwoDModel;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ApplyIDState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JStep;
import oracle.dmt.dm4j.wizard.table.ComponentSpreadTable;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class ApplyIDPanel
extends DM4JStep {
    ApplyIDState m_state;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblAttributeCount = new JLabel();
    JLabel lblAttributeCountValue = new JLabel();
    JLabel lblSelectedAttributeCount = new JLabel();
    JLabel lblSelectedAttributeCountValue = new JLabel();
    JButton butInclude = new JButton();
    JButton butExclude = new JButton();
    boolean m_includeTargetAttribute = false;
    JScrollPane paneSpread = new JScrollPane();
    ComponentSpreadTable spreadTable = new ComponentSpreadTable(null);
    IncludeAction includeAction = new IncludeAction();
    JLabel lblFiller = new JLabel();
    private int[] m_colWidths = new int[]{20, 60, 20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public ApplyIDPanel(WizardState wizardState, ApplyIDState applyIDState, boolean bl) throws Exception {
        super(wizardState, applyIDState);
        this.m_state = applyIDState;
        this.m_includeTargetAttribute = bl;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        int n = 0;
        int n2 = 0;
        int n3 = 4;
        int n4 = 5;
        int n5 = 10;
        int n6 = 0;
        int n7 = 10;
        int n8 = 0;
        int n9 = 0;
        int n10 = 24;
        int n11 = 10;
        int n12 = 10;
        int n13 = 60;
        n2 = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("APPLY_ID_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setPreferredColumns(n13);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.add((Component)this.mlblStepDescription, new GridBagConstraints(n2, n, n3, 1, 1.0, 0.0, 17, 1, new Insets(n4, n5, n6 + n11, n7), n8, n9));
        ++n;
        n2 = 0;
        this.lblAttributeCount.setText(ResourceUtilities.getUILabel("ATTRIBUTE_COUNT"));
        this.lblAttributeCount.setLabelFor(this.lblAttributeCountValue);
        this.add((Component)this.lblAttributeCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n4, n5, n6, n7), n8, n9));
        ++n2;
        this.add((Component)this.lblAttributeCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n4, n5, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.lblSelectedAttributeCount.setText(ResourceUtilities.getUILabel("SELECTED_ATTRIBUTE_COUNT"));
        this.lblSelectedAttributeCount.setLabelFor(this.lblSelectedAttributeCountValue);
        this.add((Component)this.lblSelectedAttributeCount, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n4, n5, n6, n7), n8, n9));
        ++n2;
        this.add((Component)this.lblSelectedAttributeCountValue, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 2, new Insets(n4, n5, n6, n7), n8, n9));
        ++n;
        n2 = 0;
        this.paneSpread.getViewport().add((Component)this.spreadTable, null);
        this.add((Component)this.paneSpread, new GridBagConstraints(n2, n, 3, 5, 1.0, 1.0, 17, 1, new Insets(n4, n5, n6, n7), n8, n9));
        n2 = 3;
        this.butInclude.setText(ResourceUtilities.getUILabel("INCLUDE_BUTTON"));
        this.butInclude.setMnemonic(ResourceUtilities.getUIMnemonic("INCLUDE_BUTTON"));
        this.butInclude.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ApplyIDPanel.this.butInclude_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.butInclude, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n4, 0, n6, 0), n8, n9));
        ++n;
        n2 = 3;
        this.butExclude.setText(ResourceUtilities.getUILabel("EXCLUDE_BUTTON"));
        this.butExclude.setMnemonic(ResourceUtilities.getUIMnemonic("EXCLUDE_BUTTON"));
        this.butExclude.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ApplyIDPanel.this.butExclude_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.butExclude, new GridBagConstraints(n2, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(n4, 0, n6, 0), n8, n9));
        JButton[] jButtonArray = new JButton[]{this.butInclude, this.butExclude};
        ResourceUtilities.setPreferredSize(jButtonArray, 90, 25);
    }

    protected void butExclude_actionPerformed(ActionEvent actionEvent) {
        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(true);
        TwoDSelection twoDSelection = this.spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null) {
            DialogUtilities.createUIErrorDialog(this.getparentWizardState().getDialog(), "ATTRIBUTE_SELECTION_REQUIRED");
        } else {
            this.m_state.setAttributeToExclude(rangeArray);
            try {
                this.spreadTable.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.lblSelectedAttributeCountValue.setText(this.m_state.getSelectedAttributeCount());
        this.setIneligibleSupplementalsInvisible();
        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
    }

    protected void butInclude_actionPerformed(ActionEvent actionEvent) {
        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(true);
        TwoDSelection twoDSelection = this.spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null) {
            DialogUtilities.createUIErrorDialog(this.getparentWizardState().getDialog(), "ATTRIBUTE_SELECTION_REQUIRED");
        } else {
            this.m_state.setAttributeToInclude(rangeArray);
            try {
                this.spreadTable.deselectAll();
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.lblSelectedAttributeCountValue.setText(this.m_state.getSelectedAttributeCount());
        this.setIneligibleSupplementalsInvisible();
        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
    }

    protected void processUserInput() {
        Vector vector = this.m_state.getIDAttributes();
        this.m_state.saveIncludedAttributes(vector);
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() throws Exception {
        this.setSpread();
        this.setCounts();
    }

    protected void setCounts() {
        this.lblAttributeCountValue.setText(DM4JNumericFormat.format(this.m_state.getAttributeCountInteger()));
        this.lblSelectedAttributeCountValue.setText(DM4JNumericFormat.format(this.m_state.getSelectedAttributeCountInteger()));
    }

    protected void setSpread() throws Exception {
        this.spreadTable.setModels2(this.m_state.getLDSDataSource(), this.m_state.getLDSDataSource().getColumnDataSource(), null);
        this.spreadTable.getGrid().setColumnPainter(0, CheckPainter.getPainter());
        this.spreadTable.getGrid().setColumnCellInputHandler(0, BooleanInputHandler.getCellInputHandler());
        this.spreadTable.addEditListener(this.includeAction);
        this.spreadTable.setColumnVisible(3, false);
        this.spreadTable.setColumnVisible(4, false);
        this.spreadTable.setColumnVisible(5, false);
        this.spreadTable.setColumnVisible(7, false);
        this.spreadTable.setColumnVisible(6, false);
        this.spreadTable.setColumnVisible(8, false);
        this.spreadTable.setColumnVisible(9, false);
        this.spreadTable.setColumnVisible(10, false);
        this.spreadTable.setColumnVisible(11, false);
        this.spreadTable.setColumnVisible(12, false);
        this.spreadTable.setColumnVisible(13, false);
        this.spreadTable.setColumnVisible(14, false);
        this.spreadTable.setColumnVisible(15, false);
        this.spreadTable.setColumnVisible(16, false);
        this.setIneligibleSupplementalsInvisible();
        Header header = this.spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        LDSDataSource lDSDataSource = this.m_state.getLDSDataSource();
        header.setItemInputHandler(new MySortInputHandler(lDSDataSource));
        lDSDataSource.setColumnComparator(0, new StringComparator(Collator.getInstance()));
        lDSDataSource.setColumnComparator(1, new StringComparator(Collator.getInstance()));
        lDSDataSource.setColumnComparator(2, new StringComparator(Collator.getInstance()));
        header.setHeaderKeyHandler(new KeyHandler());
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        this.spreadTable.getGrid().setGridSelectionManager(generalGridSelectionManager);
        this.m_state.getparentWizardState().getDialog().pack();
        this.spreadTable.setColumnWidths(this.m_colWidths, true);
    }

    protected void setIncludeTargetAttribute(int n) {
        Range[] rangeArray = new Range[]{new Range(n, n)};
        this.m_state.setAttributeToInclude(rangeArray);
    }

    protected void setIneligibleSupplementalsInvisible() {
        int n = this.spreadTable.getGrid().getRowCount();
        int n2 = this.m_state.getSequenceIDRowID();
        int n3 = -1;
        if (this.m_includeTargetAttribute) {
            n3 = this.m_state.getTargetAttributeRowID();
            this.setIncludeTargetAttribute(n3);
        }
        for (int i = 0; i < n; ++i) {
            if (n2 == i || n3 == i) {
                this.spreadTable.setRowVisible(i, false);
                continue;
            }
            this.spreadTable.setRowVisible(i, true);
        }
    }

    public void reinit() throws Exception {
        this.spreadTable.removeEditListener(this.includeAction);
        this.init();
    }

    protected void loadDetails() {
    }

    public void clear() {
    }

    private class MySortInputHandler
    extends SortInputHandler {
        public MySortInputHandler(SortableTwoDModel sortableTwoDModel) {
            super(sortableTwoDModel);
        }

        public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
            super.mouseReleased(mouseEvent, header, n);
            ApplyIDPanel.this.setIneligibleSupplementalsInvisible();
        }
    }

    private class IncludeAction
    implements TableEditListener {
        private IncludeAction() {
        }

        public void cellEditing(TableEvent tableEvent) {
        }

        public void cellEdited(TableEvent tableEvent) {
            ApplyIDPanel.this.lblSelectedAttributeCountValue.setText(ApplyIDPanel.this.m_state.getSelectedAttributeCount());
        }
    }

    private class CheckForIncludeChanges
    extends TwoDModelAdapter {
        private CheckForIncludeChanges() {
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            ApplyIDPanel.this.lblSelectedAttributeCountValue.setText(ApplyIDPanel.this.m_state.getSelectedAttributeCount());
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                MySortInputHandler mySortInputHandler = (MySortInputHandler)header.getItemInputHandler();
                mySortInputHandler.sort(header.getFocusItem());
                ApplyIDPanel.this.setIneligibleSupplementalsInvisible();
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }
}

