/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.miningsteps;

import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.ExplainState;
import oracle.dmt.dm4j.wizard.state.minings.PredictState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.AppliedOutputTableState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.steps.miningsteps.OutputTablePanel;

public class AppliedOutputTablePage
extends DM4JPage {
    private OutputTablePanel m_panel;
    private AppliedOutputTableState m_state;

    public AppliedOutputTablePage(WizardState wizardState, StepType stepType) throws Exception {
        super(wizardState);
        this.setStepType(stepType);
        this.create(wizardState);
        this.m_stepPanel = this.m_panel;
        this.setWizardStepState(this.m_state);
        DM4JWizardHelp.registerTopic(this.getContent(), "dm4j_apply_output_html");
    }

    private void create(WizardState wizardState) throws Exception {
        if (wizardState instanceof PredictState) {
            this.setLabel(ResourceUtilities.getUILabel("PREDICT_OUTPUT_STEP_NAME"));
            this.setImage(wizardState.getImage());
            this.m_state = new AppliedOutputTableState(wizardState, "PREDICT_OUTPUT_STEP_NAME", (StepType)this.getStepType());
            wizardState.addStep(this.getStepType(), this.m_state);
            this.m_panel = new OutputTablePanel(wizardState, this.m_state, "PREDICT_OUTPUT_STEP_DESCRIPTION");
        } else if (wizardState instanceof ExplainState) {
            this.setLabel(ResourceUtilities.getUILabel("EXPLAIN_OUTPUT_STEP_NAME"));
            this.setImage(wizardState.getImage());
            this.m_state = new AppliedOutputTableState(wizardState, "EXPLAIN_OUTPUT_STEP_NAME", (StepType)this.getStepType());
            wizardState.addStep(this.getStepType(), this.m_state);
            this.m_panel = new OutputTablePanel(wizardState, this.m_state, "EXPLAIN_OUTPUT_STEP_DESCRIPTION");
        } else {
            this.setLabel(ResourceUtilities.getUILabel("APPLIED_OUTPUT_STEP_NAME"));
            this.setImage(wizardState.getImage());
            this.m_state = new AppliedOutputTableState(wizardState, "APPLIED_OUTPUT_STEP_NAME", (StepType)this.getStepType());
            wizardState.addStep(this.getStepType(), this.m_state);
            this.m_panel = new OutputTablePanel(wizardState, this.m_state, "APPLIED_OUTPUT_STEP_DESCRIPTION");
        }
        this.setInteractiveArea(this.m_panel);
        OutputTablePanel outputTablePanel = (OutputTablePanel)this.getInteractiveArea();
        this.addWizardValidateListener(outputTablePanel);
    }
}

