/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class OpenFilePanel
extends DM4JStep {
    OpenFileState m_state;
    String m_panelDescriptionResourceKey;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblOpenFileHeader = new JLabel();
    JLabel lblOpenFileName = new JLabel();
    JTextField txtOpenFileName = new JTextField();
    File txtOpenFile;
    JButton butBrowse = new JButton();
    JComboBox comboFieldCharsets = new JComboBox();
    JLabel lblFieldCharsets = new JLabel();
    JLabel lblSqlLoaderName = new JLabel();
    JTextField txtSqlLoaderName = new JTextField();
    File txtSqlLoader;
    JButton butSqlLoaderBrowse = new JButton();
    JLabel lblFiller = new JLabel();

    public OpenFilePanel(OpenFileState openFileState, String string) throws Exception {
        super(openFileState);
        this.m_state = openFileState;
        this.m_panelDescriptionResourceKey = string;
        this.jbInit();
    }

    private void butBrowse_actionPerformed(ActionEvent actionEvent) {
        try {
            String string = UserPreferences.getInstance().getWorkingDirectory();
            JFileChooser jFileChooser = string != null ? new JFileChooser(string) : new JFileChooser();
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.txtOpenFileName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                this.txtOpenFile = jFileChooser.getSelectedFile();
                this.processUserInput();
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void butSqlLoaderBrowse_actionPerformed(ActionEvent actionEvent) {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            int n = jFileChooser.showOpenDialog(this);
            if (n == 0) {
                this.txtSqlLoaderName.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                this.txtSqlLoader = jFileChooser.getSelectedFile();
                this.processUserInput();
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void comboFieldCharsets_actionPerformed(ActionEvent actionEvent) {
        try {
            this.processUserInput();
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("OPEN_FILE_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblOpenFileName.setText(ResourceUtilities.getUILabel("OPEN_FILE_FILENAME"));
        this.lblOpenFileName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OPEN_FILE_FILENAME"));
        this.lblOpenFileName.setLabelFor(this.txtOpenFileName);
        this.addComponent(this.lblOpenFileName, COL1_INDENTED1_LABEL, n, 0);
        this.addFilledComponent(this.txtOpenFileName, COL_VALUE, n, 1);
        this.butBrowse.setText(ResourceUtilities.getUILabel("OPEN_FILE_BROWSE"));
        this.butBrowse.setMnemonic(ResourceUtilities.getUIMnemonic("OPEN_FILE_BROWSE"));
        this.butBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpenFilePanel.this.butBrowse_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.butBrowse, COL_VALUE, n++, 2);
        this.comboFieldCharsets = new JComboBox<String>(this.m_state.getAllCharsets());
        this.comboFieldCharsets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OpenFilePanel.this.comboFieldCharsets_actionPerformed(actionEvent);
            }
        });
        this.lblFieldCharsets.setText(ResourceUtilities.getUILabel("FILEIMPORT_SETTINGS_FIELD_CHARSETS"));
        this.lblFieldCharsets.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("FILEIMPORT_SETTINGS_FIELD_CHARSETS"));
        this.lblFieldCharsets.setLabelFor(this.comboFieldCharsets);
        this.addComponent(this.lblFieldCharsets, COL1_INDENTED1_LABEL, n, 0);
        this.addFilledComponent(this.comboFieldCharsets, COL_VALUE, n++, 1);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
        JComponent[] jComponentArray = new JComponent[]{this.txtOpenFileName};
        OpenFilePanel.setPreferredSize(jComponentArray, 260, 20);
    }

    public void init() throws Exception {
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void loadDefaultValues() throws Exception {
        if (this.m_state != null) {
            this.txtSqlLoader = this.m_state.getSqlLoader();
            if (this.txtSqlLoader != null) {
                this.txtSqlLoaderName.setText(this.txtSqlLoader.getAbsolutePath());
            }
            this.comboFieldCharsets.setSelectedItem(this.m_state.getCharset());
        }
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            this.txtOpenFile = new File(this.txtOpenFileName.getText());
            String string = this.txtOpenFile.getName();
            if (string.length() != 0 && !ValidationUtil.isFileNameWithSuffix(string)) {
                String string2 = this.txtOpenFileName.getText() + ".";
                this.txtOpenFile = new File(string2);
            }
            this.txtSqlLoader = new File(this.txtSqlLoaderName.getText());
            this.m_state.setFile(this.txtOpenFile);
            this.m_state.setSqlLoader(this.txtSqlLoader);
            this.m_state.setCharset((String)this.comboFieldCharsets.getSelectedItem());
            this.m_state.setState(StepStateType.DIRTY);
        }
    }
}

