/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.Cursor;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.LongRunningProcess;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.commonsteps.BaseHistogramPanel;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;
import oracle.dss.graph.Graph;

public class LDSHistogramPanel
extends BaseHistogramPanel {
    protected WizardState m_state = null;
    protected SpreadTable m_spreadTable;
    protected int m_selectedRow = -1;
    protected DiscretizationLDSDataSource m_dataSourcemodel = null;
    protected boolean m_brestore = false;

    public LDSHistogramPanel(DM4JDialog dM4JDialog, WizardState wizardState, DiscretizationLDSDataSource discretizationLDSDataSource, SpreadTable spreadTable, Graph graph) throws Exception {
        super(dM4JDialog, graph);
        this.m_state = wizardState;
        this.m_dataSourcemodel = discretizationLDSDataSource;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    protected LDSHistogramPanel(DM4JDialog dM4JDialog, WizardState wizardState, DiscretizationLDSDataSource discretizationLDSDataSource, Graph graph) throws Exception {
        super(dM4JDialog, graph);
        this.m_state = wizardState;
        this.m_dataSourcemodel = discretizationLDSDataSource;
    }

    protected void loadState() {
        if (this.m_dataSourcemodel == null) {
            return;
        }
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null || 1 != rangeArray.length) {
            return;
        }
        this.m_selectedRow = rangeArray[0].getLowerLimit();
        this.m_attributeName = this.m_dataSourcemodel.getAttributeName(this.m_selectedRow);
        if (!this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
            this.doTopNBinning();
        } else {
            this.doQtileBinning();
        }
        this.m_BinningType = this.m_dataSourcemodel.getBinType(this.m_selectedRow);
        this.runTimePanelLoad();
        this.loadCombo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doTopNBinning() {
        if (!this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow)) {
            Integer n = this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow);
            if (n != null && n == 0) {
                n = null;
            }
            int n2 = n != null ? n : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
            this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, BinningType.TOPN, n2);
            Integer n3 = this.m_dataSourcemodel.getDistinctCount(this.m_selectedRow);
            if (n3 != null && n3 < n2) {
                n2 = n3;
            }
            this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n2);
            try {
                this.setCursor(new Cursor(3));
                this.m_dataSourcemodel.getTopNStats(this.m_selectedRow, n2);
                Object var5_4 = null;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                this.setCursor(new Cursor(0));
                throw throwable;
            }
            this.setCursor(new Cursor(0));
            {
            }
        }
        return true;
    }

    protected void doQtileBinning() {
        if (!this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow) && this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
            Integer n = this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow);
            if (n != null && n == 0) {
                n = null;
            }
            int n2 = n != null ? n : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
            this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, BinningType.QTILE, n2);
            this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n2);
            this.m_dataSourcemodel.getHistogramQuantileBinning(this.m_selectedRow, new Integer(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runTimePanelLoad() {
        int[] nArray = null;
        try {
            try {
                int n;
                DiscretizeNumericFrequency discretizeNumericFrequency = new DiscretizeNumericFrequency(this.m_dataSourcemodel, this.m_selectedRow);
                ProgressBar progressBar = new ProgressBar(this.m_parent == null ? BrowserFrame.getMainFrame() : this.m_parent, ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_TITLE"), discretizeNumericFrequency, true);
                discretizeNumericFrequency.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_DESC"));
                if (discretizeNumericFrequency.getException() != null) {
                    this.m_dataSourcemodel.markAttributeUnBinned(this.m_selectedRow);
                    nArray = null;
                    if (DiscretizeDataSource.isDebug()) {
                        discretizeNumericFrequency.getException().printStackTrace();
                    }
                } else {
                    if (progressBar.hasUserCancelled()) {
                        this.m_dataSourcemodel.markAttributeUnBinned(this.m_selectedRow);
                        this.m_userCancelled = true;
                        this.comboAttributeName.setSelectedItem(this.m_dataSourcemodel.getAttributeName(this.m_selectedRow));
                        return;
                    }
                    nArray = discretizeNumericFrequency.getFrequency();
                }
                Hashtable hashtable = this.m_dataSourcemodel.getDisplayNames(this.m_selectedRow);
                this.histogramTableModel.deleteAllEntries();
                Object[][] objectArray = null;
                Object[] objectArray2 = null;
                if (!this.m_dataSourcemodel.isNumeric(this.m_selectedRow) && hashtable != null) {
                    int n2;
                    n = hashtable.size();
                    objectArray = new Object[n][1];
                    objectArray2 = new Object[n];
                    int n3 = 0;
                    for (n2 = 0; n2 < n; n3 += ((Integer)objectArray[n2][0]).intValue(), ++n2) {
                        objectArray[n2][0] = nArray != null ? new Integer(nArray[n2]) : new Integer(0);
                    }
                    for (n2 = 0; n2 < hashtable.size(); ++n2) {
                        CategoricBin categoricBin = (CategoricBin)hashtable.get(new Integer(n2));
                        objectArray2[n2] = categoricBin.category;
                        String string = categoricBin.getBinStringValues();
                        if (n2 == hashtable.size() - 1 && (string == null || string.length() == 0)) {
                            string = ResourceUtilities.getUILabel("HISTOGRAM_NULLS");
                        }
                        this.histogramTableModel.addEntry(new Object[]{categoricBin.category, string, objectArray[n2][0], this.percentageOfTotal(objectArray[n2][0], n3)});
                    }
                } else {
                    n = this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow);
                    objectArray = new Object[n + 1][1];
                    objectArray2 = new Object[n + 1];
                    objectArray[n][0] = new Integer(this.m_dataSourcemodel.getNullCount(this.m_selectedRow));
                    objectArray2[n] = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                    int n4 = 0;
                    for (int i = 0; i < n; n4 += ((Integer)objectArray[i][0]).intValue(), ++i) {
                        objectArray[i][0] = nArray != null ? new Integer(nArray[i]) : new Integer(0);
                    }
                    Vector vector = this.m_dataSourcemodel.getBinBounds(this.m_selectedRow);
                    if (vector != null) {
                        BinningType binningType = BinningType.getInstance(this.m_BinningType);
                        if (binningType.equal(BinningType.EQ_WIDTH)) {
                            DecimalFormat decimalFormat = this.formatWithPrecison(vector);
                            for (int i = 0; i < n; ++i) {
                                String string = "";
                                Bin bin = (Bin)vector.elementAt(i);
                                string = i == 0 ? " < " + DM4JNumericFormat.SQLFormat(bin.getUpperBound(), decimalFormat) : (i == n - 1 ? " >= " + DM4JNumericFormat.SQLFormat(bin.getLowerBound(), decimalFormat) : DM4JNumericFormat.SQLFormat(bin.getLowerBound(), decimalFormat) + " - " + DM4JNumericFormat.SQLFormat(bin.getUpperBound(), decimalFormat));
                                objectArray2[i] = string;
                                this.histogramTableModel.addEntry(new Object[]{String.valueOf(i), string, objectArray[i][0], this.percentageOfTotal(objectArray[i][0], n4)});
                            }
                        } else {
                            int n5 = vector.size();
                            if (n5 == 1) {
                                Bin bin = (Bin)vector.elementAt(0);
                                String string = null;
                                if (bin.getLowerBound() == bin.getUpperBound()) {
                                    string = DM4JNumericFormat.format(bin.getLowerBound());
                                } else {
                                    DecimalFormat decimalFormat = this.formatWithPrecison(bin.getLowerBound(), bin.getUpperBound());
                                    string = DM4JNumericFormat.SQLFormat(bin.getLowerBound(), decimalFormat) + " - " + DM4JNumericFormat.SQLFormat(bin.getUpperBound(), decimalFormat);
                                }
                                objectArray2[0] = string;
                                this.histogramTableModel.addEntry(new Object[]{String.valueOf(0), string, objectArray[0][0], this.percentageOfTotal(objectArray[0][0], n4)});
                            } else {
                                DecimalFormat decimalFormat = this.formatWithPrecison(vector);
                                for (int i = 1; i < n5; ++i) {
                                    String string = "";
                                    Bin bin = (Bin)vector.elementAt(i);
                                    string = i == 1 ? " < " + DM4JNumericFormat.SQLFormat(bin.getUpperBound(), decimalFormat) : (i == n5 - 1 ? " > " + DM4JNumericFormat.SQLFormat(bin.getLowerBound(), decimalFormat) : DM4JNumericFormat.SQLFormat(bin.getLowerBound(), decimalFormat) + " - " + DM4JNumericFormat.SQLFormat(bin.getUpperBound(), decimalFormat));
                                    objectArray2[i - 1] = string;
                                    this.histogramTableModel.addEntry(new Object[]{String.valueOf(i - 1), string, objectArray[i - 1][0], this.percentageOfTotal(objectArray[i - 1][0], n4)});
                                }
                                if (objectArray != null) {
                                    this.histogramTableModel.addEntry(new Object[]{String.valueOf(n), ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE"), objectArray[n][0], this.percentageOfTotal(objectArray[n][0], n4)});
                                }
                            }
                        }
                    }
                }
                Object[] objectArray3 = new Object[]{ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE")};
                this.m_graph.getTitle().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_TITLE") + this.m_attributeName);
                this.m_graph.getO1Title().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_X_TITLE"));
                this.m_graph.getY1Title().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE"));
                this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
                this.m_graph.setScrollbarPresenceGroups(1);
                this.m_graph.setDataRowShownAsASeries(true);
                this.m_graph.setDataSource(new LocalXMLDataSource(objectArray2, objectArray3, objectArray));
                return;
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) return;
                exception.printStackTrace();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_8 = null;
            throw throwable;
        }
    }

    private DecimalFormat formatWithPrecison(double d, double d2) {
        int n = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        DM4JNumericFormat.AdjustFormat(d, d2, decimalFormat);
        return decimalFormat;
    }

    private DecimalFormat formatWithPrecison(Vector vector) {
        int n = 2;
        NumberFormat numberFormat = DecimalFormat.getNumberInstance();
        numberFormat.setGroupingUsed(true);
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(0);
        DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
        for (int i = 1; i < vector.size(); ++i) {
            Bin bin = (Bin)vector.elementAt(i);
            DM4JNumericFormat.AdjustFormat(bin.getLowerBound(), bin.getUpperBound(), decimalFormat);
            int n2 = decimalFormat.getMaximumFractionDigits();
            if (n2 < n) {
                numberFormat.setMaximumFractionDigits(n);
                continue;
            }
            n = n2;
        }
        return decimalFormat;
    }

    protected Double getSkew() {
        return this.m_dataSourcemodel.getSkew(this.m_selectedRow);
    }

    protected Double getKurtosis() {
        return this.m_dataSourcemodel.getKurtosis(this.m_selectedRow);
    }

    protected Double getAverage() {
        return this.m_dataSourcemodel.getAverage(this.m_selectedRow);
    }

    protected Double getMin() {
        return this.m_dataSourcemodel.getMin(this.m_selectedRow);
    }

    protected Double getMax() {
        return this.m_dataSourcemodel.getMax(this.m_selectedRow);
    }

    protected Double getVariance() {
        return this.m_dataSourcemodel.getVariance(this.m_selectedRow);
    }

    protected Double getSigma() {
        return this.m_dataSourcemodel.getSigma(this.m_selectedRow);
    }

    protected Integer getTotal() {
        return this.m_dataSourcemodel.getTotalCount(this.m_selectedRow);
    }

    protected String getMode() {
        return this.m_dataSourcemodel.getStatsMode(this.m_selectedRow);
    }

    protected String getOriginalData() {
        return this.m_dataSourcemodel.getDataSource();
    }

    protected boolean showStatistics() {
        return this.m_dataSourcemodel.isNumeric(this.m_selectedRow);
    }

    protected void loadCombo() {
        this.m_attributeNames = new DefaultComboBoxModel(this.m_dataSourcemodel.getAllAttributes());
        this.m_attributeNames.setSelectedItem(this.m_attributeName);
        this.comboAttributeName.setModel(this.m_attributeNames);
        this.comboAttributeName.setSelectedItem(this.m_attributeName);
    }

    protected void reloadState() {
        if (this.m_dataSourcemodel == null) {
            return;
        }
        this.m_attributeName = (String)this.comboAttributeName.getSelectedItem();
        this.m_selectedRow = this.m_dataSourcemodel.getAttributeRow(this.m_attributeName);
        if (this.m_selectedRow == -1) {
            return;
        }
        if (!this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
            this.doTopNBinning();
        } else {
            this.doQtileBinning();
        }
        this.m_BinningType = this.m_dataSourcemodel.getBinType(this.m_selectedRow);
        this.runTimePanelLoad();
        this.updateUIStats();
    }

    protected Hashtable getDisplayNames() {
        Hashtable hashtable = null;
        try {
            hashtable = this.m_dataSourcemodel.getDisplayNames(this.m_selectedRow);
        }
        catch (Exception exception) {
            hashtable = null;
        }
        return hashtable;
    }

    public class DiscretizeNumericFrequency
    extends LongRunningProcess
    implements Cancelable {
        private boolean m_canceled = false;
        private DiscretizationLDSDataSource m_model;
        private int m_row;
        private String m_attributeName;
        private int[] m_frequency = null;

        public DiscretizeNumericFrequency(DiscretizationLDSDataSource discretizationLDSDataSource, int n) {
            this.m_model = discretizationLDSDataSource;
            this.m_row = n;
            this.m_attributeName = this.m_model.getAttributeName(this.m_row);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Connection connection = LDSHistogramPanel.this.m_state.getConnection();
            try {
                try {
                    this.m_frequency = this.m_model.getFrequency(connection, this.m_attributeName, this.m_row);
                    if (this.m_frequency != null && this.m_model.isNumeric(this.m_row)) {
                        Double d = this.m_model.getSkew(this.m_row);
                        Double d2 = this.m_model.getKurtosis(this.m_row);
                        double[] dArray = null;
                        if (d == null || d2 == null) {
                            dArray = this.m_model.getStats(this.m_row);
                            this.m_model.getEqualWidth2ndorderStats(connection, this.m_row, dArray, this.m_attributeName);
                        }
                    }
                    this.getProgressBar().setDoneStatus();
                }
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        exception.printStackTrace();
                    }
                    this.setException(exception);
                    this.m_frequency = null;
                    this.getProgressBar().setDoneStatus();
                    Object var6_7 = null;
                }
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_8 = null;
                throw throwable;
            }
        }

        public boolean isCancelled() {
            return this.m_canceled;
        }

        public void cancel() {
            this.m_canceled = true;
        }

        public int[] getFrequency() {
            return this.m_frequency;
        }
    }
}

