/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;

public abstract class GenerateDefaultsPanel
extends GriddedPanel {
    protected WizardState m_state;
    protected DM4JDialog m_parentDialog;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected JRadioButton m_chkBoxABN = new JRadioButton();
    protected JRadioButton m_chkBoxNB = new JRadioButton();
    protected JRadioButton m_chkBoxSVMC = new JRadioButton();
    protected JRadioButton m_chkBoxSVMR = new JRadioButton();
    protected JRadioButton m_chkBoxAI = new JRadioButton();
    protected JRadioButton m_chkBoxNMF = new JRadioButton();
    protected JRadioButton m_chkBoxAR = new JRadioButton();
    protected JRadioButton m_chkBoxOCluster = new JRadioButton();
    protected JRadioButton m_chkBoxKMeans = new JRadioButton();
    protected JRadioButton m_chkBoxOther = new JRadioButton();
    protected ButtonGroup m_algGroup = new ButtonGroup();
    protected DiscretizeDataSource m_model = null;
    protected SpreadTable m_spreadTable;
    protected Hashtable m_backupData = new Hashtable();
    protected long m_mask;

    public GenerateDefaultsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable, DiscretizeDataSource discretizeDataSource, long l) throws Exception {
        this.m_state = wizardState;
        this.m_parentDialog = dM4JDialog;
        this.m_model = discretizeDataSource;
        this.m_spreadTable = spreadTable;
        this.m_mask = l;
        this.jbInit();
    }

    protected boolean isABN() {
        return (this.m_mask & 1L) > 0L;
    }

    protected boolean isNB() {
        return (this.m_mask & 0x10L) > 0L;
    }

    protected boolean isSVM() {
        return (this.m_mask & 0x100L) > 0L;
    }

    protected boolean isAI() {
        return (this.m_mask & 0x1000L) > 0L;
    }

    protected boolean isNMF() {
        return (this.m_mask & 0x10000L) > 0L;
    }

    protected boolean isAR() {
        return (this.m_mask & 0x100000L) > 0L;
    }

    protected boolean isOC() {
        return (this.m_mask & 0x1000000L) > 0L;
    }

    protected boolean isKM() {
        return (this.m_mask & 0x10000000L) > 0L;
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("GENERATE_DEFAULTS_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent(this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        if (this.isABN()) {
            this.m_chkBoxABN.setText(ResourceUtilities.getUILabel("ABN_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxABN);
            this.m_chkBoxABN.setMnemonic(ResourceUtilities.getUIMnemonic("ABN_OPTION_NAME"));
            this.addComponent(this.m_chkBoxABN, COL1_LABEL, n++, 1, 1, 1);
        }
        if (this.isNB()) {
            this.m_chkBoxNB.setText(ResourceUtilities.getUILabel("NB_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxNB);
            this.m_chkBoxNB.setMnemonic(ResourceUtilities.getUIMnemonic("NB_OPTION_NAME"));
            this.addComponent(this.m_chkBoxNB, COL1_LABEL, n++, 1, 1, 1);
        }
        if (this.isSVM()) {
            this.m_chkBoxSVMC.setText(ResourceUtilities.getUILabel("SVM_CLASSIIFCATION_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxSVMC);
            this.m_chkBoxSVMC.setMnemonic(ResourceUtilities.getUIMnemonic("SVM_CLASSIIFCATION_OPTION_NAME"));
            this.addComponent(this.m_chkBoxSVMC, COL1_LABEL, n++, 1, 1, 1);
            this.m_chkBoxSVMR.setText(ResourceUtilities.getUILabel("SVM_REGRESSION_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxSVMR);
            this.m_chkBoxSVMR.setMnemonic(ResourceUtilities.getUIMnemonic("SVM_REGRESSION_OPTION_NAME"));
            this.addComponent(this.m_chkBoxSVMR, COL1_LABEL, n++, 1, 1, 1);
        }
        if (this.isAI()) {
            this.m_chkBoxAI.setText(ResourceUtilities.getUILabel("AI_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxAI);
            this.m_chkBoxAI.setMnemonic(ResourceUtilities.getUIMnemonic("AI_OPTION_NAME"));
            this.addComponent(this.m_chkBoxAI, COL1_LABEL, n++, 1, 1, 1);
        }
        if (this.isNMF()) {
            this.m_chkBoxNMF.setText(ResourceUtilities.getUILabel("NMF_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxNMF);
            this.m_chkBoxNMF.setMnemonic(ResourceUtilities.getUIMnemonic("NMF_OPTION_NAME"));
            this.addComponent(this.m_chkBoxNMF, COL1_LABEL, n++, 1, 1, 1);
        }
        if (this.isAR()) {
            this.m_chkBoxAR.setText(ResourceUtilities.getUILabel("AR_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxAR);
            this.m_chkBoxAR.setMnemonic(ResourceUtilities.getUIMnemonic("AR_OPTION_NAME"));
            this.addComponent(this.m_chkBoxAR, COL1_LABEL, n++, 1, 1, 1);
        }
        if (this.isOC()) {
            this.m_chkBoxOCluster.setText(ResourceUtilities.getUILabel("OCLUSTER_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxOCluster);
            this.m_chkBoxOCluster.setMnemonic(ResourceUtilities.getUIMnemonic("OCLUSTER_OPTION_NAME"));
            this.addComponent(this.m_chkBoxOCluster, COL1_LABEL, n++, 1, 1, 1);
        }
        if (this.isKM()) {
            this.m_chkBoxKMeans.setText(ResourceUtilities.getUILabel("KMEANS_OPTION_NAME"));
            this.m_algGroup.add(this.m_chkBoxKMeans);
            this.m_chkBoxKMeans.setMnemonic(ResourceUtilities.getUIMnemonic("KMEANS_OPTION_NAME"));
            this.addComponent(this.m_chkBoxKMeans, COL1_LABEL, n++, 1, 1, 1);
        }
        this.m_chkBoxOther.setText(ResourceUtilities.getUILabel("OTHER_ALGORITHMS"));
        this.m_algGroup.add(this.m_chkBoxOther);
        this.m_chkBoxOther.setMnemonic(ResourceUtilities.getUIMnemonic("OTHER_ALGORITHMS"));
        this.addComponent(this.m_chkBoxOther, COL1_LABEL, n++, 1, 1, 1);
        this.loadState();
        this.addOKHelpCancelListeners();
    }

    protected void loadState() throws Exception {
        boolean bl;
        ActivityType activityType = this.getGroupActivity();
        boolean bl2 = bl = this.m_model.getRowCount() > 0;
        if (this.isABN()) {
            this.m_chkBoxABN.setSelected(activityType.equals(ActivityType.ADAPTIVE_NAIVE_BAYES));
            this.m_chkBoxABN.setEnabled(bl);
        }
        if (this.isNB()) {
            this.m_chkBoxNB.setSelected(activityType.equals(ActivityType.NAIVE_BAYES));
            this.m_chkBoxNB.setEnabled(bl);
        }
        if (this.isAI()) {
            this.m_chkBoxAI.setSelected(activityType.equals(ActivityType.ATTRIBUTE_IMPORTANCE));
            this.m_chkBoxAI.setEnabled(bl);
        }
        if (this.isSVM()) {
            this.m_chkBoxSVMC.setSelected(activityType.equals(ActivityType.SVM_CLASSIFICATION));
            this.m_chkBoxSVMC.setEnabled(bl);
            this.m_chkBoxSVMR.setSelected(activityType.equals(ActivityType.SVM_REGRESSION));
            this.m_chkBoxSVMR.setEnabled(bl);
        }
        if (this.isNMF()) {
            this.m_chkBoxNMF.setSelected(activityType.equals(ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION));
            this.m_chkBoxNMF.setEnabled(bl);
        }
        if (this.isAR()) {
            this.m_chkBoxAR.setSelected(activityType.equals(ActivityType.ASSOCIATION_RULES));
            this.m_chkBoxAR.setEnabled(bl);
        }
        if (this.isOC()) {
            this.m_chkBoxOCluster.setSelected(activityType.equals(ActivityType.O_CLUSTER));
            this.m_chkBoxOCluster.setEnabled(bl);
        }
        if (this.isKM()) {
            this.m_chkBoxKMeans.setSelected(activityType.equals(ActivityType.K_MEANS_CLUSTER));
            this.m_chkBoxKMeans.setEnabled(bl);
        }
        this.m_chkBoxOther.setSelected(activityType.equals(ActivityType.OTHER));
    }

    protected ActivityType getGroupActivity() {
        ActivityType activityType = null;
        if (this.m_model.getRowCount() == 0) {
            return ActivityType.OTHER;
        }
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            ActivityType activityType2 = this.m_model.getActivityType(i);
            if (i == 0) {
                activityType = activityType2;
                continue;
            }
            if (activityType == null || activityType2 == null) {
                return ActivityType.OTHER;
            }
            if (activityType2.equals(activityType)) continue;
            return ActivityType.OTHER;
        }
        return activityType != null ? activityType : ActivityType.ADAPTIVE_NAIVE_BAYES;
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GenerateDefaultsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void validate(Vector vector) throws Exception {
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        if (this.m_model.getRowCount() == 0) {
            return;
        }
        int n = JOptionPane.showOptionDialog(this, this.getWarningMessage(), ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null);
        if (n == 1 || n == -1) {
            return;
        }
        ActivityType activityType = null;
        if (this.isABN() && this.m_chkBoxABN.isSelected()) {
            activityType = ActivityType.ADAPTIVE_NAIVE_BAYES;
        }
        if (this.isNB() && this.m_chkBoxNB.isSelected()) {
            activityType = ActivityType.NAIVE_BAYES;
        }
        if (this.isAI() && this.m_chkBoxAI.isSelected()) {
            activityType = ActivityType.ATTRIBUTE_IMPORTANCE;
        }
        if (this.isSVM()) {
            if (this.m_chkBoxSVMC.isSelected()) {
                activityType = ActivityType.SVM_CLASSIFICATION;
            }
            if (this.m_chkBoxSVMR.isSelected()) {
                activityType = ActivityType.SVM_REGRESSION;
            }
        }
        if (this.isNMF() && this.m_chkBoxNMF.isSelected()) {
            activityType = ActivityType.NON_NEGATIVE_MATIX_FACTORIZATION;
        }
        if (this.isAR() && this.m_chkBoxAR.isSelected()) {
            activityType = ActivityType.ASSOCIATION_RULES;
        }
        if (this.isOC() && this.m_chkBoxOCluster.isSelected()) {
            activityType = ActivityType.O_CLUSTER;
        }
        if (this.isKM() && this.m_chkBoxKMeans.isSelected()) {
            activityType = ActivityType.K_MEANS_CLUSTER;
        }
        if (this.m_chkBoxOther.isSelected()) {
            activityType = ActivityType.OTHER;
        }
        this.setGroupActivity(activityType);
        this.processAttributes(activityType);
    }

    protected void setGroupActivity(ActivityType activityType) {
        Object var2_2 = null;
        for (int i = 0; i < this.m_model.getRowCount(); ++i) {
            this.m_model.setActivityType(i, activityType);
        }
    }

    protected abstract void processAttributes(ActivityType var1);

    protected abstract String getWarningMessage();
}

