/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JOptionPane;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DataQueryResult;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.steps.commonsteps.BaseHistogramPanel;
import oracle.dmt.dm4j.wizard.steps.transformsteps.WinsorizeHistogramDialog;
import oracle.dmt.odm.binning.Bin;
import oracle.dss.graph.Graph;

public class DataHistogramPanel
extends BaseHistogramPanel {
    protected Connection m_conn = null;
    protected Hashtable m_functionNames;
    protected String[] m_attributes;
    protected String m_functionName;
    protected String m_dataTableName;
    protected String m_dataSchemaName;
    protected Double m_skewness;
    protected Double m_kurtosis;
    protected Double m_mean;
    protected Double m_std;
    protected Double m_min;
    protected Double m_max;
    protected Integer m_totalCount;
    protected int m_numberofBins;
    protected double m_tailPercent;
    protected int m_backupNumberofBins;
    protected double m_backupTailPercent;
    protected Hashtable m_processes = new Hashtable();
    protected String m_attributeMapping;
    protected String m_valueMapping;
    protected String m_seqIdMapping;
    protected boolean m_isTransactional;
    protected boolean m_bSingleMetric;
    protected ComplexDataStructure m_sampledCDS;
    protected NormalizeDataSource m_cdsModel;

    protected Double getSkew() {
        return this.m_skewness;
    }

    protected Double getKurtosis() {
        return this.m_kurtosis;
    }

    protected Double getAverage() {
        return this.m_mean;
    }

    protected Double getSigma() {
        return this.m_std;
    }

    protected Double getVariance() {
        return this.m_std == null ? null : new Double(Math.pow(this.m_std, 2.0));
    }

    protected Double getMin() {
        return this.m_min;
    }

    protected Double getMax() {
        return this.m_max;
    }

    protected Integer getTotal() {
        return this.m_totalCount;
    }

    protected String getMode() {
        return "";
    }

    protected String getOriginalData() {
        return this.m_dataSchemaName + "." + this.m_dataTableName;
    }

    public DataHistogramPanel(DM4JDialog dM4JDialog, Connection connection, Graph graph, String string, String[] stringArray, String[] stringArray2, ComplexDataStructure complexDataStructure, NormalizeDataSource normalizeDataSource, String string2, String string3, String string4) throws Exception {
        super(dM4JDialog, graph);
        this.m_conn = connection;
        this.m_attributeMapping = string2;
        this.m_valueMapping = string3;
        this.m_seqIdMapping = string4;
        this.m_isTransactional = this.isNonEmpty(this.m_attributeMapping) && this.isNonEmpty(this.m_valueMapping) && this.isNonEmpty(this.m_seqIdMapping);
        this.setDefaults();
        if (stringArray == null || stringArray.length == 0) {
            throw new Exception();
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            throw new Exception();
        }
        if (stringArray2.length != stringArray.length) {
            throw new Exception();
        }
        this.m_attributes = stringArray;
        this.m_attributeName = string != null ? string : stringArray[0];
        this.m_functionNames = new Hashtable();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.m_functionNames.put(stringArray[i], stringArray2[i]);
        }
        this.m_dataTableName = complexDataStructure.getCaseTable();
        this.m_dataSchemaName = complexDataStructure.getCaseSchema();
        this.m_sampledCDS = complexDataStructure;
        this.m_cdsModel = normalizeDataSource;
        this.jbInit();
    }

    public DataHistogramPanel(DM4JDialog dM4JDialog, Connection connection, Graph graph, String string, String[] stringArray, String[] stringArray2, String string2, String string3, String string4, String string5, String string6, boolean bl) throws Exception {
        super(dM4JDialog, graph);
        this.m_conn = connection;
        this.m_attributeMapping = string4;
        this.m_valueMapping = string5;
        this.m_seqIdMapping = string6;
        this.m_bSingleMetric = bl;
        this.m_isTransactional = this.isNonEmpty(this.m_attributeMapping) && this.isNonEmpty(this.m_valueMapping) && this.isNonEmpty(this.m_seqIdMapping);
        this.setDefaults();
        if (stringArray == null || stringArray.length == 0) {
            throw new Exception();
        }
        if (stringArray2 == null || stringArray2.length == 0) {
            throw new Exception();
        }
        if (stringArray2.length != stringArray.length) {
            throw new Exception();
        }
        this.m_attributes = stringArray;
        this.m_attributeName = string != null ? string : stringArray[0];
        this.m_functionNames = new Hashtable();
        for (int i = 0; i < stringArray2.length; ++i) {
            this.m_functionNames.put(stringArray[i], stringArray2[i]);
        }
        this.m_dataTableName = string2;
        this.m_dataSchemaName = string3;
        this.jbInit();
    }

    private boolean isNonEmpty(String string) {
        return string != null && string.length() != 0;
    }

    private void setDefaults() {
        this.m_numberofBins = DiscretizeDataSource.DEFAULT_BIN_NUMBER;
        this.m_tailPercent = DiscretizeDataSource.DEFAULT_TAIL_PERCENT;
    }

    protected void reloadState() {
        this.m_attributeName = (String)this.comboAttributeName.getSelectedItem();
        this.runTimePanelLoad();
        this.updateUIStats();
    }

    protected void loadState() {
        this.runTimePanelLoad();
        this.loadCombo();
    }

    protected void loadCombo() {
        this.m_attributeNames = new DefaultComboBoxModel<String>(this.m_attributes);
        this.m_attributeNames.setSelectedItem(this.m_attributeName);
        this.comboAttributeName.setModel(this.m_attributeNames);
        this.comboAttributeName.setSelectedItem(this.m_attributeName);
    }

    protected boolean showStatistics() {
        return true;
    }

    private boolean isStateInvalid(DataQueryResult dataQueryResult) {
        if (dataQueryResult == null) {
            return true;
        }
        if (0 != this.m_functionName.compareTo(dataQueryResult.getFunctionName())) {
            return true;
        }
        if (0 != this.m_dataTableName.compareTo(dataQueryResult.getDataTableName())) {
            return true;
        }
        if (0 != this.m_dataSchemaName.compareTo(dataQueryResult.getDataSchemaName())) {
            return true;
        }
        return 0 != this.m_attributeName.compareTo(dataQueryResult.getAttributeName());
    }

    protected DataQueryResult createDataQueryResult() throws Exception {
        return new DataQueryResult(this.m_conn, this.m_functionName, this.m_dataTableName, this.m_dataSchemaName, new String[]{this.m_attributeName}, this.m_attributeName, this.m_numberofBins, this.m_tailPercent, this.m_isTransactional, this.m_attributeMapping, this.m_valueMapping, this.m_seqIdMapping, this.m_bSingleMetric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void runTimePanelLoad() {
        int[] nArray = null;
        this.m_functionName = (String)this.m_functionNames.get(this.m_attributeName);
        try {
            try {
                Object[][] objectArray;
                DataQueryResult dataQueryResult = (DataQueryResult)this.m_processes.get(this.m_attributeName);
                if (this.isStateInvalid(dataQueryResult)) {
                    dataQueryResult = this.createDataQueryResult();
                    this.m_processes.put(this.m_attributeName, dataQueryResult);
                    ProgressBar progressBar = new ProgressBar(this.m_parent == null ? BrowserFrame.getMainFrame() : this.m_parent, ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_TITLE"), dataQueryResult, true);
                    dataQueryResult.setProgressBar(progressBar);
                    progressBar.start(ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("HISTOGRAM_FUNCTION_CALCULATION_DIALOG_DESC"));
                    if (progressBar.hasUserCancelled()) {
                        this.m_userCancelled = true;
                        return;
                    }
                    objectArray = dataQueryResult.getFailed();
                    if (null != objectArray) {
                        String string = (String)objectArray + ResourceUtilities.getUILabel("WINSORIZE_ERROR_DESCRIPTION_SINGLE");
                        JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string, ResourceUtilities.getUILabel("BINNING_STRATEGY_WINSORIZE_OPTION"), 0);
                        dataQueryResult.setNumberofBins(this.m_backupNumberofBins);
                        dataQueryResult.setTailPercent(this.m_backupTailPercent);
                        return;
                    }
                }
                nArray = dataQueryResult.getFrequency();
                this.m_skewness = dataQueryResult.getSkew();
                this.m_kurtosis = dataQueryResult.getKurtosis();
                this.m_mean = dataQueryResult.getAverage();
                this.m_std = dataQueryResult.getSigma();
                this.m_min = dataQueryResult.getMin();
                this.m_max = dataQueryResult.getMax();
                this.m_totalCount = dataQueryResult.getTotal();
                this.m_BinningType = dataQueryResult.getBinningType();
                int n = dataQueryResult.getNumberofBins();
                objectArray = new Object[n + 1][1];
                Object[] objectArray2 = new Object[n + 1];
                Object[] objectArray3 = new Object[]{ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE")};
                objectArray[n][0] = new Integer(dataQueryResult.getNullCount());
                objectArray2[n] = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                int n2 = dataQueryResult.getNullCount();
                for (int i = 0; i < n; n2 += ((Integer)objectArray[i][0]).intValue(), ++i) {
                    objectArray[i][0] = nArray != null ? new Integer(nArray[i]) : new Integer(0);
                }
                Vector vector = dataQueryResult.getBinBounds();
                this.histogramTableModel.deleteAllEntries();
                if (vector != null) {
                    int n3;
                    int n4 = 2;
                    NumberFormat numberFormat = DecimalFormat.getNumberInstance();
                    numberFormat.setGroupingUsed(true);
                    numberFormat.setMaximumFractionDigits(n4);
                    numberFormat.setMinimumFractionDigits(0);
                    DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
                    for (n3 = 0; n3 < vector.size(); ++n3) {
                        Bin bin = (Bin)vector.elementAt(n3);
                        DM4JNumericFormat.AdjustFormat(bin.getLowerBound(), bin.getUpperBound(), decimalFormat);
                    }
                    n3 = n;
                    for (int i = 0; i < n; ++i) {
                        if (i >= vector.size()) {
                            n3 = i;
                            break;
                        }
                        String string = "";
                        Bin bin = (Bin)vector.elementAt(i);
                        string = i == 0 ? " < " + DM4JNumericFormat.format(bin.getUpperBound(), decimalFormat) : (i == n - 1 ? " >= " + DM4JNumericFormat.format(bin.getLowerBound(), decimalFormat) : DM4JNumericFormat.format(bin.getLowerBound(), decimalFormat) + " - " + DM4JNumericFormat.format(bin.getUpperBound(), decimalFormat));
                        objectArray2[i] = string;
                        this.histogramTableModel.addEntry(new Object[]{String.valueOf(i), string, objectArray[i][0], this.percentageOfTotal(objectArray[i][0], n2)});
                    }
                    this.histogramTableModel.addEntry(new Object[]{String.valueOf(n3), ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE"), objectArray[n][0], this.percentageOfTotal(objectArray[n][0], n2)});
                }
                this.m_graph.getTitle().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_TITLE") + this.m_attributeName);
                this.m_graph.getO1Title().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_X_TITLE"));
                this.m_graph.getY1Title().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE"));
                this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
                this.m_graph.setScrollbarPresenceGroups(1);
                this.m_graph.setDataRowShownAsASeries(true);
                this.m_graph.setDataSource(new LocalXMLDataSource(objectArray2, objectArray3, objectArray));
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var17_10 = null;
            throw throwable;
        }
    }

    protected boolean showBinDialog() {
        return true;
    }

    protected void butWinsorize_actionPerformed(ActionEvent actionEvent) {
        try {
            DataQueryResult dataQueryResult = (DataQueryResult)this.m_processes.get(this.m_attributeName);
            if (dataQueryResult != null) {
                this.m_backupNumberofBins = dataQueryResult.getNumberofBins();
                this.m_backupTailPercent = dataQueryResult.getTailPercent();
            } else {
                this.m_backupNumberofBins = this.m_numberofBins;
                this.m_backupTailPercent = this.m_tailPercent;
            }
            WinsorizeHistogramDialog winsorizeHistogramDialog = new WinsorizeHistogramDialog(this.m_parentDialog, this.m_backupNumberofBins, this.m_backupTailPercent);
            if (!winsorizeHistogramDialog.isCancelled()) {
                int n = winsorizeHistogramDialog.getNumberofBins();
                double d = winsorizeHistogramDialog.getTailPercent();
                if (this.m_backupNumberofBins != n || this.m_backupTailPercent != d) {
                    this.m_processes.remove(this.m_attributeName);
                    this.m_numberofBins = n;
                    this.m_tailPercent = d;
                    this.reloadState();
                    this.setDefaults();
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected Hashtable getDisplayNames() {
        return null;
    }
}

