/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JNumericRenderer;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.HistogramRangesTableModel;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;
import oracle.dss.dataView.ComponentHandle;
import oracle.dss.dataView.DataComponentHandle;
import oracle.dss.graph.CustomToolTipCallback;
import oracle.dss.graph.Graph;
import oracle.dss.util.DataComponentInfo;

public abstract class BaseHistogramPanel
extends GriddedPanel {
    String m_title = null;
    String m_series = null;
    static String LABEL_FORMAT = "{0} {1}[R][R]Value(s): {2}[R][R]{1}: [YV][R]";
    static int WIDTH = 600;
    static int HEIGHT = 600;
    protected DM4JDialog m_parentDialog = null;
    protected JFrame m_parent = null;
    protected Graph m_graph = null;
    protected String m_attributeName = null;
    protected JPanel pnlMin = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblMinText = new JLabel();
    protected JLabel lblMinValue = new JLabel();
    protected JLabel labelTitle = new JLabel();
    protected JPanel pnlMax = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblMaxText = new JLabel();
    protected JLabel lblMaxValue = new JLabel();
    protected JPanel pnlAverage = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblAverageText = new JLabel();
    protected JLabel lblAverageValue = new JLabel();
    protected JPanel pnlSigma = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblSigmaText = new JLabel();
    protected JLabel lblSigmaValue = new JLabel();
    protected JPanel pnlVariance = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblVarianceText = new JLabel();
    protected JLabel lblVarianceValue = new JLabel();
    protected JPanel pnlSkew = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblSkewText = new JLabel();
    protected JLabel lblSkewValue = new JLabel();
    protected JPanel pnlKurtosis = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblKurtosisText = new JLabel();
    protected JLabel lblKurtosisValue = new JLabel();
    protected JPanel pnlStatsMode = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblStatsModeText = new JLabel();
    protected JLabel lblStatsModeValue = new JLabel();
    protected JPanel pnlSampleCount = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblSampleCountText = new JLabel();
    protected JLabel lblSampleCountValue = new JLabel();
    protected JButton butWinsorize = new JButton();
    protected GriddedPanel pnlCombo = new GriddedPanel();
    protected JLabel lblDataSrc = new JLabel();
    protected JLabel lblAttributeName = new JLabel();
    protected JComboBox comboAttributeName = new JComboBox();
    protected DefaultComboBoxModel m_attributeNames;
    protected JScrollPane scrTablePane = new JScrollPane();
    protected JTable tblBinBounds = new JTable();
    protected JScrollPane scrStatTablePane = new JScrollPane();
    protected JTable tblStatistics = new JTable();
    protected HistogramRangesTableModel histogramTableModel = new HistogramRangesTableModel();
    protected TableSorter m_sorter = new TableSorter(this.histogramTableModel);
    protected ButtonGroup buttonGroup = new ButtonGroup();
    protected JRadioButton verticalGraph = new JRadioButton();
    protected JRadioButton horzGraph = new JRadioButton();
    protected JLabel labelGraphOrientation = new JLabel();
    protected JLabel labelVerticalGraph = new JLabel();
    protected JLabel labelHorizontalGraph = new JLabel();
    protected JLabel labelBinningStrategyLabel = new JLabel();
    protected JLabel labelBinningStrategyText = new JLabel();
    protected Object m_backupData;
    protected boolean m_userCancelled = false;
    protected static String NOT_NULL = " not null ";
    protected static String NULL_VALUE = "null";
    protected String m_BinningType = null;
    protected JSplitPane m_splitPane = null;

    public boolean isUserCancelled() {
        return this.m_userCancelled;
    }

    public BaseHistogramPanel(DM4JDialog dM4JDialog, Graph graph) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_graph = graph;
        this.m_graph.setCustomToolTipCallback(new DMCustomToolTipCallback());
    }

    public BaseHistogramPanel(Frame frame, Graph graph) throws Exception {
        this.m_parent = (JFrame)frame;
        this.m_graph = graph;
        this.m_graph.setCustomToolTipCallback(new DMCustomToolTipCallback());
    }

    protected void jbInit() throws Exception {
        int n;
        int n2;
        block7: {
            JComponent jComponent;
            int n3;
            this.loadState();
            this.comboAttributeName.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BaseHistogramPanel.this.comboSchema_actionPerformed(actionEvent);
                }
            });
            n2 = 0;
            this.lblDataSrc.setText(ResourceUtilities.getUILabel("MRC_FORMAT_DATA_SOURCE") + this.getOriginalData());
            this.lblAttributeName.setText(ResourceUtilities.getUILabel("MRC_FORMAT_ATTRIBUTE_NAME"));
            Insets insets = new Insets(10, 0, 10, 5);
            this.pnlCombo.addFilledComponent(this.lblDataSrc, insets, 0, 0, 2, 1, 1);
            this.pnlCombo.addFilledComponent(this.lblAttributeName, insets, 0, 2, 1, 1, 1);
            this.pnlCombo.addFilledComponent(this.comboAttributeName, insets, 0, 3, 1, 1, 1);
            this.addFilledComponent(this.pnlCombo, COL1_CONTROL, n2++, 0, 6, 1, 1);
            int n4 = n2;
            BaseHistogramPanel.setPreferredSize(new JComponent[]{this.m_graph}, 400, 400);
            this.tblBinBounds.setAutoCreateColumnsFromModel(false);
            this.tblBinBounds.setModel(this.m_sorter);
            this.m_sorter.setTableHeader(this.tblBinBounds.getTableHeader());
            this.tblBinBounds.setDefaultRenderer(Double.class, new DM4JNumericRenderer(4));
            int n5 = this.histogramTableModel.getColumnCount();
            for (n3 = 0; n3 < n5; ++n3) {
                jComponent = new DefaultTableCellRenderer();
                ((JLabel)jComponent).setHorizontalAlignment(2);
                TableColumn tableColumn = new TableColumn(n3, 40, (TableCellRenderer)((Object)jComponent), null);
                this.tblBinBounds.addColumn(tableColumn);
            }
            this.tblBinBounds.setRowSelectionAllowed(false);
            this.scrTablePane.getViewport().add(this.tblBinBounds);
            this.m_splitPane = new JSplitPane(0, this.m_graph, this.scrTablePane);
            this.m_splitPane.setDividerLocation(350);
            n3 = 16;
            this.addComponent(this.m_splitPane, MIDLABELITEMINSETS, n2, 0, 5, n3, 18, 1);
            n2 += n3;
            this.verticalGraph.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BaseHistogramPanel.this.m_graph.setGraphType(17);
                }
            });
            this.horzGraph.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BaseHistogramPanel.this.m_graph.setGraphType(24);
                }
            });
            this.labelGraphOrientation.setText(ResourceUtilities.getUILabel("HISTOGRAM_ORIENTATION_HEADER"));
            this.labelVerticalGraph.setText(ResourceUtilities.getUILabel("HISTOGRAM_ORIENTATION_VERT"));
            this.labelHorizontalGraph.setText(ResourceUtilities.getUILabel("HISTOGRAM_ORIENTATION_HORZ"));
            this.labelVerticalGraph.setLabelFor(this.verticalGraph);
            this.labelHorizontalGraph.setLabelFor(this.horzGraph);
            this.buttonGroup.add(this.verticalGraph);
            this.buttonGroup.add(this.horzGraph);
            jComponent = new GriddedPanel();
            int n6 = 0;
            if (this.m_BinningType != null && 0 != this.m_BinningType.length()) {
                this.labelBinningStrategyLabel.setText(ResourceUtilities.getUILabel("HISTOGRAM_STRATEGY_HEADER"));
                this.labelBinningStrategyText.setText("     " + this.m_BinningType);
                ((GriddedPanel)jComponent).addAnchoredComponent(this.labelBinningStrategyLabel, COL1_LABEL, n6++, 0, 2, 1, 18);
                ((GriddedPanel)jComponent).addAnchoredComponent(this.labelBinningStrategyText, COL1_LABEL, n6++, 0, 2, 1, 18);
                ((GriddedPanel)jComponent).addAnchoredComponent(new JLabel(" "), COL1_LABEL, n6++, 0, 2, 1, 12);
            }
            ((GriddedPanel)jComponent).addAnchoredComponent(this.labelGraphOrientation, COL1_LABEL, n6++, 0, 2, 1, 18);
            ((GriddedPanel)jComponent).addAnchoredComponent(this.verticalGraph, COL1_LABEL, n6, 0, 1, 1, 18);
            ((GriddedPanel)jComponent).addAnchoredComponent(this.labelVerticalGraph, COL1_LABEL, n6++, 1, 1, 1, 18);
            ((GriddedPanel)jComponent).addAnchoredComponent(this.horzGraph, COL1_LABEL, n6, 0, 1, 1, 18);
            ((GriddedPanel)jComponent).addAnchoredComponent(this.labelHorizontalGraph, COL1_LABEL, n6, 1, 1, 1, 18);
            this.addAnchoredComponent(jComponent, COL1_LABEL, n2 - 1, 5, 1, 1, 16);
            boolean bl = 17 == this.m_graph.getGraphType();
            this.verticalGraph.setSelected(bl);
            this.horzGraph.setSelected(!bl);
            n = n2 - 1;
            n2 = n4;
            if (!this.m_userCancelled) {
                try {
                    this.showStatistics();
                }
                catch (Exception exception) {
                    if (this.m_userCancelled) break block7;
                    exception.printStackTrace();
                }
            }
        }
        this.labelTitle = new JLabel();
        this.addFilledComponent(this.labelTitle, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlSampleCount.add(this.lblSampleCountText);
        this.pnlSampleCount.add(this.lblSampleCountValue);
        this.addFilledComponent(this.pnlSampleCount, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlStatsMode.add(this.lblStatsModeText);
        this.pnlStatsMode.add(this.lblStatsModeValue);
        this.addFilledComponent(this.pnlStatsMode, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlMin.add(this.lblMinText);
        this.pnlMin.add(this.lblMinValue);
        this.addFilledComponent(this.pnlMin, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlMax.add(this.lblMaxText);
        this.pnlMax.add(this.lblMaxValue);
        this.addFilledComponent(this.pnlMax, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlAverage.add(this.lblAverageText);
        this.pnlAverage.add(this.lblAverageValue);
        this.addFilledComponent(this.pnlAverage, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlVariance.add(this.lblVarianceText);
        this.pnlVariance.add(this.lblVarianceValue);
        this.addFilledComponent(this.pnlVariance, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlSigma.add(this.lblSigmaText);
        this.pnlSigma.add(this.lblSigmaValue);
        this.addFilledComponent(this.pnlSigma, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlSkew.add(this.lblSkewText);
        this.pnlSkew.add(this.lblSkewValue);
        this.addFilledComponent(this.pnlSkew, COL1_LABEL, n2++, 5, 1, 1, 1);
        this.pnlKurtosis.add(this.lblKurtosisText);
        this.pnlKurtosis.add(this.lblKurtosisValue);
        this.addFilledComponent(this.pnlKurtosis, COL1_LABEL, n2++, 5, 1, 1, 1);
        if (this.showBinDialog()) {
            this.butWinsorize.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_WINSORIZE_OPTION"));
            this.butWinsorize.setEnabled(true);
            this.butWinsorize.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_WINSORIZE_OPTION"));
            this.addComponent(this.butWinsorize, COL1_CONTROL, ++n, 5, 1, 1, 11, 0);
            this.butWinsorize.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BaseHistogramPanel.this.butWinsorize_actionPerformed(actionEvent);
                }
            });
            JButton[] jButtonArray = new JButton[]{this.butWinsorize};
            DM4JResourceUtilities.setPreferredSize(jButtonArray);
        }
        if (!this.m_userCancelled) {
            this.updateUIStats();
        }
    }

    protected abstract void reloadState();

    protected abstract void loadState();

    protected abstract void loadCombo();

    protected abstract void runTimePanelLoad();

    protected abstract boolean showStatistics();

    protected boolean showBinDialog() {
        return false;
    }

    protected void butWinsorize_actionPerformed(ActionEvent actionEvent) {
    }

    protected void updateUIStats() {
        boolean bl = this.showStatistics();
        this.labelTitle.setText(ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_HEADER"));
        if (bl) {
            this.lblSampleCountText.setText("");
            this.lblStatsModeText.setText(ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_SAMPLE_COUNT"));
        } else {
            this.lblSampleCountText.setText(ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_SAMPLE_COUNT"));
            this.lblStatsModeText.setText(ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_STATS_MODE"));
        }
        this.lblMinText.setText(bl ? ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_MIN") : "");
        this.lblMaxText.setText(bl ? ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_MAX") : "");
        this.lblAverageText.setText(bl ? ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_AVERAGE") : "");
        this.lblVarianceText.setText(bl ? ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_VARIANCE") : "");
        this.lblSigmaText.setText(bl ? ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_SIGMA") : "");
        this.lblSkewText.setText(bl ? ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_SKEW") : "");
        this.lblKurtosisText.setText(bl ? ResourceUtilities.getUILabel("HISTOGRAM_STATISTICS_KURTOSIS") : "");
        Double d = null;
        Double d2 = null;
        Double d3 = null;
        Double d4 = null;
        Double d5 = null;
        Double d6 = null;
        Double d7 = null;
        String string = null;
        if (bl) {
            d = this.getSkew();
            d2 = this.getKurtosis();
            d3 = this.getAverage();
            d4 = this.getMin();
            d5 = this.getMax();
            d6 = this.getVariance();
            d7 = this.getSigma();
        } else {
            string = this.getMode();
        }
        Integer n = this.getTotal();
        if (bl) {
            this.lblSampleCountValue.setText("");
            this.lblStatsModeValue.setText(n != null ? n.toString() : "");
        } else {
            this.lblSampleCountValue.setText(n != null ? n.toString() : "");
            this.lblStatsModeValue.setText(string != null ? (string.length() > 10 ? string.substring(0, 9) : string) : "");
        }
        this.lblMinValue.setText(d4 != null ? DM4JNumericFormat.format(d4) : "");
        this.lblMaxValue.setText(d5 != null ? DM4JNumericFormat.format(d5) : "");
        this.lblAverageValue.setText(d3 != null ? DM4JNumericFormat.format(d3) : "");
        this.lblVarianceValue.setText(d6 != null ? DM4JNumericFormat.format(d6) : "");
        this.lblSigmaValue.setText(d7 != null ? DM4JNumericFormat.format(d7) : "");
        this.lblSkewValue.setText(d != null ? DM4JNumericFormat.format(d) : "");
        this.lblKurtosisValue.setText(d2 != null ? DM4JNumericFormat.format(d2) : "");
        if (this.m_BinningType != null && 0 != this.m_BinningType.length()) {
            this.labelBinningStrategyLabel.setText(ResourceUtilities.getUILabel("HISTOGRAM_STRATEGY_HEADER"));
            this.labelBinningStrategyText.setText("     " + this.m_BinningType);
        }
    }

    protected abstract Double getSkew();

    protected abstract Double getKurtosis();

    protected abstract Double getAverage();

    protected abstract Double getMin();

    protected abstract Double getMax();

    protected abstract Double getVariance();

    protected abstract Double getSigma();

    protected abstract Integer getTotal();

    protected abstract String getMode();

    protected abstract String getOriginalData();

    protected Double percentageOfTotal(Object object, int n) {
        Integer n2 = (Integer)object;
        if (n == 0) {
            n = UserPreferences.getInstance().getSampleSize();
        }
        double d = 100.0 * (n2.doubleValue() / (double)n);
        BigDecimal bigDecimal = new BigDecimal(d);
        bigDecimal = bigDecimal.setScale(2, 4);
        d = bigDecimal.doubleValue();
        return d;
    }

    protected void comboSchema_actionPerformed(ActionEvent actionEvent) {
        try {
            this.reloadState();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected abstract Hashtable getDisplayNames();

    protected class DMCustomToolTipCallback
    implements CustomToolTipCallback {
        DMCustomToolTipCallback() {
            if (BaseHistogramPanel.this.m_title == null) {
                BaseHistogramPanel.this.m_title = ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE");
            }
            BaseHistogramPanel.this.m_series = ResourceUtilities.getUILabel("HISTOGRAM_SERIES");
        }

        public String getToolTipText(String string, ComponentHandle componentHandle) {
            String string2 = null;
            try {
                if (componentHandle instanceof DataComponentHandle) {
                    DataComponentHandle dataComponentHandle = (DataComponentHandle)componentHandle;
                    DataComponentInfo dataComponentInfo = (DataComponentInfo)dataComponentHandle.getComponentInfo();
                    int n = dataComponentHandle.getGroup();
                    LocalXMLDataSource localXMLDataSource = (LocalXMLDataSource)BaseHistogramPanel.this.m_graph.getDataSource();
                    String string3 = (String)localXMLDataSource.getMemberMetadata(0, 0, n, "longName");
                    string2 = MessageFormat.format(LABEL_FORMAT, BaseHistogramPanel.this.m_series, BaseHistogramPanel.this.m_title, string3);
                }
            }
            catch (Exception exception) {
                string2 = null;
            }
            return string2 != null ? string2 : string;
        }
    }
}

