/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps;

import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.bali.ewt.wizard.WizardValidateListener;
import oracle.dmt.dm4j.DM4JUserHasCanceledException;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.ValidationPanel;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.WizardStepStateInterface;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.StepDisplayInterface;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class DM4JStep
extends GriddedPanel
implements WizardStepStateInterface,
StepDisplayInterface,
WizardValidateListener {
    protected WizardState m_wizardState;
    protected WizardStepState m_wizardStepState;
    protected WizardStepState m_state;
    protected StepStateType m_stateType = StepStateType.UNLOADED;

    public DM4JStep(WizardStepState wizardStepState) {
        this.m_wizardState = wizardStepState.getparentWizardState();
        this.m_wizardStepState = wizardStepState;
        this.m_state = wizardStepState;
    }

    public DM4JStep() {
    }

    public void load() throws Exception {
        this.m_wizardStepState.load();
        this.init();
    }

    public boolean postValidate(Vector vector) throws Exception {
        return this.m_wizardStepState.postValidate(vector);
    }

    public void refresh() throws Exception {
        this.m_wizardStepState.refresh();
        this.reinit();
    }

    public StepStateType getState() {
        return this.m_wizardStepState.getState();
    }

    protected boolean displayValidations(Vector vector, WizardEvent wizardEvent, WizardStepState wizardStepState) throws Exception {
        boolean bl = false;
        if (vector != null) {
            if (!vector.isEmpty()) {
                ValidationPanel validationPanel = new ValidationPanel(this.m_wizardState.getDialog(), vector);
                if (validationPanel.containsErrors() || validationPanel.isCanceled()) {
                    if (wizardEvent != null) {
                        Cancelable cancelable = (Cancelable)((Object)wizardEvent);
                        cancelable.cancel();
                        this.cancelStepState(wizardEvent);
                    }
                } else {
                    bl = true;
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    protected void cancelStepState(WizardEvent wizardEvent) {
        WizardPage wizardPage = wizardEvent.getPage();
        if (wizardPage instanceof DM4JPage) {
            DM4JPage dM4JPage = (DM4JPage)wizardPage;
            StepType stepType = dM4JPage.getStepType();
            try {
                this.getparentWizardState().cancelStep(stepType);
            }
            catch (Exception exception) {
                this.getparentWizardState().doAbortCancel(exception);
            }
        }
    }

    public void wizardValidatePage(WizardEvent wizardEvent) {
        Vector vector = null;
        try {
            this.m_wizardState.getDM4JWizardDialog().setDialogBusy(true);
            this.processUserInput();
            if (this.m_state.getState() != StepStateType.VALIDATED) {
                StepStateType stepStateType = this.m_state.getState();
                vector = this.m_wizardState.validateStep(this.m_state.getStepType());
                boolean bl = this.displayValidations(vector, wizardEvent, this.m_state);
                if (!bl) {
                    this.focusOnErrorField(vector);
                } else {
                    vector.clear();
                    this.m_wizardState.getDM4JWizardDialog().setDialogBusy(false);
                    if (!this.m_state.postValidate(vector)) {
                        bl = this.displayValidations(vector, null, this.m_state);
                        Cancelable cancelable = (Cancelable)((Object)wizardEvent);
                        cancelable.cancel();
                    }
                }
            }
            this.m_wizardState.getDM4JWizardDialog().setDialogBusy(false);
        }
        catch (DM4JUserHasCanceledException dM4JUserHasCanceledException) {
            Cancelable cancelable = (Cancelable)((Object)wizardEvent);
            cancelable.cancel();
            this.m_wizardState.getDM4JWizardDialog().setDialogBusy(false);
        }
        catch (Exception exception) {
            this.m_wizardState.getDM4JWizardDialog().setDialogBusy(false);
            this.m_wizardState.doAbortCancel(exception);
        }
    }

    protected void processUserInput() {
    }

    protected void focusOnErrorField(Vector vector) {
    }

    public void validate(Vector vector) throws Exception {
    }

    public WizardState getparentWizardState() {
        return this.m_wizardState;
    }

    public void init() throws Exception {
    }

    public void reinit() throws Exception {
    }
}

