/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.transforms.TextState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class ViewNameState
extends WizardStepState {
    private StringBuffer m_viewName = new StringBuffer(0);
    private StringBuffer m_sampledViewName = new StringBuffer(0);
    private StringBuffer m_viewComment = new StringBuffer(0);

    public ViewNameState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        BrowserContext browserContext;
        this.validateViewName(vector, this.m_viewName);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateViewComment(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateQuotedName(vector, this.m_viewName);
        }
        if ((browserContext = this.getparentWizardState().getBrowserContext()).getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            if (!ValidationUtil.validationsContainsErrors(vector)) {
                this.validateViewName(vector, this.m_sampledViewName);
            }
            if (!ValidationUtil.validationsContainsErrors(vector)) {
                this.validateQuotedName(vector, this.m_sampledViewName);
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    private void validateViewComment(Vector vector) throws Exception {
        if (!ValidationUtil.checkStringLength(this.m_viewComment.toString(), 4000)) {
            String string = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
            String[] stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("VIEW_NAME_COMMENT"), Integer.toString(4000)};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_COMMENT_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
    }

    private void validateViewName(Vector vector, StringBuffer stringBuffer) throws Exception {
        String[] stringArray;
        String string;
        boolean bl = DM4JStringUtils.isDoubleQuotedString(stringBuffer.toString());
        String string2 = stringBuffer.toString();
        if (bl) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (string2.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("VIEW_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(string2, 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("VIEW_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater32BytesInDB(string2, this.getparentWizardState().getConnection())) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("VIEW_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_GREATER_30BYTES, string, stringArray));
        }
        if (this.getparentWizardState() instanceof TextState && ValidationUtil.containsDoubleQuote(string2)) {
            string = ResourceUtilities.getstateExceptionMessage("CONTAINS_DOUBLE_QUOTES");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("DATA_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_CONTAINS_DOUBLE_QUOTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(string2)) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("VIEW_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EQUALS_ROWID, string, stringArray));
        }
        string = DM4JConnectionManager.getUser().toUpperCase();
        if (!ValidationUtil.isTableNameUnique(string2, this.getparentWizardState().getConnection())) {
            vector.add(new StateValidation(NameStateError.VIEW_NAME_DUPLICATE));
        }
    }

    private void validateQuotedName(Vector vector, StringBuffer stringBuffer) throws Exception {
        boolean bl = DM4JStringUtils.isDoubleQuotedString(stringBuffer.toString());
        String string = stringBuffer.toString();
        if (bl) {
            string = DM4JStringUtils.trimDoubleQuotes(string);
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public String getViewName() {
        return this.m_viewName.toString();
    }

    public String getSampledViewName() {
        return this.m_sampledViewName.toString();
    }

    public String getViewComment() {
        return this.m_viewComment.toString();
    }

    public void setViewComment(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_viewComment.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_viewComment.setLength(0);
            this.m_viewComment.append(string.trim());
        }
    }

    public void setViewName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_viewName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_viewName.setLength(0);
                this.m_viewName.append(string);
            }
        }
    }

    public void setSampledViewName(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_sampledViewName.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_sampledViewName.setLength(0);
                this.m_sampledViewName.append(string);
            }
        }
    }

    protected void loadDefaults() throws Exception {
        String string;
        String string2;
        Serializable serializable;
        Object object;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            object = browserContext.getActivity();
            serializable = browserContext.getInputDataDescriptor();
            string2 = ((ComplexDataStructure)serializable).getCaseTable();
            string = ((ComplexDataStructure)serializable).getCaseSchema();
        } else {
            object = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            string2 = ((DataState)object).getSelectedTableName();
            string = ((DataState)object).getSelectedSchemaName();
        }
        object = this.getparentWizardState().getConnection();
        serializable = new StringBuffer(string2);
        if (((StringBuffer)serializable).length() > 28) {
            ((StringBuffer)serializable).setLength(28);
        }
        String string3 = ValidationUtil.createUniqueTableName(((StringBuffer)serializable).toString(), (Connection)object, "");
        this.m_viewName.setLength(0);
        if (ValidationUtil.isValidNonQuotedDBObjectName(string3)) {
            this.m_viewName.append(string3);
        } else {
            this.m_viewName.append(DM4JStringUtils.addDoubleQuotes(string3));
        }
        String string4 = ValidationUtil.createUniqueTableName(((StringBuffer)serializable).toString(), (Connection)object, "_S");
        this.m_sampledViewName.setLength(0);
        if (ValidationUtil.isValidNonQuotedDBObjectName(string4)) {
            this.m_sampledViewName.append(string4);
        } else {
            this.m_sampledViewName.append(DM4JStringUtils.addDoubleQuotes(string4));
        }
        String string5 = null;
        string5 = browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) ? browserContext.getActivity().getTitle() : this.getparentWizardState().getDM4JWizardDialog().getWizardTitle();
        String string6 = string;
        String string7 = string2;
        String[] stringArray = new String[]{string5, string6, string7};
        String string8 = ResourceUtilities.getstateExceptionMessage("VIEW_NAME_COMMENT_TEMPLATE", stringArray);
        this.m_viewComment.setLength(0);
        this.m_viewComment.append(string8);
    }
}

