/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.steps.SplitStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class StratifiedSplitTargetState
extends WizardStepState {
    private StringBuffer m_targetColName = new StringBuffer(0);
    private CaseCountDataState m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    private DiscretizationLDSDataSource m_ds;
    private ArrayList m_attrList = null;
    private SplitStepOptions m_options = null;

    public StratifiedSplitTargetState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof SplitStepOptions) {
            this.m_options = (SplitStepOptions)browserContext.getOptions();
        }
    }

    public void validate(Vector vector) throws Exception {
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        try {
            WizardState wizardState = this.getparentWizardState();
            BrowserContext browserContext = wizardState.getBrowserContext();
            this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                this.loadDefaults();
                this.setState(StepStateType.LOADED);
                return;
            }
            boolean bl = false;
            if (this.m_dataState instanceof MultiRecordCaseData) {
                CaseCountDataState caseCountDataState = this.m_dataState;
                bl = caseCountDataState.isSingleMetric();
            }
            this.m_ds = new DiscretizationLDSDataSource(DM4JConnectionManager.getDbConnection(), this.m_dataState, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), false, true, bl);
            ProgressBar progressBar = null;
            boolean bl2 = !this.getparentWizardState().getDisplayUI();
            progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("ATTRIBUTE_VALUE_COUNT_DIALOG_TITLE"), this.m_ds, true, bl2);
            this.m_ds.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("ATTRIBUTE_CASES_DIALOG_TITLE"), "");
            progressBar.waitUntilDone();
            if (this.m_ds.getException() != null) {
                this.setState(StepStateType.DIRTY);
                this.getparentWizardState().doAbortCancel(this.m_ds.getException());
            } else if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
            } else {
                this.m_attrList = new ArrayList(this.m_ds.getAllAttributes());
                this.loadDefaults();
                this.setState(StepStateType.LOADED);
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    public String getTargetColumnName() {
        return this.m_targetColName.toString();
    }

    public void setTargetColumnName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_targetColName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_targetColName.setLength(0);
            this.m_targetColName.append(string);
        }
    }

    public CaseCountDataState getDataState() {
        return this.m_dataState;
    }

    protected void loadDefaults() throws Exception {
        if (this.m_options != null) {
            if (this.m_options.getCaseCount() == 0) {
                this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
                int n = this.m_dataState.getCaseCount();
                this.m_options.setCaseCount(n);
            }
            BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
            this.m_targetColName = new StringBuffer(browserContext.getActivity().getTargetColumn().getAlias());
        }
    }

    public Vector getColumnNames() throws Exception {
        return new Vector(this.m_attrList);
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public DiscretizationLDSDataSource getLDSDataSource() {
        return this.m_ds;
    }
}

