/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.AttrValCountsTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.BaseSampleSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedTargetState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.StratifiedSettingsStateError;

public class StratifiedSettingsState
extends BaseSampleSettingsState {
    private AttrValCountsTableModel m_tblModel = null;
    private boolean m_isAttrValNumber = false;

    public StratifiedSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        if (this.m_tblModel.getSumPercentage() >= 100.01 || this.m_tblModel.getSumPercentage() <= 99.99) {
            String string = ResourceUtilities.getstateExceptionMessage("SAMPLE_SUM_EXCEEDED_100");
        } else {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            if (this.m_tblModel.getSampleSizeExceededCase(stringBuffer, stringBuffer2)) {
                String[] stringArray = new String[]{stringBuffer.toString(), stringBuffer2.toString()};
                String string = ResourceUtilities.getstateExceptionMessage("SAMPLE_SIZE_EXCEEDED", stringArray);
                vector.add(new StateValidation(StratifiedSettingsStateError.SAMPLE_SIZE_EXCEEDED, string, stringArray));
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean isAttrValNumber() {
        return this.m_isAttrValNumber;
    }

    public AttrValCountsTableModel getTableModel() {
        return this.m_tblModel;
    }

    public void setTableModel(AttrValCountsTableModel attrValCountsTableModel) {
        this.m_tblModel = attrValCountsTableModel;
    }

    public void refresh() throws Exception {
        this.setState(StepStateType.LOADED);
    }

    public void load() throws Exception {
        this.loadDefaults();
        this.setState(StepStateType.LOADED);
    }

    protected void loadDefaults() {
        if (this.m_options == null) {
            super.loadDefaults();
        }
        if (this.m_options != null && this.m_options.isEqualDistribution()) {
            this.setEqualDistribution();
        }
    }

    public void restore() {
        this.m_tblModel.restore();
        if (this.m_options != null) {
            this.m_options.setEqualDistribution(false);
        }
        try {
            this.validate(new Vector());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setStateLoaded() {
        this.setState(StepStateType.LOADED);
    }

    public void setEqualDistribution() {
        int n = this.m_tblModel.getRowCount();
        Long l = null;
        for (int i = 0; i < n; ++i) {
            long l2 = (Long)this.m_tblModel.getValueAt(i, 4);
            if (l2 == 0L) continue;
            if (l == null) {
                l = new Long(l2);
                continue;
            }
            if (l2 >= l) continue;
            l = new Long(l2);
        }
        if (l == null) {
            return;
        }
        long l3 = (long)n * l;
        Double d = new Double(100.0 * l.doubleValue() / (double)l3);
        StratifiedTargetState stratifiedTargetState = (StratifiedTargetState)this.getparentWizardState().getStep(StepType.SETTING_STEP);
        stratifiedTargetState.setSampleNumberOfCases(new Long(l3));
        for (int i = 0; i < n; ++i) {
            this.m_tblModel.setValueAt(d, i, 3);
            this.m_tblModel.setValueAt(l, i, 4);
        }
        if (this.m_options != null) {
            this.m_options.setEqualDistribution(true);
        }
    }
}

