/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.SplitStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.SplitSettingsStateError;

public class SplitSettingsState
extends WizardStepState {
    private StringBuffer m_buildPercentage = new StringBuffer(0);
    private boolean m_randomizeBeforeSplit = true;
    private StringBuffer m_testPercentage = new StringBuffer(0);
    protected SplitStepOptions m_options = null;

    public SplitSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof SplitStepOptions) {
            this.m_options = (SplitStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_buildPercentage = new StringBuffer(this.m_options.getBuildTablePercentage().toString());
            this.m_testPercentage = new StringBuffer(this.m_options.getTestTablePercentage().toString());
            this.m_randomizeBeforeSplit = this.m_options.isRandomizeBeforeSplit();
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validatePercentage(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    protected void loadDefaults() {
        if (this.m_options == null) {
            int n = this.getDataState().getCaseCount();
            if (n >= 10000) {
                this.m_buildPercentage.setLength(0);
                this.m_buildPercentage.append("50");
                this.m_testPercentage.setLength(0);
                this.m_testPercentage.append("50");
            } else {
                this.m_buildPercentage.setLength(0);
                this.m_buildPercentage.append("60");
                this.m_testPercentage.setLength(0);
                this.m_testPercentage.append("40");
            }
            this.m_randomizeBeforeSplit = !this.launchedFromActivityGuide();
        }
    }

    protected void validatePercentage(Vector vector) throws Exception {
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(this.m_buildPercentage.toString());
            if (n <= 0 || n >= 100) {
                vector.add(new StateValidation(SplitSettingsStateError.SPLIT_BUILD_INVALID_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(SplitSettingsStateError.SPLIT_BUILD_INVALID_PERCENTAGE));
        }
        try {
            n2 = Integer.parseInt(this.m_testPercentage.toString());
            if (n2 <= 0 || n2 >= 100) {
                vector.add(new StateValidation(SplitSettingsStateError.SPLIT_TEST_INVALID_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(SplitSettingsStateError.SPLIT_TEST_INVALID_PERCENTAGE));
        }
    }

    public CaseCountDataState getDataState() {
        return (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }

    public String getBuildTablePercentage() {
        return this.m_buildPercentage.toString();
    }

    public String getTestTablePercentage() {
        return this.m_testPercentage.toString();
    }

    public void setBuildTablePercentage(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_buildPercentage.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_buildPercentage.setLength(0);
            this.m_buildPercentage.append(string.trim());
            if (this.m_options != null) {
                this.m_options.setBuildTablePercentage(new Integer(this.m_buildPercentage.toString()));
            }
        }
    }

    public void setTestTablePercentage(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_testPercentage.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_testPercentage.setLength(0);
            this.m_testPercentage.append(string.trim());
            if (this.m_options != null) {
                this.m_options.setTestTablePercentage(new Integer(this.m_testPercentage.toString()));
            }
        }
    }

    public void setRandomizeBeforeSplit(boolean bl) {
        if (!this.m_randomizeBeforeSplit == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_randomizeBeforeSplit = bl;
            if (this.m_options != null) {
                this.m_options.setRandomizeBeforeSplit(this.m_randomizeBeforeSplit);
            }
        }
    }

    public boolean getRandomizeBeforeSplit() {
        return this.m_randomizeBeforeSplit;
    }

    private boolean launchedFromActivityGuide() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }
}

