/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Vector;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.datasources.DBDataSource;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.state.transformsteps.RecodeScheme;

public class RecodeDataSource
extends DBDataSource {
    private static final int COLUMN_COUNT = 4;
    private static final String ATTRIBUTE_NAME_COLUMN = "Name";
    private static final String ATTRIBUTE_TYPE_COLUMN = "Type";
    private static final String ATTRIBUTE_RECODE_COLUMN = "Scheme";
    private static final String ATTRIBUTE_META_COLUMN = "Meta";
    public static final int ATTRIBUTE_NAME_IDX = 0;
    public static final int ATTRIBUTE_TYPE_IDX = 1;
    public static final int ATTRIBUTE_RECODE_IDX = 2;
    public static final int ATTRIBUTE_META_IDX = 3;
    private String m_schemaName;
    private String m_tableName;
    private String m_attributeNameMapping;
    private String m_valueMapping;
    private boolean m_isTransactional = false;
    private ArrayList m_unusedAttrs = new ArrayList();

    public RecodeDataSource(Connection connection, String string, String string2) {
        super(connection);
        this.m_schemaName = string;
        try {
            this.m_tableName = TransformsDirector.getReplacedString(string2, "'", "''");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public RecodeDataSource(Connection connection, String string, String string2, String string3, String string4) {
        this(connection, string, string2);
        this.m_attributeNameMapping = string3;
        this.m_valueMapping = string4;
        this.m_isTransactional = true;
    }

    public ArrayList getUnusedAttributes() {
        return this.m_unusedAttrs;
    }

    protected void createData() throws SQLException {
        if (this.m_isTransactional) {
            this.createDataFromTransactionalDBTable();
        } else {
            this.createDataFrom2DDBTable();
        }
    }

    /*
     * Loose catch block
     */
    private void createDataFrom2DDBTable() throws SQLException {
        block10: {
            String string = "SELECT column_name, data_type FROM all_tab_columns WHERE owner = '" + this.m_schemaName + "' and table_name = '" + this.m_tableName + "'";
            Statement statement = null;
            ResultSet resultSet = null;
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(string);
            int n = 1;
            int n2 = 0;
            while (resultSet.next()) {
                String string2 = resultSet.getString("column_name");
                String string3 = resultSet.getString("data_type");
                if (string3.equals("NUMBER") || string3.equals("FLOAT") || string3.equals("NCHAR") || string3.equals("NVARCHAR2") || string3.equals("CHAR") || string3.equals("VARCHAR2")) {
                    this.addRows(n - 1, 1);
                    this.setData(0, n - 1, string2);
                    this.setData(1, n - 1, string3);
                    ++n;
                } else {
                    this.m_unusedAttrs.add(string2);
                }
                ++n2;
            }
            Object var9_9 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block10;
            {
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw sQLException;
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    private void createDataFromTransactionalDBTable() throws SQLException {
        block8: {
            String string = "SELECT \"" + this.m_valueMapping + "\" " + "FROM \"" + this.m_schemaName + "\".\"" + this.m_tableName + "\"";
            String string2 = "SELECT DISTINCT \"" + this.m_attributeNameMapping + "\" " + "FROM \"" + this.m_schemaName + "\".\"" + this.m_tableName + "\"";
            Statement statement = null;
            ResultSet resultSet = null;
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            String string3 = resultSetMetaData.getColumnTypeName(1);
            resultSet.close();
            resultSet = null;
            int n = 0;
            resultSet = statement.executeQuery(string2);
            while (resultSet.next()) {
                String string4 = resultSet.getString(1);
                this.addRows(n, 1);
                this.setData(0, n, string4);
                this.setData(1, n++, string3);
            }
            Object var10_10 = null;
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break block8;
            {
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                    throw sQLException;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    protected ArrayOneDModel createColumns() throws Exception {
        this.addColumns(0, 4);
        Object[] objectArray = new String[]{ATTRIBUTE_NAME_COLUMN, ATTRIBUTE_TYPE_COLUMN, ATTRIBUTE_RECODE_COLUMN, ATTRIBUTE_META_COLUMN};
        return new ArrayOneDModel(objectArray);
    }

    public ArrayList getSchemes(int n) {
        return (ArrayList)this.getData(3, n);
    }

    public void setSchemes(int n, ArrayList arrayList) {
        this.setData(3, n, arrayList);
        int n2 = arrayList.size();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n2; ++i) {
            RecodeScheme recodeScheme = (RecodeScheme)arrayList.get(i);
            stringBuffer.append(recodeScheme.toString());
            if (i >= n2 - 1) continue;
            stringBuffer.append(", ");
        }
        this.setData(2, n, stringBuffer.toString());
    }

    public void clearSchemes(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Integer n = (Integer)vector.get(i);
            this.setData(3, n, null);
            this.setData(2, n, null);
        }
    }
}

