/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.steps.OutlierTreatmentStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.OutlierViewDefinition;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationViewNameState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataUsageState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;

public class OutlierSettingsState
extends DiscretizationSettingsState {
    protected double m_LowerPercent = 0.0;
    protected double m_UpperPercent = 0.0;
    protected double m_LowerValue = 0.0;
    protected double m_UpperValue = 0.0;
    protected double m_SigmaMultiple = 3.0;
    protected double m_CustomUpperValue = 0.0;
    protected double m_CustomLowerValue = 0.0;
    protected StringBuffer m_originalDataViewDefinition = null;
    private static int PERCENT = 0;
    private static int VALUE = 1;
    private static int SIGMA = 2;
    protected int m_nValidationType;
    protected OutlierDiscretizeDataSource m_model;
    protected OutlierTreatmentStepOptions m_options = null;

    public OutlierSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof OutlierTreatmentStepOptions) {
            this.m_options = (OutlierTreatmentStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_LowerPercent = this.m_options.getLowerPercent();
            this.m_UpperPercent = this.m_options.getUpperPercent();
            this.m_LowerValue = this.m_options.getLowerValue();
            this.m_UpperValue = this.m_options.getUpperValue();
            this.m_SigmaMultiple = this.m_options.getSigmaMultiple();
            if (this.m_options.getValidationType() == 0) {
                this.m_nValidationType = PERCENT;
            } else if (this.m_options.getValidationType() == 1) {
                this.m_nValidationType = VALUE;
            } else if (this.m_options.getValidationType() == 2) {
                this.m_nValidationType = SIGMA;
            }
        }
    }

    protected void loadDefaults() {
        this.m_LowerPercent = 0.0;
        this.m_UpperPercent = 0.0;
        this.m_LowerValue = 0.0;
        this.m_UpperValue = 0.0;
        this.m_nValidationType = SIGMA;
        this.m_SigmaMultiple = 3.0;
    }

    public void setPercentValidation() {
        this.m_nValidationType = PERCENT;
        if (this.m_options != null) {
            this.m_options.setValidationType(0);
        }
    }

    public void setValueValidation() {
        this.m_nValidationType = VALUE;
        if (this.m_options != null) {
            this.m_options.setValidationType(1);
        }
    }

    public void setSigmaValidation() {
        this.m_nValidationType = SIGMA;
        if (this.m_options != null) {
            this.m_options.setValidationType(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        DiscretizationViewNameState discretizationViewNameState = (DiscretizationViewNameState)this.getparentWizardState().getStep(StepType.NAME_STEP);
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        this.m_model = outlierDataUsageState.getNumericModel();
        OutlierViewDefinition outlierViewDefinition = null;
        try {
            outlierViewDefinition = new OutlierViewDefinition(this.m_model, "\"" + DM4JConnectionManager.getUser() + "\".\"" + discretizationViewNameState.getViewName() + "\"");
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), outlierViewDefinition, true);
            outlierViewDefinition.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_DESC"));
            if (outlierViewDefinition.getException() != null) {
                this.setState(StepStateType.DIRTY);
                bl = false;
                this.getparentWizardState().doAbortCancel(outlierViewDefinition.getException());
            } else if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                bl = false;
            } else {
                this.setState(StepStateType.VALIDATED);
                StringBuffer stringBuffer = (StringBuffer)outlierViewDefinition.getView();
                int n = stringBuffer.indexOf(" AS SELECT ");
                this.m_viewDefinition = new StringBuffer(stringBuffer.substring(n));
                String string = "";
                string = this.m_model.isTransactional() && !this.m_model.isSingleMetric() ? "" : this.m_model.getOriginalDataLocation();
                this.m_viewDefinition.append(string);
            }
            Object var11_10 = null;
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            throw throwable;
        }
        return bl;
    }

    public void validateValues(Vector vector) throws Exception {
        if (this.m_nValidationType == PERCENT) {
            this.validateTailPercentValue(vector);
        } else if (this.m_nValidationType == SIGMA) {
            this.validateSigmaValue(vector);
        } else if (this.m_nValidationType == VALUE) {
            this.validateTailValues(vector);
        }
    }

    public void validateTailValues(Vector vector) throws Exception {
        try {
            if (this.m_LowerValue >= this.m_UpperValue) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_LOWER_UPPER_TAIL_VALUE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_TAIL_VALUE_EXCEPTION));
        }
    }

    public void validateSigmaValue(Vector vector) throws Exception {
        try {
            if (this.m_SigmaMultiple > 5.0 || this.m_SigmaMultiple <= 0.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_SIGMA_MULTIPLE_VALUE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_SIGMA_MULTIPLE_VALUE_EXCEPTION));
        }
    }

    public void setSigmaMultiple(double d) {
        if (d != this.m_SigmaMultiple) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_SigmaMultiple = d;
            if (this.m_options != null) {
                this.m_options.setSigmaMultiple(this.m_SigmaMultiple);
            }
        }
    }

    public double getSigmaMultiple() {
        return this.m_SigmaMultiple;
    }

    public void validateTailPercentValue(Vector vector) throws Exception {
        try {
            if (this.m_LowerPercent < 0.0 || this.m_LowerPercent >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_LOWER_TAIL_PERCENTAGE));
            } else if (this.m_UpperPercent < 0.0 || this.m_UpperPercent >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_UPPER_TAIL_PERCENTAGE));
            } else if (this.m_UpperPercent + this.m_LowerPercent >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_LOWER_UPPER_TAIL_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.OUTLIER_INVALID_TAIL_PERCENTAGE_EXCEPTION));
        }
    }

    public void setLowerTailPercent(double d) {
        if (d != this.m_LowerPercent) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_LowerPercent = d;
            if (this.m_options != null) {
                this.m_options.setLowerPercent(this.m_LowerPercent);
            }
        }
    }

    public double getLowerTailPercent() {
        return this.m_LowerPercent;
    }

    public void setUpperTailPercent(double d) {
        if (d != this.m_UpperPercent) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_UpperPercent = d;
            if (this.m_options != null) {
                this.m_options.setUpperPercent(this.m_UpperPercent);
            }
        }
    }

    public double getUpperTailPercent() {
        return this.m_UpperPercent;
    }

    public void setLowerTailValue(double d) {
        if (d != this.m_LowerValue) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_LowerValue = d;
            if (this.m_options != null) {
                this.m_options.setLowerValue(this.m_LowerValue);
            }
        }
    }

    public double getLowerTailValue() {
        return this.m_LowerValue;
    }

    public void setUpperTailValue(double d) {
        if (d != this.m_UpperValue) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_UpperValue = d;
            if (this.m_options != null) {
                this.m_options.setUpperValue(this.m_UpperValue);
            }
        }
    }

    public double getUpperTailValue() {
        return this.m_UpperValue;
    }

    public void setCustomLowerTailValue(double d) {
        if (d != this.m_CustomLowerValue) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_CustomLowerValue = d;
        }
    }

    public double getCustomLowerTailValue() {
        return this.m_CustomLowerValue;
    }

    public void setCustomUpperTailValue(double d) {
        if (d != this.m_CustomUpperValue) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_CustomUpperValue = d;
        }
    }

    public double getCustomUpperTailValue() {
        return this.m_CustomUpperValue;
    }

    public ComplexDataStructure getInputCDS() {
        return null;
    }

    public ComplexDataStructure getOutputCDS() {
        return null;
    }

    public StringBuffer getOriginalDataViewDefinition() {
        if (this.m_originalDataViewDefinition != null && this.getState() != StepStateType.VALIDATED) {
            this.m_originalDataViewDefinition.setLength(0);
            this.m_originalDataViewDefinition = null;
        }
        return this.m_originalDataViewDefinition;
    }
}

