/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class ODMrTextNameState
extends WizardStepState {
    private final int NAME_LENGTH_MAX = 30;
    private final int COMMENT_LENGTH_MAX = 4000;
    private StringBuffer m_explainTable = new StringBuffer(0);
    private StringBuffer m_mappingTable = new StringBuffer(0);
    private StringBuffer m_explainComment = new StringBuffer(0);
    private StringBuffer m_mappingComment = new StringBuffer(0);
    private boolean m_createTable = true;

    public ODMrTextNameState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        this.validateODMrTextExplainTableName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateODMrTextMappingTableName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateDuplicateNames(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateComments(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateQuotedName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateDuplicateNames(Vector vector) throws Exception {
        String string;
        String string2 = this.m_explainTable.toString();
        if (string2.equals(string = this.m_mappingTable.toString())) {
            vector.add(new StateValidation(NameStateError.ODMR_TEXT_EXPLAIN_MAPPING_TABLE_NAME_DUPLICATE));
        }
    }

    private void validateComments(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (!ValidationUtil.checkStringLength(this.m_explainComment.toString(), 4000)) {
            string = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("ODMR_TEXT_EXPLAIN_COMMENT"), Integer.toString(4000)};
            vector.add(new StateValidation(NameStateError.ODMR_TEXT_EXPLAIN_TABLE_COMMENT_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_mappingComment.toString(), 4000)) {
            string = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("ODMR_TEXT_MAPPING_COMMENT"), Integer.toString(4000)};
            vector.add(new StateValidation(NameStateError.ODMR_TEXT_MAPPING_TABLE_COMMENT_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
    }

    private void validateODMrTextExplainTableName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_explainTable.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_EXPLAIN_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_explainTable.toString(), 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_EXPLAIN_TABLE_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater32BytesInDB(this.m_explainTable.toString(), this.getparentWizardState().getConnection())) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_EXPLAIN_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_GREATER_30BYTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(this.m_explainTable.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_EXPLAIN_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EQUALS_ROWID, string, stringArray));
        }
        string = DM4JConnectionManager.getUser();
        if (!ValidationUtil.isTableNameUnique(this.m_explainTable.toString(), this.getparentWizardState().getConnection())) {
            vector.add(new StateValidation(NameStateError.ODMR_TEXT_EXPLAIN_TABLE_NAME_DUPLICATE));
        }
    }

    private void validateODMrTextMappingTableName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_mappingTable.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_MAPPING_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_mappingTable.toString(), 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_MAPPING_TABLE_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater32BytesInDB(this.m_mappingTable.toString(), this.getparentWizardState().getConnection())) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_MAPPING_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_GREATER_30BYTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(this.m_mappingTable.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getUILabel("ODMR_TEXT_NAME_MAPPING_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EQUALS_ROWID, string, stringArray));
        }
        string = DM4JConnectionManager.getUser();
        if (!ValidationUtil.isTableNameUnique(this.m_mappingTable.toString(), this.getparentWizardState().getConnection())) {
            vector.add(new StateValidation(NameStateError.ODMR_TEXT_MAPPING_TABLE_NAME_DUPLICATE));
        }
    }

    private void validateQuotedName(Vector vector) throws Exception {
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_explainTable.toString());
        String string = this.m_explainTable.toString();
        if (bl) {
            string = DM4JStringUtils.trimDoubleQuotes(string);
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
        boolean bl2 = DM4JStringUtils.isDoubleQuotedString(this.m_mappingTable.toString());
        String string2 = this.m_mappingTable.toString();
        if (bl2) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (!bl2 && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    public String getOutputExplainTable() {
        return this.m_explainTable.toString();
    }

    public String getOutputMappingTable() {
        return this.m_mappingTable.toString();
    }

    public String getExplainComment() {
        return this.m_explainComment.toString();
    }

    public String getMappingComment() {
        return this.m_mappingComment.toString();
    }

    public void setExplainComment(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_explainComment.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_explainComment.setLength(0);
            this.m_explainComment.append(string.trim());
        }
    }

    public void setMappingComment(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_mappingComment.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_mappingComment.setLength(0);
            this.m_mappingComment.append(string.trim());
        }
    }

    public void setOutputExplainTable(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_explainTable.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_explainTable.setLength(0);
                this.m_explainTable.append(string);
            }
        }
    }

    public void setOutputMappingTable(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_mappingTable.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_mappingTable.setLength(0);
                this.m_mappingTable.append(string);
            }
        }
    }

    protected void loadDefaults() throws Exception {
        String string;
        Object object;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        String string2 = "EXP";
        String string3 = "MAP";
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            object = browserContext.getInputDataDescriptor();
            string = ((ComplexDataStructure)object).getCaseTable();
            string2 = "EXP";
            string3 = "MAP";
        } else {
            object = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            string = ((DataState)object).getSelectedTableName();
            string2 = "_EXP_";
            string3 = "_MAP_";
        }
        object = this.getparentWizardState().getConnection();
        StringBuffer stringBuffer = new StringBuffer(ValidationUtil.createNonQuotedCompliantName(string));
        if (stringBuffer.length() > 17) {
            stringBuffer.setLength(17);
        }
        stringBuffer.append(string2);
        String string4 = DM4JConnectionManager.getUser();
        String string5 = ValidationUtil.createUniqueTableNameUsingRandom(stringBuffer.toString(), (Connection)object, "");
        this.m_explainTable.setLength(0);
        if (ValidationUtil.isValidNonQuotedDBObjectName(string5)) {
            this.m_explainTable.append(string5);
        } else {
            this.m_explainTable.append(DM4JStringUtils.addDoubleQuotes(string5));
        }
        StringBuffer stringBuffer2 = new StringBuffer(ValidationUtil.createNonQuotedCompliantName(string));
        if (stringBuffer2.length() > 17) {
            stringBuffer2.setLength(17);
        }
        stringBuffer2.append(string3);
        String string6 = ValidationUtil.createUniqueTableNameUsingRandom(stringBuffer2.toString(), (Connection)object, "");
        this.m_mappingTable.setLength(0);
        if (ValidationUtil.isValidNonQuotedDBObjectName(string6)) {
            this.m_mappingTable.append(string6);
        } else {
            this.m_mappingTable.append(DM4JStringUtils.addDoubleQuotes(string6));
        }
        this.m_explainComment.setLength(0);
        this.m_mappingComment.setLength(0);
        this.m_createTable = true;
    }

    public DataState getDataState() {
        return (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }

    public boolean getCreateTable() {
        return this.m_createTable;
    }

    public void setCreateTable(boolean bl) {
        if (!this.m_createTable == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_createTable = bl;
        }
    }

    public boolean allowViewGeneration() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return false;
    }
}

