/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.ODMrTextStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.ODMrTextFeatureExtractionSettingsStateError;

public class ODMrTextFeatureExtractionSettingsState
extends WizardStepState {
    private Integer m_maximumTerms;
    private Integer m_maximumDistinctFeatures;
    private boolean m_useThemesAsFeatures;
    private boolean m_useRegularTokensAsFeatures;
    private boolean m_useStemmedTokensAsFeatures;
    private Integer m_memorySize;
    protected ODMrTextStepOptions m_options = null;

    public ODMrTextFeatureExtractionSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof ODMrTextStepOptions) {
            this.m_options = (ODMrTextStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_maximumTerms = this.m_options.getMaximumTerms();
            this.m_maximumDistinctFeatures = this.m_options.getMaximumDistinctFeatures();
            this.m_useThemesAsFeatures = this.m_options.getUseThemesAsFeatures();
            this.m_useRegularTokensAsFeatures = this.m_options.getUseRegularTokensAsFeatures();
            this.m_useStemmedTokensAsFeatures = this.m_options.getUseStemmedTokensAsFeatures();
            this.m_memorySize = this.m_options.getMemorySize();
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateFields(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void validateFields(Vector vector) throws Exception {
        try {
            if (this.m_maximumTerms == null) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_TERMS));
            }
            if (this.m_maximumDistinctFeatures == null) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_FEATURES));
            }
            if (this.m_memorySize == null) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_MEMORY_SIZE));
            }
            if (this.m_maximumTerms != null && this.m_maximumTerms <= 0) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_INVALID_TERMS));
            }
            if (this.m_maximumDistinctFeatures != null && this.m_maximumDistinctFeatures <= 0) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_INVALID_FEATURES));
            }
            if (this.m_memorySize != null && this.m_memorySize <= 0) {
                vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_INVALID_MEMORY_SIZE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(ODMrTextFeatureExtractionSettingsStateError.ODMR_TEXT_SETTINGS_EMPTY_TERMS));
        }
    }

    public void refresh() throws Exception {
    }

    public void load() throws Exception {
        this.loadDefault();
    }

    public void loadDefault() throws Exception {
        if (this.m_options == null) {
            this.m_maximumTerms = new Integer(50);
            this.m_maximumDistinctFeatures = new Integer(3000);
            this.m_useThemesAsFeatures = false;
            this.m_useRegularTokensAsFeatures = true;
            this.m_useStemmedTokensAsFeatures = false;
            this.m_memorySize = new Integer(500);
        }
    }

    public void setMaximumTerms(Integer n) {
        if (this.m_maximumTerms == null || n == null || this.m_maximumTerms.compareTo(n) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_maximumTerms = n;
            if (this.m_options != null) {
                this.m_options.setMaximumTerms(this.m_maximumTerms);
            }
        }
    }

    public Integer getMaximumTerms() {
        return this.m_maximumTerms;
    }

    public void setMaximumDistinctFeatures(Integer n) {
        if (this.m_maximumDistinctFeatures == null || n == null || this.m_maximumDistinctFeatures.compareTo(n) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_maximumDistinctFeatures = n;
            if (this.m_options != null) {
                this.m_options.setMaximumDistinctFeatures(this.m_maximumDistinctFeatures);
            }
        }
    }

    public Integer getMaximumDistinctFeatures() {
        return this.m_maximumDistinctFeatures;
    }

    public void setUseThemesAsFeatures(boolean bl) {
        if (this.m_useThemesAsFeatures != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useThemesAsFeatures = bl;
            if (this.m_options != null) {
                this.m_options.setUseThemesAsFeatures(this.m_useThemesAsFeatures);
            }
        }
    }

    public boolean getUseThemesAsFeatures() {
        return this.m_useThemesAsFeatures;
    }

    public void setUseRegularTokensAsFeatures(boolean bl) {
        if (this.m_useRegularTokensAsFeatures != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useRegularTokensAsFeatures = bl;
            if (this.m_options != null) {
                this.m_options.setUseRegularTokensAsFeatures(this.m_useRegularTokensAsFeatures);
            }
        }
    }

    public boolean getUseRegularTokensAsFeatures() {
        return this.m_useRegularTokensAsFeatures;
    }

    public void setUseStemmedTokensAsFeatures(boolean bl) {
        if (this.m_useStemmedTokensAsFeatures != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useStemmedTokensAsFeatures = bl;
            if (this.m_options != null) {
                this.m_options.setUseStemmedTokensAsFeatures(this.m_useStemmedTokensAsFeatures);
            }
        }
    }

    public boolean getUseStemmedTokensAsFeatures() {
        return this.m_useStemmedTokensAsFeatures;
    }

    public void setMemorySize(Integer n) {
        if (this.m_memorySize == null || n == null || this.m_memorySize.compareTo(n) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_memorySize = n;
            if (this.m_options != null) {
                this.m_options.setMemorySize(this.m_memorySize);
            }
        }
    }

    public Integer getMemorySize() {
        return this.m_memorySize;
    }

    public boolean postValidate(Vector vector) throws Exception {
        return true;
    }
}

