/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.Vector;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DBDataSource;
import oracle.dmt.dm4j.datasources.NormalizeScheme;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.NormalizeSchemeStat;

public class NormalizeState {
    String m_schemaName = null;
    String m_tableName = null;
    String m_attributeNameMapping = null;
    String m_valueNameMapping = null;
    boolean m_isTransaction = true;
    boolean m_bSingleMetric = false;
    String m_attrib = null;
    NormalizeScheme m_scheme = null;
    private boolean m_isNormalized = false;
    private boolean m_save = false;
    protected PreviewDataSource m_ds = null;
    protected int m_schemeType;
    protected float m_arg1;
    protected float m_arg2;
    protected float m_newKurtosis;
    protected float m_newSkewness;
    protected float m_newMean;
    protected float m_newStd;
    protected float m_newMin;
    protected float m_newMax;
    protected ComplexDataStructure m_sampledCDS;

    public NormalizeState(String string, String string2, String string3, String string4, boolean bl, String string5, NormalizeScheme normalizeScheme, boolean bl2) throws Exception {
        this.m_schemaName = string;
        this.m_tableName = string2;
        this.m_attrib = string5;
        this.m_scheme = normalizeScheme;
        this.m_isNormalized = bl2;
        this.m_attributeNameMapping = string3;
        this.m_valueNameMapping = string4;
        this.m_isTransaction = string3 != null && string4 != null;
        this.m_bSingleMetric = bl;
        this.loadDefaults();
    }

    public NormalizeState(ComplexDataStructure complexDataStructure, String string, String string2, String string3, NormalizeScheme normalizeScheme, boolean bl) throws Exception {
        this.m_sampledCDS = complexDataStructure;
        this.m_schemaName = complexDataStructure.getCaseSchema();
        this.m_tableName = complexDataStructure.getCaseTable();
        this.m_attrib = string3;
        this.m_scheme = normalizeScheme;
        this.m_isNormalized = bl;
        this.m_attributeNameMapping = string;
        this.m_valueNameMapping = string2;
        this.m_isTransaction = string != null && string2 != null;
        this.loadDefaults();
    }

    public NormalizeState(String string, String string2, String string3, NormalizeScheme normalizeScheme, boolean bl) throws Exception {
        this(string, string2, null, null, false, string3, normalizeScheme, bl);
    }

    public NormalizeState(ComplexDataStructure complexDataStructure, String string, NormalizeScheme normalizeScheme, boolean bl) throws Exception {
        this(complexDataStructure, null, null, string, normalizeScheme, bl);
    }

    public void validate(Vector vector) throws Exception {
    }

    public boolean isNormalized() {
        return this.m_isNormalized;
    }

    public boolean isTransactional() {
        return this.m_isTransaction;
    }

    public PreviewDataSource getModel() {
        return this.m_ds;
    }

    public NormalizeScheme getScheme() {
        return this.m_scheme;
    }

    public String getSchema() {
        return this.m_schemaName;
    }

    public String getTable() {
        return this.m_tableName;
    }

    public String getAttribute() {
        return this.m_attrib;
    }

    public int getSchemeType() {
        return this.m_schemeType;
    }

    public float getArg1() {
        return this.m_arg1;
    }

    public float getArg2() {
        return this.m_arg2;
    }

    public float getNewKurtosis() {
        return this.m_newKurtosis;
    }

    public float getNewSkewness() {
        return this.m_newSkewness;
    }

    public float getNewMean() {
        return this.m_newMean;
    }

    public float getNewStd() {
        return this.m_newStd;
    }

    public float getNewMin() {
        return this.m_newMin;
    }

    public float getNewMax() {
        return this.m_newMax;
    }

    private float getDefaultArg1(int n) {
        float f = 0.0f;
        if (n == 7) {
            f = 1.0f;
        } else if (n == 8) {
            f = 0.0f;
        }
        return f;
    }

    private float getDefaultArg2(int n) {
        float f = 0.0f;
        if (n == 7) {
            f = 0.0f;
        } else if (n == 8) {
            f = 1.0f;
        }
        return f;
    }

    public float getArg1(int n) {
        return this.m_arg1 > 0.0f ? this.m_arg1 : this.getDefaultArg1(n);
    }

    public float getArg2(int n) {
        return this.m_arg2 > 0.0f ? this.m_arg2 : this.getDefaultArg2(n);
    }

    /*
     * Loose catch block
     */
    public PreviewDataSource getPreviewData(int n, float f, float f2) throws Exception {
        block17: {
            Connection connection;
            block16: {
                block14: {
                    connection = null;
                    if (this.m_ds == null || this.m_schemeType != n || this.m_arg1 != f || this.m_arg2 != f2) break block14;
                    PreviewDataSource previewDataSource = this.m_ds;
                    Object var7_8 = null;
                    try {
                        if (connection != null) {
                            connection.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return previewDataSource;
                }
                connection = DM4JConnectionManager.getDbConnection();
                this.m_ds = new PreviewDataSource(connection, n, f, f2);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), this.m_ds, true);
                this.m_ds.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), "");
                if (this.m_ds.getException() != null) {
                    throw this.m_ds.getException();
                }
                if (progressBar.hasUserCancelled()) {
                    this.m_ds = null;
                    break block16;
                }
                this.m_schemeType = n;
                this.m_arg1 = f;
                this.m_arg2 = f2;
            }
            Object var7_9 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block17;
            }
            catch (Exception exception) {}
            break block17;
            {
                catch (Exception exception) {
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return this.m_ds;
    }

    public void setSave(boolean bl) {
        this.m_save = bl;
    }

    public boolean getSave() {
        return this.m_save;
    }

    protected void loadDefaults() throws Exception {
        this.getPreviewData(this.m_scheme.getType(), this.m_scheme.getArg1(), this.m_scheme.getArg2());
    }

    public class PreviewDataSource
    extends DBDataSource {
        protected final int COLUMN_COUNT = 3;
        protected final String NAME_COLUMN;
        protected final String ORG_VALUE_COLUMN;
        protected final String NEW_VALUE_COLUMN;
        protected final int NAME_IDX = 0;
        public final int ORG_VALUE_IDX = 1;
        public final int NEW_VALUE_IDX = 2;
        protected int m_schemeType;
        protected float m_arg1;
        protected float m_arg2;

        public PreviewDataSource(Connection connection, int n, float f, float f2) {
            super(connection);
            this.COLUMN_COUNT = 3;
            this.NAME_COLUMN = ResourceUtilities.getUILabel("NORMALIZE_SCHEME_STATISTICS");
            this.ORG_VALUE_COLUMN = ResourceUtilities.getUILabel("NORMALIZE_SCHEME_ORG_VALUES");
            this.NEW_VALUE_COLUMN = ResourceUtilities.getUILabel("NORMALIZE_SCHEME_NEW_VALUES");
            this.NAME_IDX = 0;
            this.ORG_VALUE_IDX = 1;
            this.NEW_VALUE_IDX = 2;
            this.m_schemeType = n;
            this.m_arg1 = f;
            this.m_arg2 = f2;
        }

        protected NormalizeSchemeStat getNormalizeSchemeStat(NormalizeScheme normalizeScheme) throws Exception {
            NormalizeSchemeStat normalizeSchemeStat = null;
            normalizeSchemeStat = NormalizeState.this.m_isTransaction ? new NormalizeSchemeStat(this.m_conn, NormalizeState.this.m_schemaName, NormalizeState.this.m_tableName, NormalizeState.this.m_attributeNameMapping, NormalizeState.this.m_valueNameMapping, NormalizeState.this.m_bSingleMetric, NormalizeState.this.m_attrib, normalizeScheme) : new NormalizeSchemeStat(this.m_conn, NormalizeState.this.m_schemaName, NormalizeState.this.m_tableName, NormalizeState.this.m_attrib, normalizeScheme);
            return normalizeSchemeStat;
        }

        protected void createData() throws Exception {
            if (NormalizeState.this.m_isNormalized) {
                this.addRows(0, 4);
                this.setData(0, 0, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_AVG_VALUE"));
                this.setData(1, 0, new Float(NormalizeState.this.m_scheme.getOrgMean()));
                this.setData(0, 1, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_STD_VALUE"));
                this.setData(1, 1, new Float(NormalizeState.this.m_scheme.getOrgStd()));
                this.setData(0, 2, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_MIN_VALUE"));
                this.setData(1, 2, new Float(NormalizeState.this.m_scheme.getOrgMin()));
                this.setData(0, 3, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_MAX_VALUE"));
                this.setData(1, 3, new Float(NormalizeState.this.m_scheme.getOrgMax()));
            } else {
                this.addRows(0, 6);
                this.setData(0, 0, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_KURT_VALUE"));
                this.setData(1, 0, new Float(NormalizeState.this.m_scheme.getOrgKurtosis()));
                this.setData(0, 1, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SKEW_VALUE"));
                this.setData(1, 1, new Float(NormalizeState.this.m_scheme.getOrgSkewness()));
                this.setData(0, 2, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_AVG_VALUE"));
                this.setData(1, 2, new Float(NormalizeState.this.m_scheme.getOrgMean()));
                this.setData(0, 3, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_STD_VALUE"));
                this.setData(1, 3, new Float(NormalizeState.this.m_scheme.getOrgStd()));
                this.setData(0, 4, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_MIN_VALUE"));
                this.setData(1, 4, new Float(NormalizeState.this.m_scheme.getOrgMin()));
                this.setData(0, 5, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_MAX_VALUE"));
                this.setData(1, 5, new Float(NormalizeState.this.m_scheme.getOrgMax()));
            }
            NormalizeScheme normalizeScheme = new NormalizeScheme();
            normalizeScheme.setScheme(this.m_schemeType, this.m_arg1, this.m_arg2);
            normalizeScheme.setOrgStats(NormalizeState.this.m_scheme.getOrgKurtosis(), NormalizeState.this.m_scheme.getOrgSkewness(), NormalizeState.this.m_scheme.getOrgMean(), NormalizeState.this.m_scheme.getOrgStd(), NormalizeState.this.m_scheme.getOrgMin(), NormalizeState.this.m_scheme.getOrgMax());
            normalizeScheme.setComplexAttributeInfo(NormalizeState.this.m_scheme.getComplexAttributeInfo());
            NormalizeSchemeStat normalizeSchemeStat = this.getNormalizeSchemeStat(normalizeScheme);
            normalizeScheme = normalizeSchemeStat.getStat();
            if (NormalizeState.this.m_isNormalized) {
                this.setData(2, 0, new Float(normalizeScheme.getNewMean()));
                this.setData(2, 1, new Float(normalizeScheme.getNewStd()));
                this.setData(2, 2, new Float(normalizeScheme.getNewMin()));
                this.setData(2, 3, new Float(normalizeScheme.getNewMax()));
            } else {
                this.setData(2, 0, new Float(normalizeScheme.getNewKurtosis()));
                this.setData(2, 1, new Float(normalizeScheme.getNewSkewness()));
                this.setData(2, 2, new Float(normalizeScheme.getNewMean()));
                this.setData(2, 3, new Float(normalizeScheme.getNewStd()));
                this.setData(2, 4, new Float(normalizeScheme.getNewMin()));
                this.setData(2, 5, new Float(normalizeScheme.getNewMax()));
            }
            NormalizeState.this.m_newKurtosis = normalizeScheme.getNewKurtosis();
            NormalizeState.this.m_newSkewness = normalizeScheme.getNewSkewness();
            NormalizeState.this.m_newMean = normalizeScheme.getNewMean();
            NormalizeState.this.m_newStd = normalizeScheme.getNewStd();
            NormalizeState.this.m_newMin = normalizeScheme.getNewMin();
            NormalizeState.this.m_newMax = normalizeScheme.getNewMax();
        }

        protected ArrayOneDModel createColumns() throws Exception {
            this.addColumns(0, 3);
            Object[] objectArray = new String[]{this.NAME_COLUMN, this.ORG_VALUE_COLUMN, this.NEW_VALUE_COLUMN};
            return new ArrayOneDModel(objectArray);
        }
    }
}

