/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.ewt.event.Cancelable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.steps.NormalizeStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CDSNormalizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeScheme;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CDSNormalizeSchemeStat;
import oracle.dmt.dm4j.wizard.state.transformsteps.NormalizeDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.NormalizeSchemeStat;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class NormalizeSettingsState
extends WizardStepState {
    private NormalizeScheme m_copyScheme = null;
    protected NormalizeStepOptions m_options = null;

    public NormalizeSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof NormalizeStepOptions) {
            this.m_options = (NormalizeStepOptions)browserContext.getOptions();
        }
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
    }

    public void load() throws Exception {
        this.loadDefault();
    }

    public void loadDefault() {
        try {
            BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
            if (browserContext.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
                NormalizeDataState normalizeDataState = (NormalizeDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
                NormalizeDataSource normalizeDataSource = normalizeDataState.getModel();
                int n = normalizeDataSource.getRowCount();
                for (int i = 0; i < n; ++i) {
                    NormalizeScheme normalizeScheme = new NormalizeScheme();
                    float f = ((Float)normalizeDataSource.getData(2, i)).floatValue();
                    float f2 = ((Float)normalizeDataSource.getData(1, i)).floatValue();
                    float f3 = ((Float)normalizeDataSource.getData(3, i)).floatValue();
                    float f4 = ((Float)normalizeDataSource.getData(4, i)).floatValue();
                    float f5 = ((Float)normalizeDataSource.getData(5, i)).floatValue();
                    float f6 = ((Float)normalizeDataSource.getData(6, i)).floatValue();
                    String string = normalizeDataSource.getComplexAttribute(i);
                    normalizeScheme.setComplexAttributeInfo(string);
                    normalizeScheme.setOrgStats(f, f2, f3, f4, f5, f6);
                    normalizeScheme.setNewStats(f, f2, f3, f4, f5, f6);
                    if (this.m_options == null) {
                        normalizeScheme.setScheme(8, 0.0f, 1.0f);
                        normalizeDataSource.setScheme(i, normalizeScheme);
                        continue;
                    }
                    Boolean bl = normalizeDataSource.getSparsityAttribute(i);
                    if (bl.booleanValue()) {
                        if (this.m_options.isLinScaleScheme()) {
                            normalizeScheme.setScheme(10, 0.0f, 0.0f);
                        }
                    } else if (this.m_options.isMinMaxScheme()) {
                        normalizeScheme.setScheme(8, this.m_options.getMinValue(), this.m_options.getMaxValue());
                    } else {
                        normalizeScheme.setScheme(9, 0.0f, 0.0f);
                    }
                    normalizeDataSource.setScheme(i, normalizeScheme);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public NormalizeDataSource getModel() {
        NormalizeDataState normalizeDataState = (NormalizeDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return normalizeDataState.getModel();
    }

    public NormalizeScheme getScheme(int n) {
        NormalizeDataState normalizeDataState = (NormalizeDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        NormalizeDataSource normalizeDataSource = normalizeDataState.getModel();
        return normalizeDataSource.getScheme(n);
    }

    public void clearScheme(int n) {
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(new Integer(n));
        this.clearSchemes(vector);
    }

    public void clearSchemes(Vector vector) {
        NormalizeDataState normalizeDataState = (NormalizeDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        NormalizeDataSource normalizeDataSource = normalizeDataState.getModel();
        normalizeDataSource.clearSchemes(vector);
    }

    public void setScheme(int n, NormalizeScheme normalizeScheme) {
        NormalizeDataState normalizeDataState = (NormalizeDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        NormalizeDataSource normalizeDataSource = normalizeDataState.getModel();
        normalizeDataSource.setScheme(n, normalizeScheme);
        if (this.m_options != null) {
            if (normalizeScheme.getType() == 8) {
                this.m_options.setMinMaxScheme(true);
            } else if (normalizeScheme.getType() == 9) {
                this.m_options.setMinMaxScheme(false);
            }
            this.m_options.setMinValue(normalizeScheme.getArg1());
            this.m_options.setMaxValue(normalizeScheme.getArg2());
        }
    }

    public void setCopyScheme(NormalizeScheme normalizeScheme) {
        this.m_copyScheme = normalizeScheme;
    }

    public NormalizeScheme getCopyScheme() {
        return this.m_copyScheme;
    }

    /*
     * Loose catch block
     */
    public ArrayList copySchemes(Vector vector) throws Exception {
        Serializable serializable2222;
        Object object;
        CopySchemeStat copySchemeStat;
        boolean bl;
        block13: {
            Connection connection;
            block12: {
                connection = null;
                bl = false;
                copySchemeStat = null;
                connection = DM4JConnectionManager.getDbConnection();
                copySchemeStat = new CopySchemeStat(connection, vector);
                object = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), copySchemeStat, true);
                copySchemeStat.setProgressBar((ProgressBar)object);
                ((ProgressBar)object).start(ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), "");
                if (vector.size() == 1 && copySchemeStat.getException() != null) {
                    throw copySchemeStat.getException();
                }
                if (!((ProgressBar)object).hasUserCancelled()) break block12;
                bl = true;
            }
            Object var7_7 = null;
            try {
                if (connection != null) {
                    connection.close();
                }
                break block13;
            }
            catch (Exception serializable2222) {
                ((Throwable)serializable2222).printStackTrace();
            }
            break block13;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw exception;
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                try {
                    if (connection != null) {
                        connection.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                throw throwable;
            }
        }
        if (bl) {
            return null;
        }
        object = copySchemeStat.getCopiedIndexes();
        ArrayList arrayList = copySchemeStat.getCopiedSchemes();
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            serializable2222 = (Integer)((ArrayList)object).get(i);
            int n = (Integer)serializable2222;
            this.setScheme(n, (NormalizeScheme)arrayList.get(i));
        }
        return object;
    }

    class CopySchemeStat
    implements Runnable,
    Cancelable {
        private Connection m_conn;
        private ProgressBar m_progressBar = null;
        private Exception m_exception = null;
        private boolean m_canceled = false;
        private Vector m_selectedIndexes = null;
        private ArrayList m_copiedIndexes = null;
        private ArrayList m_copiedSchemes = null;

        public CopySchemeStat(Connection connection, Vector vector) {
            this.m_conn = connection;
            this.m_selectedIndexes = vector;
        }

        public void setProgressBar(ProgressBar progressBar) {
            this.m_progressBar = progressBar;
        }

        protected void setException(Exception exception) {
            this.m_exception = exception;
        }

        protected ProgressBar getProgressBar() {
            return this.m_progressBar;
        }

        public Exception getException() {
            return this.m_exception;
        }

        public ArrayList getCopiedIndexes() {
            return this.m_copiedIndexes;
        }

        public ArrayList getCopiedSchemes() {
            return this.m_copiedSchemes;
        }

        public void run() {
            try {
                NormalizeDataState normalizeDataState = (NormalizeDataState)NormalizeSettingsState.this.getparentWizardState().getStep(StepType.DATA_STEP);
                Enumeration enumeration = this.m_selectedIndexes.elements();
                this.m_copiedIndexes = new ArrayList();
                this.m_copiedSchemes = new ArrayList();
                while (enumeration.hasMoreElements()) {
                    Integer n = (Integer)enumeration.nextElement();
                    int n2 = n;
                    NormalizeScheme normalizeScheme = NormalizeSettingsState.this.getScheme(n2);
                    NormalizeDataSource normalizeDataSource = normalizeDataState.getModel();
                    String string = (String)normalizeDataSource.getData(0, n2);
                    if (normalizeScheme == null) {
                        normalizeScheme = new NormalizeScheme();
                        float f = ((Float)normalizeDataSource.getData(2, n2)).floatValue();
                        float f2 = ((Float)normalizeDataSource.getData(1, n2)).floatValue();
                        float f3 = ((Float)normalizeDataSource.getData(3, n2)).floatValue();
                        float f4 = ((Float)normalizeDataSource.getData(4, n2)).floatValue();
                        float f5 = ((Float)normalizeDataSource.getData(5, n2)).floatValue();
                        float f6 = ((Float)normalizeDataSource.getData(6, n2)).floatValue();
                        String string2 = normalizeDataSource.getComplexAttribute(n2);
                        normalizeScheme.setComplexAttributeInfo(string2);
                        normalizeScheme.setOrgStats(f, f2, f3, f4, f5, f6);
                        normalizeScheme.setNewStats(f, f2, f3, f4, f5, f6);
                    }
                    normalizeScheme.setScheme(NormalizeSettingsState.this.m_copyScheme.getType(), NormalizeSettingsState.this.m_copyScheme.getArg1(), NormalizeSettingsState.this.m_copyScheme.getArg2());
                    NormalizeSchemeStat normalizeSchemeStat = null;
                    if (normalizeDataState.isMultipleRecordCaseFormat()) {
                        normalizeSchemeStat = new NormalizeSchemeStat(this.m_conn, normalizeDataState.getSelectedSchemaName(), normalizeDataState.getSelectedTableName(), normalizeDataState.getAttributeNameMapping(), normalizeDataState.getValueMapping(), normalizeDataState.isSingleMetric(), string, normalizeScheme);
                    } else if (normalizeDataSource instanceof CDSNormalizeDataSource) {
                        CDSNormalizeDataSource cDSNormalizeDataSource = (CDSNormalizeDataSource)normalizeDataSource;
                        normalizeSchemeStat = new CDSNormalizeSchemeStat(this.m_conn, cDSNormalizeDataSource.getSampledInputCDS(), string, normalizeScheme);
                    } else {
                        normalizeSchemeStat = new NormalizeSchemeStat(this.m_conn, normalizeDataState.getSelectedSchemaName(), normalizeDataState.getSelectedTableName(), string, normalizeScheme);
                    }
                    try {
                        normalizeScheme = normalizeSchemeStat.getStat();
                        this.m_copiedSchemes.add(normalizeScheme);
                        this.m_copiedIndexes.add(n);
                    }
                    catch (Exception exception) {
                        this.setException(exception);
                    }
                }
                this.getProgressBar().setDoneStatus();
            }
            catch (Exception exception) {
                this.setException(exception);
                this.getProgressBar().setDoneStatus();
            }
        }

        public boolean isCancelled() {
            return this.m_canceled;
        }

        public void cancel() {
            this.m_canceled = true;
        }
    }
}

