/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;

public class HistogramRangesTableModel
extends AbstractTableModel {
    private List m_fieldEntries = Collections.synchronizedList(new ArrayList(0));
    private static String[] columns = new String[]{ResourceUtilities.getUILabel("HISTOGRAM_X_NUMBER"), ResourceUtilities.getUILabel("HISTOGRAM_RANGE_VALUE"), ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE"), ResourceUtilities.getUILabel("HISTOGRAM_PERCENT_OF_TOTAL")};

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isColumnEditable(int n) {
        return false;
    }

    public void addEntry(Object[] objectArray) {
        this.m_fieldEntries.add(objectArray);
        this.fireTableDataChanged();
    }

    public void addEntry(int n, Object[] objectArray) {
        this.m_fieldEntries.add(n, objectArray);
        this.fireTableDataChanged();
    }

    public void deleteEntry(int n) {
        this.m_fieldEntries.remove(n);
        this.fireTableRowsDeleted(n, n);
    }

    public void deleteAllEntries() {
        int n = this.getRowCount();
        if (n == 0) {
            return;
        }
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = i;
        }
        this.deleteEntries(nArray);
    }

    public void deleteEntries(int[] nArray) {
        int n;
        boolean bl = true;
        for (n = 0; n < nArray.length; ++n) {
            if (n >= nArray.length - 1 || nArray[n] + 1 == nArray[n + 1]) continue;
            bl = false;
            break;
        }
        for (n = nArray.length - 1; n >= 0; --n) {
            this.m_fieldEntries.remove(nArray[n]);
        }
        if (bl) {
            this.fireTableRowsDeleted(nArray[0], nArray[nArray.length - 1]);
        } else {
            this.fireTableDataChanged();
        }
    }

    public Object getValueAt(int n, int n2) {
        Object[] objectArray = (Object[])this.m_fieldEntries.get(n);
        Object object = objectArray[n2];
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return object;
    }

    public Class getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 2: {
                clazz = Integer.class;
                break;
            }
            case 3: {
                clazz = Double.class;
                break;
            }
            default: {
                clazz = Object.class;
            }
        }
        return clazz;
    }

    public void setValueAt(Object object, int n, int n2) {
        Object[] objectArray = (Object[])this.m_fieldEntries.get(n);
        objectArray[n2] = object.toString();
        this.fireTableCellUpdated(n, n2);
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getRowCount() {
        return this.m_fieldEntries.size();
    }

    public Object[] getFieldEntry(int n) {
        return (Object[])this.m_fieldEntries.get(n);
    }

    public void setFieldEntryAt(int n, Object[] objectArray) {
        this.m_fieldEntries.set(n, objectArray);
        this.fireTableDataChanged();
    }
}

