/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.FilterXnlSettingsStateError;

public class FilterXnlSettingsState
extends WizardStepState {
    private Double m_maxByMinVal = new Double(0.0);
    private Double m_maxMinusMinVal = new Double(0.0);
    private boolean m_isApplyNot = false;
    private boolean m_isMaxByMin = true;
    private boolean m_isMaxMinusMin = true;
    private String m_maxByMinCondition = null;
    private String m_maxMinusMinCondition = null;

    public FilterXnlSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        if (this.m_isMaxMinusMin) {
            this.validateMaxMinusMinVal(vector);
        }
        if (this.m_isMaxByMin) {
            this.validateMaxByMinVal(vector);
        }
        if (!this.m_isMaxMinusMin && !this.m_isMaxByMin) {
            String string = ResourceUtilities.getstateExceptionMessage("FILTER_XNL_NO_CRITERIA");
            String[] stringArray = null;
            vector.add(new StateValidation(FilterXnlSettingsStateError.FILTER_XNL_NO_CRITERIA, string, stringArray));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
    }

    public void setFilterXnlMaxByMin(Double d) {
        if (this.m_maxByMinVal == null || d == null || this.m_maxByMinVal.compareTo(d) != 0) {
            this.m_maxByMinVal = d;
            this.setState(StepStateType.LOADED);
        }
    }

    public void setFilterXnlMaxMinusMin(Double d) {
        if (this.m_maxMinusMinVal == null || d == null || this.m_maxMinusMinVal.compareTo(d) != 0) {
            this.m_maxMinusMinVal = d;
            this.setState(StepStateType.LOADED);
        }
    }

    public void setFilterXnlMaxByMinCondition(String string) {
        this.m_maxByMinCondition = string;
        this.setState(StepStateType.LOADED);
    }

    public void setFilterXnlMaxMinusMinCondition(String string) {
        this.m_maxMinusMinCondition = string;
        this.setState(StepStateType.LOADED);
    }

    public void setIsMaxByMin(boolean bl) {
        this.m_isMaxByMin = bl;
        this.setState(StepStateType.LOADED);
    }

    public void setIsMaxMinusMin(boolean bl) {
        this.m_isMaxMinusMin = bl;
        this.setState(StepStateType.LOADED);
    }

    public void setIsApplyNot(boolean bl) {
        this.m_isApplyNot = bl;
        this.setState(StepStateType.LOADED);
    }

    public Double getFilterXnlMaxByMin() {
        return this.m_maxByMinVal;
    }

    public Double getFilterXnlMaxMinusMin() {
        return this.m_maxMinusMinVal;
    }

    public boolean getIsMaxByMin() {
        return this.m_isMaxByMin;
    }

    public boolean getIsMaxMinusMin() {
        return this.m_isMaxMinusMin;
    }

    public boolean getIsApplyNot() {
        return this.m_isApplyNot;
    }

    public String getFilterXnlMaxByMinCondition() {
        return this.m_maxByMinCondition;
    }

    public String getFilterXnlMaxMinusMinCondition() {
        return this.m_maxMinusMinCondition;
    }

    private void loadDefaults() {
        this.m_maxByMinVal = new Double(0.0);
        this.m_maxMinusMinVal = new Double(0.0);
        this.m_isApplyNot = false;
        this.m_isMaxByMin = true;
        this.m_isMaxMinusMin = true;
    }

    public MultiRecordCaseData getDataState() {
        return (MultiRecordCaseData)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }

    protected void validateMaxMinusMinVal(Vector vector) throws Exception {
        if (this.m_maxMinusMinVal == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("FILTER_XNL_SETTINGS_MAXMINUSMIN_LBL")};
            vector.add(new StateValidation(FilterXnlSettingsStateError.REQUIRED_FIELD, string, stringArray));
        }
    }

    protected void validateMaxByMinVal(Vector vector) throws Exception {
        if (this.m_maxByMinVal == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("FILTER_XNL_SETTINGS_MAXBYMIN_LBL")};
            vector.add(new StateValidation(FilterXnlSettingsStateError.REQUIRED_FIELD, string, stringArray));
        }
    }
}

