/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportAdvanceState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.FileImportSettingsStateError;

public class FileImportSettingsState
extends WizardStepState {
    static int END_OF_FILE = -1;
    static int RETURN = 10;
    static int CONTROL_M = 13;
    static final String g_field_delimiter = "TRANSFORMFILEIMPORTFIELDDELIMITER";
    static final String g_field_enclosure = "TRANSFORMFILEIMPORTFIELDENCLOSURE";
    static final String g_header_record = "TRANSFORMFILEIMPORTHEADERRECORD";
    private String m_fieldDelimiter = "";
    private String m_enclosure = "";
    private boolean m_hasColumnHeader = true;
    private boolean m_hasControlM = false;
    FileImportAdvanceState m_advanceState;

    public FileImportSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        this.validateFile(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateEnclosure(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateRowsToScan(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void validateEnclosure(Vector vector) throws Exception {
        try {
            File file;
            OpenFileState openFileState = (OpenFileState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            FileImportSettingsState fileImportSettingsState = (FileImportSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP);
            String string = fileImportSettingsState.getEnclosure();
            if (string.length() > 0 && (file = openFileState.getFile()) != null) {
                String string2;
                FileReader fileReader = new FileReader(file);
                BufferedReader bufferedReader = new BufferedReader(fileReader);
                if (fileImportSettingsState.getHasColumnHeader()) {
                    bufferedReader.readLine();
                }
                if (!(string2 = bufferedReader.readLine().substring(0, 1)).equalsIgnoreCase(string)) {
                    vector.add(new StateValidation(FileImportSettingsStateError.FILEIMPORT_INVALID_ENCLOSURE));
                }
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(FileImportSettingsStateError.FILEIMPORT_INVALID_ENCLOSURE));
        }
    }

    protected void validateRowsToScan(Vector vector) throws Exception {
        int n = this.getFileImportAdvanceState().getRowsToScan();
        if (n < 1) {
            vector.add(new StateValidation(FileImportSettingsStateError.FILEIMPORT_INVALID_ROWS_TO_SCAN));
        }
    }

    protected void validateFile(Vector vector) throws Exception {
        try {
            OpenFileState openFileState = (OpenFileState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            FileImportSettingsState fileImportSettingsState = (FileImportSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP);
            boolean bl = fileImportSettingsState.getHasColumnHeader();
            File file = openFileState.getFile();
            if (file != null) {
                String string = fileImportSettingsState.getFieldDelimiter();
                String string2 = fileImportSettingsState.getEnclosure();
                FileReader fileReader = new FileReader(file);
                int n = fileReader.read();
                this.m_hasControlM = false;
                while (n != END_OF_FILE) {
                    if (n == CONTROL_M) {
                        this.m_hasControlM = true;
                        n = END_OF_FILE;
                        continue;
                    }
                    if (n == RETURN) {
                        n = END_OF_FILE;
                        continue;
                    }
                    n = fileReader.read();
                }
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(FileImportSettingsStateError.FILEIMPORT_INVALID_CONTROL_M));
        }
    }

    public void refresh() throws Exception {
    }

    public void load() throws Exception {
        this.loadDefaults();
        this.m_advanceState = new FileImportAdvanceState(this);
    }

    protected void loadDefaults() {
        this.m_fieldDelimiter = ",";
        this.m_enclosure = "";
        this.m_hasColumnHeader = true;
        try {
            UserPreferences userPreferences = UserPreferences.getInstance();
            if (userPreferences.isKeyThere(g_field_delimiter)) {
                this.m_fieldDelimiter = userPreferences.getStringValue(g_field_delimiter);
            }
            if (userPreferences.isKeyThere(g_field_enclosure)) {
                this.m_enclosure = userPreferences.getStringValue(g_field_enclosure);
            }
            if (userPreferences.isKeyThere(g_header_record)) {
                this.m_hasColumnHeader = userPreferences.getBooleanValue(g_header_record);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFieldDelimiter(String string) {
        this.m_fieldDelimiter = string;
        try {
            UserPreferences userPreferences = UserPreferences.getInstance();
            userPreferences.setStringValue(g_field_delimiter, this.m_fieldDelimiter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getFieldDelimiter() {
        return this.m_fieldDelimiter;
    }

    public void setEnclosure(String string) {
        this.m_enclosure = string;
        try {
            UserPreferences userPreferences = UserPreferences.getInstance();
            userPreferences.setStringValue(g_field_enclosure, this.m_enclosure);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getEnclosure() {
        return this.m_enclosure;
    }

    public void setHasColumnHeader(boolean bl) {
        this.m_hasColumnHeader = bl;
        try {
            UserPreferences userPreferences = UserPreferences.getInstance();
            userPreferences.setBooleanValue(g_header_record, this.m_hasColumnHeader);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean getHasColumnHeader() {
        return this.m_hasColumnHeader;
    }

    public boolean getHasControlM() {
        return this.m_hasControlM;
    }

    public void setFileImportAdvanceState(FileImportAdvanceState fileImportAdvanceState) {
        this.m_advanceState = fileImportAdvanceState;
    }

    public FileImportAdvanceState getFileImportAdvanceState() {
        return this.m_advanceState;
    }
}

