/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.datasources.AllDBColumnsDataSource;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CreateContextIndexDataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.CreateContextIndexStateError;

public class CreateContextIndexColumnState
extends WizardStepState {
    StringBuffer m_selectedAttribute = new StringBuffer();

    public CreateContextIndexColumnState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void load() throws Exception {
        this.m_selectedAttribute = new StringBuffer();
    }

    public AllDBColumnsDataSource getColumnsDataSource() {
        CreateContextIndexDataState createContextIndexDataState = (CreateContextIndexDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return createContextIndexDataState.getModel();
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void validate(Vector vector) throws Exception {
        this.validateSelectedAttribute(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    protected void validateSelectedAttribute(Vector vector) throws Exception {
        if (this.m_selectedAttribute.length() == 0) {
            vector.add(new StateValidation(CreateContextIndexStateError.CREATE_TEXT_INDEX_NO_ATTRIBUTE_SELECTED));
            return;
        }
        CreateContextIndexDataState createContextIndexDataState = (CreateContextIndexDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        if (!createContextIndexDataState.isNewTableRequired() && ValidationUtil.doesColumnHaveContextIndex(this.getparentWizardState().getConnection(), createContextIndexDataState.getSelectedTableName(), createContextIndexDataState.getSelectedSchemaName(), this.getSelectedAttribute())) {
            vector.add(new StateValidation(CreateContextIndexStateError.CREATE_TEXT_INDEX_INDEX_ALREADY_PRESENT));
        }
    }

    public String getSelectedAttribute() {
        return this.m_selectedAttribute.toString();
    }

    public void setSelectedAttribute(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_selectedAttribute.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_selectedAttribute = new StringBuffer(string);
        }
    }
}

