/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;

public class CodeGenWarningsTableModel
extends AbstractTableModel {
    private ArrayList m_rows;
    private WizardStepState m_parentState;
    private static int START = 0;
    public static final int CG_ACTIVITY_ICON_COLUMN = START++;
    public static final int CG_ACTIVITY_NAME_COLUMN = START++;
    public static final int CG_ACTIVITY_TYPE_COLUMN = START++;
    private static int LAST_COL = START;
    private Vector m_vaidatedActivities = new Vector();
    private static String[] columns = new String[LAST_COL];
    public static String OK_ICON;
    public static String WARNING_ICON;
    public static String ERROR_ICON;

    public CodeGenWarningsTableModel(WizardStepState wizardStepState) {
        this.m_parentState = wizardStepState;
    }

    public WizardStepState getParentState() {
        return this.m_parentState;
    }

    public int getColumnAlignment(int n) {
        return 2;
    }

    public Comparator getColumnSortComparator(int n) {
        return null;
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getRowCount() {
        return this.m_rows != null ? this.m_rows.size() : 0;
    }

    public Class getColumnClass(int n) {
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.m_rows.get(n);
        if (arrayList == null) {
            return null;
        }
        Object e = arrayList.get(n2);
        return e;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void load(HashMap hashMap, Vector vector) throws Exception {
        if (this.m_rows != null && !this.m_rows.isEmpty()) {
            this.m_rows.clear();
        }
        if (!this.m_vaidatedActivities.isEmpty()) {
            this.m_vaidatedActivities.clear();
        }
        this.m_rows = new ArrayList(vector.size());
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            Hashtable hashtable = (Hashtable)vector.elementAt(i);
            String string = (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_NAME_COLUMN));
            String string2 = (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_TYPE_COLUMN));
            String string3 = ActivityType.getActivityGroupType(ActivityType.getInstance(string2));
            Vector vector2 = (Vector)hashMap.get(string);
            String string4 = null;
            if (vector2 == null || vector2.isEmpty()) {
                string4 = OK_ICON;
                this.m_vaidatedActivities.add(vector.elementAt(i));
            } else {
                for (int j = 0; j < vector2.size(); ++j) {
                    StateValidation stateValidation = (StateValidation)vector2.elementAt(j);
                    if (!"ERROR".equals(stateValidation.getValidationType())) continue;
                    string4 = ERROR_ICON;
                }
                if (string4 == null) {
                    string4 = WARNING_ICON;
                }
            }
            ArrayList<String> arrayList = new ArrayList<String>(LAST_COL);
            arrayList.add(CG_ACTIVITY_ICON_COLUMN, string4);
            arrayList.add(CG_ACTIVITY_NAME_COLUMN, string);
            arrayList.add(CG_ACTIVITY_TYPE_COLUMN, string3);
            this.m_rows.add(n++, arrayList);
        }
        this.fireTableStructureChanged();
    }

    public Vector getValidatedActivities() {
        return this.m_vaidatedActivities;
    }

    static {
        CodeGenWarningsTableModel.columns[CodeGenWarningsTableModel.CG_ACTIVITY_ICON_COLUMN] = ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_STATUS");
        CodeGenWarningsTableModel.columns[CodeGenWarningsTableModel.CG_ACTIVITY_NAME_COLUMN] = ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_NAME");
        CodeGenWarningsTableModel.columns[CodeGenWarningsTableModel.CG_ACTIVITY_TYPE_COLUMN] = ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_TYPE");
        OK_ICON = ResourceUtilities.getUILabel("CODE_GEN_IMAGE_OK_ICON");
        WARNING_ICON = ResourceUtilities.getUILabel("CODE_GEN_IMAGE_WARNING_ICON");
        ERROR_ICON = ResourceUtilities.getUILabel("CODE_GEN_IMAGE_ERROR_ICON");
    }
}

