/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.awt.Component;
import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenActivityState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenProcNameTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenProcNameTableSorter;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class CodeGenTargetState
extends WizardStepState
implements Runnable {
    private CodeGenProcNameTableModel m_tableModel = new CodeGenProcNameTableModel(this);
    private CodeGenProcNameTableSorter m_sorter = new CodeGenProcNameTableSorter(this.m_tableModel);
    private String m_targetPackageName;
    private String m_packageComment;
    private String m_targetSchemaName;
    private boolean m_bDropExistingObjects = false;
    private boolean m_bSupportWorkflowAPI = true;
    private boolean m_bDefiner = true;
    private CodeGenDataSource m_ds;

    public CodeGenTargetState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this.m_ds = ((CodeGenState)wizardState).getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void load() {
        block9: {
            Connection connection;
            block8: {
                CodeGenActivityState codeGenActivityState = (CodeGenActivityState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
                connection = null;
                CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
                connection = codeGenState.getContextConnection();
                if (connection == null) break block8;
                this.m_tableModel.load(connection, codeGenActivityState.getSelectedActivities());
            }
            Object var6_4 = null;
            try {
                connection.close();
            }
            catch (Exception exception) {}
            break block9;
            {
                catch (Exception exception) {
                    exception.printStackTrace();
                    Object var6_5 = null;
                    try {
                        connection.close();
                    }
                    catch (Exception exception2) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void registerPackageDetailsHelpTopic(Component component) {
        this.m_ds.registerPackageDetailsHelpTopic(component);
    }

    public void validate(Vector vector) throws Exception {
        this.validatePackageName(vector);
        if (!this.m_sorter.validateNamesUnique()) {
            vector.add(new StateValidation(DataStateError.CG_RECORD_TYPE_NAME_NON_UNIQUE));
            return;
        }
        this.validateProcedureLength(vector);
        this.validateSchemaIntegrity(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
        CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
        codeGenState.invalidateResultsStep();
    }

    private void validateProcedureLength(Vector vector) throws Exception {
        Vector vector2 = this.getProcedures();
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.elementAt(i);
            if (27 >= string.toCharArray().length) continue;
            vector.add(new StateValidation(DataStateError.CG_PPROCEDURE_NAME_TOO_LONG));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateSchemaIntegrity(Vector var1_1) {
        block17: {
            block16: {
                var2_2 = (CodeGenState)this.getparentWizardState();
                if (var2_2.isDataMiner()) {
                    return;
                }
                if (var2_2.isJDevOffline()) {
                    return;
                }
                var3_3 = null;
                try {
                    try {
                        var3_3 = var2_2.getSelectedDBConnection();
                        if (var3_3 == null) {
                            var11_4 = null;
                            break block16;
                        }
                        var4_12 = new Vector<String>();
                        var4_12.add(this.m_targetPackageName);
                        var5_14 = this.getProcedures();
                        var4_12.addAll(var5_14);
                        for (var6_15 = 0; var6_15 < var5_14.size(); ++var6_15) {
                            var7_16 = (String)var5_14.elementAt(var6_15);
                            var8_17 = this.m_sorter.getRecordTypeName(var7_16);
                            if (var8_17 != null) {
                                var4_12.add(var8_17);
                            }
                            if ((var9_18 = this.m_sorter.getTableTypeName(var7_16)) == null) continue;
                            var4_12.add(var9_18);
                        }
                        if (DMEMetadata.doObjectExist(var3_3, var4_12)) {
                            var1_1.add(new StateValidation(DataStateError.CG_NAME_EXISTS_INSCHEMA));
                        }
                        break block17;
                    }
                    catch (Exception var4_13) {
                        var4_13.printStackTrace();
                        var11_6 = null;
                        try {
                            var3_3.close();
                            return;
                        }
                        catch (Exception var12_10) {
                            return;
                        }
                    }
                }
                catch (Throwable var10_19) {
                    var11_7 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 204->213)] { 
lbl47:
                    // 1 sources

                    var3_3.close();
                    throw var10_19;
lbl49:
                    // 1 sources

                    catch (Exception var12_11) {
                        // empty catch block
                    }
                    throw var10_19;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 204->213)] { 
lbl54:
            // 1 sources

            var3_3.close();
            return;
lbl56:
            // 1 sources

            catch (Exception var12_8) {
                // empty catch block
            }
            return;
        }
        var11_5 = null;
        try {}
        catch (Exception var12_9) {}
        var3_3.close();
        return;
    }

    public TableSorter getTableModel() {
        return this.m_sorter;
    }

    public void validateProcedureName(String string, Vector vector) throws Exception {
        if (!this.isValidDbNameName(string)) {
            vector.add(new StateValidation(DataStateError.CG_PROCEDURE_NAME_INVALID));
            return;
        }
        if (!this.m_sorter.isProcedureNameUnique(string)) {
            vector.add(new StateValidation(DataStateError.CG_PROCEDURE_NAME_NON_UNIQUE));
        }
    }

    private void validatePackageName(Vector vector) throws Exception {
        if (this.m_targetPackageName == null || 0 == this.m_targetPackageName.length()) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_MISSING));
        } else if (!this.isValidDbNameName(this.m_targetPackageName)) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_INVALID));
        } else if (-1 != this.m_targetPackageName.indexOf("'")) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_INVALID));
        } else if (-1 != this.m_targetPackageName.indexOf(":")) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_INVALID));
        } else if (30 < this.m_targetPackageName.toCharArray().length) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_TOO_LONG));
        } else if (((CodeGenState)this.getparentWizardState()).isPackageNameInUse(this.m_targetSchemaName, this.m_targetPackageName)) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_EXISTS));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean isValidDbNameName(String string) {
        if (DM4JStringUtils.isDoubleQuotedString(string)) {
            if (!Character.isLetter(string.charAt(1))) {
                return false;
            }
        } else {
            int n = string.indexOf("'");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("\"");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("-");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("\\");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("/");
            if (n != -1) {
                return false;
            }
        }
        return true;
    }

    public String getTargetPackageName() {
        return this.m_targetPackageName;
    }

    public void setTargetPackageName(String string) {
        if (null == string || null == this.m_targetPackageName || 0 == string.length()) {
            this.setState(StepStateType.DIRTY);
        } else if (0 != string.compareTo(this.m_targetPackageName)) {
            this.setState(StepStateType.DIRTY);
        }
        if (string != null && 0 != string.length() && this.m_targetPackageName != null && string.equals(this.m_targetPackageName)) {
            return;
        }
        this.m_targetPackageName = !DM4JStringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
    }

    public void setPackageComment(String string) {
        if (null == string && null == this.m_packageComment) {
            return;
        }
        if (null == string || null == this.m_packageComment) {
            this.setState(StepStateType.DIRTY);
        } else if (0 != string.compareTo(this.m_packageComment)) {
            this.setState(StepStateType.DIRTY);
        }
        this.m_packageComment = string;
    }

    public String getPackageComment() {
        return this.m_packageComment;
    }

    public String getTargetSchemaName() {
        return this.m_targetSchemaName;
    }

    public void setTargetSchemaName(String string) {
        this.m_targetSchemaName = !DM4JStringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
    }

    public void run() {
    }

    public boolean postValidate(Vector vector) {
        int n;
        for (n = 0; n < this.m_sorter.getRowCount(); ++n) {
            boolean bl = this.m_sorter.isRealTimeSupport(n);
            if (bl) continue;
            String string = this.m_sorter.getProcedureName(n);
            this.m_sorter.removeRealTimeSupportTypes(string);
        }
        n = 1;
        return n != 0;
    }

    public Vector getProcedures() {
        return this.m_sorter.getProcedureNames();
    }

    public Vector getSelectedData() {
        return this.m_sorter.getSelectedData();
    }

    public void setDropExistingObjects(boolean bl) {
        this.m_bDropExistingObjects = bl;
    }

    public boolean isDropExistingObjects() {
        return this.m_bDropExistingObjects;
    }

    public void setSupportWorkflowAPI(boolean bl) {
        this.m_bSupportWorkflowAPI = bl;
    }

    public boolean isSupportWorkflowAPI() {
        return this.m_bSupportWorkflowAPI;
    }

    public void setDefiner(boolean bl) {
        this.m_bDefiner = bl;
    }

    public boolean isDefiner() {
        return this.m_bDefiner;
    }

    public String getRecordTypeName(String string) {
        return this.m_sorter.getRecordTypeName(string);
    }

    public String getTableTypeName(String string) {
        return this.m_sorter.getTableTypeName(string);
    }
}

