/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.codegen.ActivityDetail;
import oracle.dmt.dm4j.codegen.CodeGen;
import oracle.dmt.dm4j.codegen.CodeGenInput;
import oracle.dmt.dm4j.codegen.CodeGenResult;
import oracle.dmt.dm4j.codegen.ProgressDispatcher;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenActivityState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenProcNameTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenTargetState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenWarningsTableModel;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;
import oracle.dmt.dm4j.wizard.steps.transformsteps.UpdateProgress;

public class CodeGenResultsState
extends WizardStepState
implements ProgressDispatcher {
    private CodeGenWarningsTableModel m_tableModel;
    private TableSorter m_sorter;
    private CodeGenDataSource m_ds;
    private Vector m_selectedActivities = new Vector();
    private Hashtable m_restoredActivities = new Hashtable();
    private UpdateProgress m_updater;
    private CodeGenResult m_result;
    private HashMap m_exceptions;
    private boolean m_bCanAdvance;
    private boolean m_bCanGoBack;

    public CodeGenResultsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this.m_tableModel = new CodeGenWarningsTableModel(this);
        this.m_sorter = new TableSorter(this.m_tableModel);
        this.m_ds = ((CodeGenState)wizardState).getDataSource();
    }

    public void load() {
        CodeGenActivityState codeGenActivityState = (CodeGenActivityState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
        this.m_selectedActivities = codeGenActivityState.getSelectedActivities();
        this.m_restoredActivities = codeGenActivityState.getRestoredActivities();
    }

    public void refresh() throws Exception {
        this.load();
    }

    public CodeGenResult getResults() {
        return this.m_result;
    }

    public void registerResultsHelpTopic(Component component) {
        this.m_ds.registerResultsHelpTopic(component);
    }

    public void validate(Vector vector) throws Exception {
    }

    public boolean postValidate(Vector vector) {
        return true;
    }

    public int getAllStepsCount() {
        int n = 0;
        Enumeration enumeration = this.m_restoredActivities.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            AbstractActivity abstractActivity = (AbstractActivity)this.m_restoredActivities.get(string);
            Vector vector = abstractActivity.getSteps();
            n += vector.size();
        }
        return n;
    }

    public void generateCode(UpdateProgress updateProgress) throws Exception {
        Object object;
        Object object2;
        Object object3;
        this.m_updater = updateProgress;
        CodeGenActivityState codeGenActivityState = (CodeGenActivityState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
        CodeGenTargetState codeGenTargetState = (CodeGenTargetState)this.getparentWizardState().getStep(StepType.SETTING_STEP_2);
        Vector vector = codeGenTargetState.getProcedures();
        if (vector == null || vector.isEmpty()) {
            throw new Exception();
        }
        Vector vector2 = codeGenTargetState.getSelectedData();
        ArrayList<ActivityDetail> arrayList = new ArrayList<ActivityDetail>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            object3 = (Hashtable)vector2.elementAt(i);
            String string = (String)((Hashtable)object3).get(new Integer(CodeGenProcNameTableModel.ACTIVITY_COL));
            ActivityType activityType = (ActivityType)((Hashtable)object3).get(new Integer(CodeGenProcNameTableModel.ACTIVITY_TYPE));
            String string2 = (String)((Hashtable)object3).get(new Integer(CodeGenProcNameTableModel.PROCEDURE_COL));
            object2 = (Boolean)((Hashtable)object3).get(new Integer(CodeGenProcNameTableModel.REALTIME_SUPPORT));
            object = codeGenActivityState.getSelectedActivityModelName(string);
            String string3 = codeGenActivityState.getSelectedActivityFunctionName(string);
            String string4 = codeGenActivityState.getSelectedActivityAlgorithmName(string);
            AbstractActivity abstractActivity = codeGenActivityState.getSelectedRestoredActivity(string);
            ActivityDetail activityDetail = new ActivityDetail(abstractActivity, ActivityType.getActivityGroupType(activityType), (String)object, string3, string4, string2, (Boolean)object2);
            activityDetail.setRecordTypeName(codeGenTargetState.getRecordTypeName(string2));
            activityDetail.setTableTypeName(codeGenTargetState.getTableTypeName(string2));
            arrayList.add(activityDetail);
        }
        String string = codeGenTargetState.getTargetPackageName();
        object3 = codeGenTargetState.getPackageComment();
        boolean bl = codeGenTargetState.isDefiner();
        boolean bl2 = codeGenTargetState.isDropExistingObjects();
        boolean bl3 = codeGenTargetState.isSupportWorkflowAPI();
        object2 = new CodeGenInput(string, (String)object3, arrayList, bl2, bl, bl2, bl3);
        object = new CodeGen((CodeGenInput)object2, this);
        this.m_result = ((CodeGen)object).generateCode();
        this.m_exceptions = ((CodeGen)object).getExceptions();
    }

    public HashMap getExceptions() {
        return this.m_exceptions;
    }

    public boolean isClean() {
        return this.m_exceptions == null || this.m_exceptions.isEmpty();
    }

    public void beginProcessActivity(int n, String string) {
        if (this.m_updater != null) {
            this.m_updater.updateProgress(n, ResourceUtilities.getUILabel("CODE_GEN_RESULTS_STEP_PROCESSING_LABEL") + string, null);
        }
    }

    public void finishedProcessActivity(int n, String string) {
        if (this.m_updater != null) {
            this.m_updater.updateProgress(n, null, ResourceUtilities.getUILabel("CODE_GEN_RESULTS_STEP_GENERATED_CODE_LABEL") + string);
        }
    }

    public void errorProcessActivity(int n, String string) {
        if (this.m_updater != null) {
            this.m_updater.updateProgress(n, null, ResourceUtilities.getUILabel("CODE_GEN_RESULTS_STEP_ERROR_GENERATED_CODE_LABEL") + string);
        }
    }

    public boolean hasUserCanceled() {
        boolean bl = false;
        if (this.m_updater != null) {
            bl = this.m_updater.hasUserCancelled();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadActivities() {
        try {
            try {
                this.m_tableModel.load(this.m_exceptions, this.m_selectedActivities);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                Object var3_2 = null;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            throw throwable;
        }
    }

    public void setCanAdvance(boolean bl) {
        this.m_bCanAdvance = bl;
    }

    public boolean getCanAdvance() {
        return this.m_bCanAdvance;
    }

    public void setCanGoBack(boolean bl) {
        this.m_bCanGoBack = bl;
    }

    public boolean getCanGoBack() {
        return this.m_bCanGoBack;
    }

    public Vector getValidatedActivities() {
        return this.m_tableModel.getValidatedActivities();
    }

    public TableSorter getTableModel() {
        return this.m_sorter;
    }
}

