/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.awt.Component;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import oracle.dmt.dm4j.ConnectionPersistenceInfo;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class CodeGenConnectionState
extends WizardStepState
implements Runnable {
    private CodeGenDataSource m_cgDataSource;
    private Exception m_exception;
    private ProgressBar m_connectionBar;
    private Hashtable m_htConnDetails;

    public CodeGenConnectionState(WizardState wizardState, CodeGenDataSource codeGenDataSource, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this.m_cgDataSource = codeGenDataSource;
    }

    public void load() {
    }

    public void registerConnectionHelpTopic(Component component) {
        this.m_cgDataSource.registerConnectionHelpTopic(component);
    }

    public void refresh() throws Exception {
    }

    public void validate(Vector vector) throws Exception {
        if (this.m_cgDataSource.isEmptySelectedConnectionName()) {
            vector.add(new StateValidation(DataStateError.CG_CONNECTION_NOT_SELECTED));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    public String getContextConnName() {
        if (this.m_cgDataSource == null) {
            return null;
        }
        return this.m_cgDataSource.getContextConnName();
    }

    public Vector getConnectionNames() {
        if (this.m_cgDataSource == null) {
            return null;
        }
        return this.m_cgDataSource.getConnectionNames();
    }

    public void setConnectionName(String string) {
        if (string == null) {
            this.setState(StepStateType.DIRTY);
            return;
        }
        String string2 = this.m_cgDataSource.getSelectedConnectionName();
        if (string2 == null || 0 != string2.compareTo(string)) {
            this.m_cgDataSource.setSelectedConnectionName(string);
            this.setState(StepStateType.DIRTY);
        }
    }

    public String getUserName(String string) {
        if (string == null) {
            return "";
        }
        Hashtable hashtable = this.m_cgDataSource.getConnectionDetails(string);
        String string2 = (String)hashtable.get("USER_NAME");
        return string2 != null ? string2 : "";
    }

    public String getDriver(String string) {
        if (string == null) {
            return "";
        }
        Hashtable hashtable = this.m_cgDataSource.getConnectionDetails(string);
        String string2 = (String)hashtable.get("DRIVER");
        return string2 != null ? string2 : "";
    }

    public String getURL(String string) {
        if (string == null) {
            return "";
        }
        Hashtable hashtable = this.m_cgDataSource.getConnectionDetails(string);
        String string2 = (String)hashtable.get("CONN_STRING");
        return string2 != null ? string2 : "";
    }

    public boolean postValidate(Vector vector) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block14: {
            Connection connection = null;
            ConnectionPersistenceInfo connectionPersistenceInfo = this.m_cgDataSource.getConnectionInfo(this.m_cgDataSource.getSelectedConnectionName());
            String string = connectionPersistenceInfo.getSid();
            if (string == null || 0 == string.length()) {
                string = connectionPersistenceInfo.getServiceName();
            }
            DM4JConnectionManager.initialize(connectionPersistenceInfo.getHost(), connectionPersistenceInfo.getPort(), string, false, connectionPersistenceInfo.getUser(), connectionPersistenceInfo.getMigratedPassword().toCharArray(), Locale.getDefault());
            this.setState(StepStateType.VALIDATED);
            connection = DM4JConnectionManager.getDbConnection();
            Object var5_5 = null;
            try {
                DM4JConnectionManager.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (this.m_connectionBar != null) {
                this.m_connectionBar.setDoneStatus();
            }
            break block14;
            {
                catch (Exception exception) {
                    this.m_exception = exception;
                    Object var5_6 = null;
                    try {
                        DM4JConnectionManager.close();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    if (this.m_connectionBar != null) {
                        this.m_connectionBar.setDoneStatus();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                try {
                    DM4JConnectionManager.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.m_connectionBar != null) {
                    this.m_connectionBar.setDoneStatus();
                }
                throw throwable;
            }
        }
    }
}

