/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.awt.Component;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JUserHasCanceledException;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.AbstractApplyActivity;
import oracle.dmt.dm4j.activity.AbstractTestActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.activity.steps.AbstractMiningStep;
import oracle.dmt.dm4j.activity.steps.BuildStep;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CodeGenDBDescriptor;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenActivitiesTableModel;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.transforms.CodeGenWizard;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class CodeGenActivityState
extends WizardStepState
implements Runnable {
    private CodeGenActivitiesTableModel m_activitiesTableModel = new CodeGenActivitiesTableModel(this);
    private Vector m_selectedActivities;
    private Hashtable m_restoredActivities;
    private ProgressBar m_loadActivityBar;
    private Exception m_exception;
    private ProgressBar m_activityValidationBar;
    private Exception m_populateActivityException;
    private CodeGenDataSource m_ds;

    public CodeGenActivityState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this.m_ds = ((CodeGenState)wizardState).getDataSource();
    }

    public CodeGenActivitiesTableModel getActivitiesTableModel() {
        return this.m_activitiesTableModel;
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void registerActivityHelpTopic(Component component) {
        this.m_ds.registerActivityHelpTopic(component);
    }

    private void setSelectedActivities(Vector vector) {
        this.m_selectedActivities = vector;
    }

    public Vector getSelectedActivities() {
        return this.m_selectedActivities;
    }

    private void setRestoredActivities(Hashtable hashtable) {
        this.m_restoredActivities = hashtable;
    }

    public Hashtable getRestoredActivities() {
        return this.m_restoredActivities;
    }

    public AbstractActivity getSelectedRestoredActivity(String string) {
        return (AbstractActivity)this.m_restoredActivities.get(string);
    }

    public String getSelectedActivityModelName(String string) {
        return this.m_activitiesTableModel.getSelectedActivityModelName(string);
    }

    public String getSelectedActivityFunctionName(String string) {
        return this.m_activitiesTableModel.getSelectedActivityFunctionName(string);
    }

    public String getSelectedActivityAlgorithmName(String string) {
        return this.m_activitiesTableModel.getSelectedActivityAlgorithmName(string);
    }

    public void validate(Vector vector) throws Exception {
        Object object;
        Vector vector2 = null;
        if (this.m_activitiesTableModel == null || 0 == this.m_activitiesTableModel.getRowCount()) {
            vector.add(new StateValidation(DataStateError.CG_ACTIVITIES_NOT_PRESENT));
        } else {
            vector2 = this.m_activitiesTableModel.getSelectedActivities();
            if (vector2 == null || vector2.isEmpty()) {
                vector.add(new StateValidation(DataStateError.CG_ACTIVITIES_NOT_SELECTED));
            } else {
                this.m_populateActivityException = null;
                object = new ActivityValidator(vector2);
                CodeGenWizard codeGenWizard = (CodeGenWizard)this.getparentWizardState().getWizard();
                this.m_activityValidationBar = new ProgressBar(codeGenWizard, ResourceUtilities.getUILabel("CODE_GEN_WIZARD_NAME"), (Runnable)object, true);
                this.m_activityValidationBar.start(ResourceUtilities.getUILabel("CG_VALIDATING_ACTIVITIES"), "");
                if (this.m_populateActivityException != null) {
                    DialogUtilities.createSystemErrorDialog(codeGenWizard.getParentDialog(), this.m_populateActivityException);
                    this.setState(StepStateType.DIRTY);
                } else {
                    if (this.m_activityValidationBar.hasUserCancelled()) {
                        this.setState(StepStateType.UNLOADED);
                        throw new DM4JUserHasCanceledException("User Calcelled");
                    }
                    Vector vector3 = ((ActivityValidator)object).getIncompetedActivities();
                    if (!vector3.isEmpty()) {
                        StringBuffer stringBuffer = new StringBuffer();
                        for (int i = 0; i < vector3.size(); ++i) {
                            stringBuffer.append("\n");
                            stringBuffer.append((String)vector3.get(i));
                            if (i >= vector3.size() - 1) continue;
                            stringBuffer.append(",");
                        }
                        vector.add(new StateValidation((ValidationType)DataStateError.CG_ACTIVITIES_NOT_COMPLETED, new String[]{stringBuffer.toString()}));
                    } else {
                        this.setRestoredActivities(((ActivityValidator)object).getCompletedRestoredActivities());
                    }
                }
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setSelectedActivities(vector2);
            this.setState(StepStateType.VALIDATED);
            object = (CodeGenState)this.getparentWizardState();
            ((CodeGenState)object).invalidateTargetActivityStep();
        }
    }

    public void load() throws Exception {
        this.m_exception = null;
        CodeGenWizard codeGenWizard = (CodeGenWizard)this.getparentWizardState().getWizard();
        CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
        if (this.m_ds != null) {
            this.m_ds.setUserCancelled(false);
        }
        this.m_loadActivityBar = new ProgressBar(codeGenWizard, ResourceUtilities.getUILabel("CODE_GEN_WIZARD_NAME"), this, true);
        this.m_loadActivityBar.start(ResourceUtilities.getUILabel("CG_POPULATING_ACTIVITIES"), "");
        if (this.m_exception != null) {
            if (codeGenState.isDataMiner()) {
                DialogUtilities.createSystemErrorDialog(codeGenWizard.getParentDialog(), this.m_exception, false);
            } else {
                this.m_ds.showConnectiionErrorMessage(this.m_exception, this.m_ds.getSelectedConnectionName());
            }
            this.m_activitiesTableModel.emptyModel();
            this.setState(StepStateType.UNLOADED);
            throw this.m_exception;
        }
        if (this.m_loadActivityBar.hasUserCancelled()) {
            if (this.m_ds != null) {
                this.m_ds.setUserCancelled(true);
            }
            this.m_activitiesTableModel.emptyModel();
            this.setState(StepStateType.UNLOADED);
            throw new DM4JUserHasCanceledException("");
        }
        this.m_activitiesTableModel.fireTableStructureChanged();
    }

    public void run() {
        this.loadInternal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadInternal() {
        block19: {
            block15: {
                block18: {
                    block14: {
                        var1_1 = null;
                        try {
                            try {
                                this.m_activitiesTableModel.emptyModel();
                                var2_2 = (CodeGenState)this.getparentWizardState();
                                v0 = var1_1 = var2_2.isDataMiner() != false ? DM4JConnectionManager.getDbConnection() : var2_2.getSelectedDBConnection();
                                if (var1_1 == null) {
                                    var6_4 = null;
                                    break block14;
                                }
                                this.m_exception = null;
                                var3_12 = null;
                                if (var2_2.isJDevOffline()) {
                                    if (this.m_ds != null) {
                                        var3_12 = this.m_ds.getProjectContextSchemas();
                                    }
                                } else {
                                    var4_13 = DMEMetadata.getAllPackages(var1_1);
                                    var3_12 = new CodeGenDBDescriptor();
                                    var3_12.addSchema(DM4JConnectionManager.getUser(), var4_13);
                                }
                                var2_2.setDBDescriptor(var3_12);
                                this.m_activitiesTableModel.load(var1_1, this.m_ds.getSelectedActivities());
                                break block15;
                            }
                            catch (Exception var2_3) {
                                this.m_exception = var2_3;
                                var6_6 = null;
                                try {
                                    var1_1.close();
                                }
                                catch (Exception var7_10) {
                                    // empty catch block
                                }
                                if (this.m_loadActivityBar == null) return;
                                this.m_loadActivityBar.setDoneStatus();
                                return;
                            }
                        }
                        catch (Throwable var5_14) {
                            block17: {
                                var6_7 = null;
                                ** try [egrp 2[TRYBLOCK] [6 : 146->155)] { 
lbl40:
                                // 1 sources

                                var1_1.close();
                                break block17;
lbl42:
                                // 1 sources

                                catch (Exception var7_11) {
                                    // empty catch block
                                }
                            }
                            if (this.m_loadActivityBar == null) throw var5_14;
                            this.m_loadActivityBar.setDoneStatus();
                            throw var5_14;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [6 : 146->155)] { 
lbl50:
                    // 1 sources

                    var1_1.close();
                    break block18;
lbl52:
                    // 1 sources

                    catch (Exception var7_8) {
                        // empty catch block
                    }
                }
                if (this.m_loadActivityBar == null) return;
                this.m_loadActivityBar.setDoneStatus();
                return;
            }
            var6_5 = null;
            ** try [egrp 2[TRYBLOCK] [6 : 146->155)] { 
lbl61:
            // 1 sources

            var1_1.close();
            break block19;
lbl63:
            // 1 sources

            catch (Exception var7_9) {
                // empty catch block
            }
        }
        if (this.m_loadActivityBar == null) return;
        this.m_loadActivityBar.setDoneStatus();
    }

    class ActivityValidator
    implements Runnable {
        private Vector m_vActivities = null;
        private Vector m_vIncompleteActivities = new Vector();
        private Hashtable m_activityMap = new Hashtable();

        ActivityValidator(Vector vector) {
            this.m_vActivities = vector;
        }

        Vector getIncompetedActivities() {
            return this.m_vIncompleteActivities;
        }

        Hashtable getCompletedRestoredActivities() {
            return this.m_activityMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block19: {
                Connection connection = null;
                CodeGenState codeGenState = null;
                try {
                    try {
                        codeGenState = (CodeGenState)CodeGenActivityState.this.getparentWizardState();
                        connection = codeGenState.isDataMiner() ? DM4JConnectionManager.getDbConnection() : codeGenState.getSelectedDBConnection();
                        CodeGenActivityState.this.m_populateActivityException = null;
                        for (int i = 0; i < this.m_vActivities.size(); ++i) {
                            AbstractMiningStep abstractMiningStep;
                            Hashtable hashtable = (Hashtable)this.m_vActivities.elementAt(i);
                            String string = (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_NAME_COLUMN));
                            AbstractActivity abstractActivity = null;
                            try {
                                abstractActivity = AbstractActivity.restore(string);
                            }
                            catch (Exception exception) {
                                abstractActivity = null;
                                exception.printStackTrace();
                            }
                            if (abstractActivity == null) {
                                this.m_vIncompleteActivities.add(string);
                                continue;
                            }
                            ActivityType activityType = abstractActivity.getType();
                            if (ActivityType.isBuildActivity(activityType)) {
                                abstractMiningStep = abstractActivity.findBuildStep();
                                if (!abstractMiningStep.getIsComplete()) {
                                    this.m_vIncompleteActivities.add(string);
                                    continue;
                                }
                                String string2 = abstractMiningStep.getOutputMiningName();
                                if (DMEMetadata.getInstance().doesModelExist(connection, string2)) {
                                    this.m_activityMap.put(string, abstractActivity);
                                    continue;
                                }
                                this.m_vIncompleteActivities.add(string);
                                continue;
                            }
                            if (ActivityType.isTestActivity(activityType)) {
                                abstractMiningStep = abstractActivity.findTestStep();
                                if (!abstractMiningStep.getIsComplete()) {
                                    this.m_vIncompleteActivities.add(string);
                                    continue;
                                }
                                if (!this.isActivityInSync((AbstractTestActivity)abstractActivity)) {
                                    this.m_vIncompleteActivities.add(string);
                                    continue;
                                }
                                this.m_activityMap.put(string, abstractActivity);
                                continue;
                            }
                            if (!ActivityType.isApplyActivity(activityType)) continue;
                            abstractMiningStep = abstractActivity.findApplyStep();
                            if (!abstractMiningStep.getIsComplete()) {
                                this.m_vIncompleteActivities.add(string);
                                continue;
                            }
                            if (!this.isActivityInSync((AbstractApplyActivity)abstractActivity)) {
                                this.m_vIncompleteActivities.add(string);
                                continue;
                            }
                            this.m_activityMap.put(string, abstractActivity);
                        }
                        Object var11_12 = null;
                        if (!codeGenState.isDataMiner()) break block19;
                    }
                    catch (Exception exception) {
                        CodeGenActivityState.this.m_populateActivityException = exception;
                        Object var11_13 = null;
                        if (codeGenState.isDataMiner()) {
                            DM4JConnectionManager.close();
                        }
                        if (CodeGenActivityState.this.m_activityValidationBar == null) return;
                        CodeGenActivityState.this.m_activityValidationBar.setDoneStatus();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    if (codeGenState.isDataMiner()) {
                        DM4JConnectionManager.close();
                    }
                    if (CodeGenActivityState.this.m_activityValidationBar == null) throw throwable;
                    CodeGenActivityState.this.m_activityValidationBar.setDoneStatus();
                    throw throwable;
                }
                DM4JConnectionManager.close();
            }
            if (CodeGenActivityState.this.m_activityValidationBar == null) return;
            CodeGenActivityState.this.m_activityValidationBar.setDoneStatus();
        }

        private boolean isActivityInSync(AbstractApplyActivity abstractApplyActivity) {
            boolean bl = false;
            boolean bl2 = false;
            AbstractActivity abstractActivity = null;
            try {
                abstractActivity = AbstractActivity.restore(abstractApplyActivity.getSourceActivityName());
                if (abstractActivity == null) {
                    return false;
                }
                BuildStep buildStep = abstractActivity.findBuildStep();
                String string = buildStep.getModelSignature();
                String string2 = abstractApplyActivity.getModelSignature();
                if (string == null && string2 == null) {
                    bl2 = true;
                } else if (string != null && string2 != null && string.equals(string2)) {
                    bl2 = true;
                }
                if (!bl2) {
                    return false;
                }
                bl = buildStep.getOutputMiningName() != null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                bl = false;
            }
            return bl;
        }
    }
}

