/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStepState;

public class CodeGenActivitiesTableModel
extends AbstractTableModel {
    private WizardStepState m_parentState;
    private Vector m_rows = new Vector();
    private static String[] columns = new String[DMEMetadata.CG_TOTAL_COUNT];
    private static int index = 0;

    public CodeGenActivitiesTableModel(WizardStepState wizardStepState) {
        this.m_parentState = wizardStepState;
    }

    public int getColumnAlignment(int n) {
        return 2;
    }

    public int getSortColumn() {
        return DMEMetadata.CG_ACTIVITY_NAME_COLUMN;
    }

    public Comparator getColumnSortComparator(int n) {
        return null;
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getRowCount() {
        return this.m_rows != null ? this.m_rows.size() : 0;
    }

    public void emptyModel() {
        this.m_rows.clear();
    }

    public void load(Connection connection, Hashtable hashtable) throws Exception {
        if (!this.m_rows.isEmpty()) {
            this.m_rows.clear();
        }
        if (!DMEMetadata.isActivtyTableAvailable(connection)) {
            throw new Exception(ResourceUtilities.getstateExceptionMessage("CG_NO_ACTIVITIES"));
        }
        this.m_rows = DMEMetadata.getCodeGenActivityList(connection, hashtable);
    }

    public Class getColumnClass(int n) {
        if (n == DMEMetadata.CG_ACTIVITY_SELECTED_COLUMN) {
            return Boolean.class;
        }
        if (n == DMEMetadata.CG_ACTIVITY_CREATION_DATE_COLUMN) {
            return Date.class;
        }
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.m_rows.get(n);
        if (arrayList != null) {
            if (n2 != DMEMetadata.CG_ACTIVITY_TYPE_COLUMN) {
                return arrayList.get(n2);
            }
            ActivityType activityType = ActivityType.getInstance((String)arrayList.get(n2));
            return ActivityType.getCodeGenActivityGroupType(activityType);
        }
        return null;
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == DMEMetadata.CG_ACTIVITY_SELECTED_COLUMN;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == DMEMetadata.CG_ACTIVITY_SELECTED_COLUMN) {
            ArrayList arrayList = (ArrayList)this.m_rows.elementAt(n);
            arrayList.set(DMEMetadata.CG_ACTIVITY_SELECTED_COLUMN, object);
            this.m_parentState.setState(StepStateType.DIRTY);
            this.fireTableCellUpdated(n, n2);
        }
    }

    public Vector getSelectedActivities() {
        if (this.m_rows == null || 0 == this.m_rows.size()) {
            return null;
        }
        Vector vector = null;
        for (int i = 0; i < this.getRowCount(); ++i) {
            ArrayList arrayList = (ArrayList)this.m_rows.get(i);
            Boolean bl = (Boolean)arrayList.get(DMEMetadata.CG_ACTIVITY_SELECTED_COLUMN);
            if (bl == null || !bl.equals(Boolean.TRUE)) continue;
            if (vector == null) {
                vector = new Vector();
            }
            Hashtable hashtable = new Hashtable();
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_NAME_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_NAME_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_TYPE_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_TYPE_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_MODEL_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_MODEL_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_FUNCTION_NAME_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_FUNCTION_NAME_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_ALG_NAME_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_ALG_NAME_COLUMN));
            vector.add(hashtable);
        }
        return vector;
    }

    public String getSelectedActivityModelName(String string) {
        Hashtable hashtable = this.getSelectedActivityDetails(string);
        return (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_MODEL_COLUMN));
    }

    public String getSelectedActivityFunctionName(String string) {
        Hashtable hashtable = this.getSelectedActivityDetails(string);
        return (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_FUNCTION_NAME_COLUMN));
    }

    public String getSelectedActivityAlgorithmName(String string) {
        Hashtable hashtable = this.getSelectedActivityDetails(string);
        return (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_ALG_NAME_COLUMN));
    }

    private Hashtable getSelectedActivityDetails(String string) {
        if (this.m_rows == null || 0 == this.m_rows.size()) {
            return null;
        }
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string2;
            ArrayList arrayList = (ArrayList)this.m_rows.get(i);
            Boolean bl = (Boolean)arrayList.get(DMEMetadata.CG_ACTIVITY_SELECTED_COLUMN);
            if (bl == null || !bl.equals(Boolean.TRUE) || 0 != (string2 = (String)arrayList.get(DMEMetadata.CG_ACTIVITY_NAME_COLUMN)).compareTo(string)) continue;
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_NAME_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_NAME_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_TYPE_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_TYPE_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_MODEL_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_MODEL_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_FUNCTION_NAME_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_FUNCTION_NAME_COLUMN));
            hashtable.put(new Integer(DMEMetadata.CG_ACTIVITY_ALG_NAME_COLUMN), arrayList.get(DMEMetadata.CG_ACTIVITY_ALG_NAME_COLUMN));
            break;
        }
        return hashtable;
    }

    static {
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index++] = ResourceUtilities.getUILabel("CODE_GEN_SELECTED");
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index++] = ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_NAME");
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index++] = ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_TYPE");
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index++] = ResourceUtilities.getUILabel("CODE_GEN_FUNCTION");
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index++] = ResourceUtilities.getUILabel("CODE_GEN_ALGORITHM");
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index++] = ResourceUtilities.getUILabel("CODE_GEN_MODEL_NAME");
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index++] = ResourceUtilities.getUILabel("CODE_GEN_CREATION_DATE");
        CodeGenActivitiesTableModel.columns[CodeGenActivitiesTableModel.index] = ResourceUtilities.getUILabel("CODE_GEN_COMMENT");
    }
}

