/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizeViewDefinition;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundaryTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationViewNameState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizeDataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;
import oracle.dmt.odm.binning.CategoricBin;

public class CategoricalDiscretizationSettingsState
extends WizardStepState {
    protected StringBuffer m_viewDefinition = null;
    protected StringBuffer m_originalDataViewDefinition = null;
    private int m_currentNumberOfBins = 0;
    private Vector m_vectorBins = new Vector();
    private boolean m_bRecalulate = true;
    protected CategoricDiscretizeDataSource m_model;

    public CategoricalDiscretizationSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() {
        this.loadDefaults();
    }

    protected void loadDefaults() {
        this.m_currentNumberOfBins = 0;
    }

    public DataState getDataState() {
        return (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }

    public void invalidate() {
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validateState() {
        this.setState(StepStateType.VALIDATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postValidate(Vector vector) throws Exception {
        DiscretizationViewNameState discretizationViewNameState = (DiscretizationViewNameState)this.getparentWizardState().getStep(StepType.NAME_STEP);
        DiscretizeDataState discretizeDataState = (DiscretizeDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        this.m_model = discretizationDataUsageState.getCategoricModel();
        boolean bl = true;
        DiscretizeViewDefinition discretizeViewDefinition = null;
        Connection connection = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            discretizeViewDefinition = new DiscretizeViewDefinition(connection, this.m_model, "\"" + DM4JConnectionManager.getUser() + "\".\"" + discretizationViewNameState.getViewName() + "\"");
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), discretizeViewDefinition, true);
            discretizeViewDefinition.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_DESC"));
            if (discretizeViewDefinition.getException() != null) {
                this.setState(StepStateType.DIRTY);
                bl = false;
                this.getparentWizardState().doAbortCancel(discretizeViewDefinition.getException());
            } else if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                bl = false;
            } else {
                this.setState(StepStateType.VALIDATED);
                StringBuffer stringBuffer = (StringBuffer)discretizeViewDefinition.getView();
                int n = stringBuffer.indexOf(" AS SELECT ");
                this.m_viewDefinition = new StringBuffer(stringBuffer.substring(n));
                String string = "";
                string = this.m_model.isTransactional() && !this.m_model.isSingleMetric() ? "" : this.m_model.getOriginalDataLocation();
                this.m_viewDefinition.append(string);
            }
            Object var13_12 = null;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            try {
                connection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            connection.close();
        }
        catch (Exception exception) {}
        return bl;
    }

    public StringBuffer getViewDefinition() {
        if (this.m_viewDefinition != null && this.getState() != StepStateType.VALIDATED) {
            this.m_viewDefinition.setLength(0);
            this.m_viewDefinition = null;
        }
        return this.m_viewDefinition;
    }

    public StringBuffer getOriginalDataViewDefinition() {
        if (this.m_originalDataViewDefinition != null && this.getState() != StepStateType.VALIDATED) {
            this.m_originalDataViewDefinition.setLength(0);
            this.m_originalDataViewDefinition = null;
        }
        return this.m_originalDataViewDefinition;
    }

    public void validateBinNumberValue(Vector vector) throws Exception {
        try {
            if (this.m_currentNumberOfBins < 1) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_CATEGORICAL_BIN_NUMBER));
            }
            if (this.m_currentNumberOfBins > 125) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_CATEGORICAL_BIN_NUMBER));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_CATEGORICAL_BIN_NUMBER));
        }
    }

    public void validateValues(Vector vector) throws Exception {
        this.validateBinNumberValue(vector);
    }

    public void setBinned(boolean bl) {
        if (!bl && this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void setCurrentNumberOfBins(int n) {
        if (n != this.m_currentNumberOfBins) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_currentNumberOfBins = n;
        }
    }

    public int getCurrentNumberOfBins() {
        return this.m_currentNumberOfBins;
    }

    public void setCurrentBinBoundaries(CategoricBinBoundaryTableModel categoricBinBoundaryTableModel) {
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
        this.m_vectorBins.clear();
        int n = categoricBinBoundaryTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            CategoricBinBoundary categoricBinBoundary = categoricBinBoundaryTableModel.getFieldEntry(i);
            Vector vector = new Vector();
            vector.addAll(categoricBinBoundary.getBinVectorValues());
            CategoricBin categoricBin = new CategoricBin(new String(categoricBinBoundary.getBinCategory()), vector);
            this.m_vectorBins.add(categoricBin);
        }
    }

    public boolean isValid() {
        return this.getState() == StepStateType.VALIDATED;
    }

    public void setRecalculate(boolean bl) {
        this.m_bRecalulate = bl;
    }

    public boolean isRecalculate() {
        return this.m_bRecalulate;
    }

    public Vector getCurrentBinBoundaries() {
        return this.m_vectorBins;
    }

    public ComplexDataStructure getSampledInputCDS() {
        return null;
    }

    public ComplexDataStructure getSampledOutputCDS() {
        return null;
    }

    public ComplexDataStructure getOriginalInputCDS() {
        return null;
    }

    public ComplexDataStructure getOriginalOutputCDS() {
        return null;
    }
}

