/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.SampleStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.SampleSettingsStateError;

public abstract class BaseSampleSettingsState
extends WizardStepState {
    protected Integer m_randomSeed = new Integer("12345");
    protected SampleStepOptions m_options = null;

    public BaseSampleSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof SampleStepOptions) {
            this.m_options = (SampleStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_randomSeed = this.m_options.getRandomSeed();
        }
    }

    protected void validateRandomSeed(Vector vector) throws Exception {
        if (this.m_randomSeed == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED")};
            vector.add(new StateValidation(SampleSettingsStateError.REQUIRED_FIELD, string, stringArray));
        } else {
            int n = this.m_randomSeed;
            if (n <= 0) {
                String string = ResourceUtilities.getstateExceptionMessage("POSITIVE_INTEGER");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED")};
                vector.add(new StateValidation(SampleSettingsStateError.POSITIVE_INTEGER, string, stringArray));
            }
        }
    }

    public void setRandomSeed(Integer n) {
        if (this.m_randomSeed == null || n == null || this.m_randomSeed.compareTo(n) != 0) {
            this.m_randomSeed = n;
            if (this.m_options != null) {
                this.m_options.setRandomSeed(n);
            }
            this.setState(StepStateType.LOADED);
        }
    }

    public Integer getRandomSeed() {
        return this.m_randomSeed;
    }

    protected void loadDefaults() {
        if (this.m_options == null) {
            this.m_randomSeed = new Integer("12345");
            if (this.m_options != null) {
                this.m_options.setRandomSeed(this.m_randomSeed);
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateRandomSeed(vector);
    }
}

