/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedTargetState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class AttrValCountsTableModel
extends AbstractTableModel {
    private ArrayList[] m_tblContents;
    private String[] columns;
    private long m_nTotalSampleCount;
    private StratifiedSettingsState m_state;

    public AttrValCountsTableModel(String string, ArrayList[] arrayListArray, long l, StratifiedSettingsState stratifiedSettingsState) {
        this.m_tblContents = arrayListArray;
        this.m_nTotalSampleCount = l;
        this.m_state = stratifiedSettingsState;
        this.columns = new String[]{string, ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_ATTRVAL_TOTAL_COUNT_COLNAME"), ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_ATTRVAL_ORIGINAL_DISTRIBUTION_COLNAME"), ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_ATTRVAL_SAMPLE_COUNT_DISTRIBUTION_COLNAME"), ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_ATTRVAL_SAMPLE_COUNT_COLNAME")};
    }

    public int getRowCount() {
        return this.m_tblContents[0].size();
    }

    public int getColumnCount() {
        return 5;
    }

    public Class getColumnClass(int n) {
        return this.m_tblContents[n].get(0).getClass();
    }

    public Object getValueAt(int n, int n2) {
        return this.m_tblContents[n2].get(n);
    }

    public boolean isCellEditable(int n, int n2) {
        return n2 == 4;
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == 4) {
            this.recalculateSampleCounts(object, n);
        }
    }

    private void recalculateSampleCounts(Object object, int n) {
        if (object instanceof String) {
            object = new Long((String)object);
        }
        if (!(object instanceof Long)) {
            this.m_tblContents[6].set(n, new Boolean(false));
            return;
        }
        long l = (Long)object;
        if (l > (Long)this.m_tblContents[1].get(n)) {
            this.showWarning();
            l = (Long)this.m_tblContents[1].get(n);
        }
        this.m_nTotalSampleCount -= ((Long)this.m_tblContents[4].get(n)).longValue();
        this.m_nTotalSampleCount += l;
        this.m_tblContents[4].set(n, new Long(l));
        StratifiedTargetState stratifiedTargetState = (StratifiedTargetState)this.m_state.getparentWizardState().getStep(StepType.SETTING_STEP);
        stratifiedTargetState.setSampleNumberOfCases(new Long(this.m_nTotalSampleCount));
        for (int i = 0; i < this.m_tblContents[3].size(); ++i) {
            Double d = new Double(100.0 * ((Long)this.m_tblContents[4].get(i)).doubleValue() / (double)this.m_nTotalSampleCount);
            this.m_tblContents[3].set(i, d);
            if (d > 100.0) {
                this.m_tblContents[6].set(i, new Boolean(false));
                continue;
            }
            this.m_tblContents[6].set(i, new Boolean(true));
        }
        this.m_state.setStateLoaded();
        this.fireTableDataChanged();
    }

    private void showWarning() {
        String string = ResourceUtilities.getUILabel("STRATIFIED_SETTINGS_EXCEED_TOTAL_COUNT");
        JOptionPane.showMessageDialog(null, string, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 2);
    }

    public boolean getSampleSizeExceededCase(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        for (int i = 0; i < this.m_tblContents[6].size(); ++i) {
            if (((Boolean)this.m_tblContents[6].get(i)).booleanValue()) continue;
            stringBuffer.append(this.m_tblContents[0].get(i).toString());
            stringBuffer2.append((Long)this.m_tblContents[1].get(i));
            return true;
        }
        return false;
    }

    public String getColumnName(int n) {
        return this.columns[n];
    }

    public double getSumPercentage() {
        double d = 0.0;
        for (int i = 0; i < this.m_tblContents[3].size(); ++i) {
            d += ((Double)this.m_tblContents[3].get(i)).doubleValue();
        }
        return d;
    }

    public ArrayList[] getTableContents() {
        return this.m_tblContents;
    }

    public void restore() {
        this.m_tblContents[4].clear();
        this.m_tblContents[4].addAll(this.m_tblContents[7]);
        this.m_tblContents[3].clear();
        this.m_tblContents[3].addAll(this.m_tblContents[8]);
        this.m_nTotalSampleCount = 0L;
        for (int i = 0; i < this.m_tblContents[4].size(); ++i) {
            this.m_nTotalSampleCount += ((Long)this.m_tblContents[4].get(i)).longValue();
        }
        StratifiedTargetState stratifiedTargetState = (StratifiedTargetState)this.m_state.getparentWizardState().getStep(StepType.SETTING_STEP);
        stratifiedTargetState.setSampleNumberOfCases(new Long(this.m_nTotalSampleCount));
    }
}

