/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.AggregateSettingsEntry;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.AggregateSettingsStateError;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class AggregateSettingsState
extends WizardStepState {
    private AggregateSettingsEntry[] m_computedFields = null;

    public AggregateSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateExpression(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateFieldName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void validateExpression(Vector vector) throws Exception {
        try {
            if (this.m_computedFields.length < 1) {
                vector.add(new StateValidation(AggregateSettingsStateError.AGGREGATE_NO_ENTRY));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(AggregateSettingsStateError.AGGREGATE_NO_ENTRY));
        }
    }

    private void validateFieldName(Vector vector) throws Exception {
        for (int i = 0; i < this.m_computedFields.length; ++i) {
            String[] stringArray;
            String string;
            String string2 = this.m_computedFields[i].getName();
            if (ValidationUtil.validationsContainsErrors(vector)) continue;
            if (string2.length() == 0) {
                string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                stringArray = new String[]{string2};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
            }
            if (!ValidationUtil.checkStringLength(string2, 30)) {
                string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
                stringArray = new String[]{string2, Integer.toString(30)};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
            }
            if (ValidationUtil.isGreater32BytesInDB(string2, this.getparentWizardState().getConnection())) {
                string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
                stringArray = new String[]{string2};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_GREATER_30BYTES, string, stringArray));
            }
            if (ValidationUtil.containsDoubleQuote(string2)) {
                string = ResourceUtilities.getstateExceptionMessage("CONTAINS_DOUBLE_QUOTES");
                stringArray = new String[]{string2};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_CONTAINS_DOUBLE_QUOTES, string, stringArray));
            }
            if (AggregateSettingsState.isNameUnique(string2, this.m_computedFields)) continue;
            string = ResourceUtilities.getstateExceptionMessage("FUNCTION_NAME_DUPLICATE");
            stringArray = new String[]{string2};
            vector.add(new StateValidation(AggregateSettingsStateError.FUNCTION_NAME_DUPLICATE, string, stringArray));
        }
    }

    private static boolean isNameUnique(String string, AggregateSettingsEntry[] aggregateSettingsEntryArray) {
        int n = 0;
        boolean bl = true;
        if (aggregateSettingsEntryArray != null) {
            for (int i = 0; i < aggregateSettingsEntryArray.length; ++i) {
                if (string.compareToIgnoreCase(aggregateSettingsEntryArray[i].getName()) != 0 || ++n <= 1) continue;
                bl = false;
                i = aggregateSettingsEntryArray.length;
            }
        }
        return bl;
    }

    public void refresh() throws Exception {
    }

    public void load() throws Exception {
    }

    public void setAttributes(AggregateSettingsEntry[] aggregateSettingsEntryArray) {
        this.m_computedFields = aggregateSettingsEntryArray;
    }

    public AggregateSettingsEntry[] getAttributes() {
        return this.m_computedFields;
    }

    public WizardStepState getDataState() {
        return this.getparentWizardState().getStep(StepType.DATA_STEP);
    }
}

