/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transforms;

import java.sql.Connection;
import java.util.Iterator;
import java.util.Vector;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.wizard.director.transforms.FileImportDirector;
import oracle.dmt.dm4j.wizard.director.transforms.FileImportProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class FileImportState
extends WizardState {
    protected FileImportDirector m_director = new FileImportDirector(this);

    public FileImportState(BrowserContext browserContext, Connection connection) {
        super(browserContext, connection);
    }

    public void construct() throws Exception {
        if (this.m_director != null) {
            this.m_director.construct();
        }
    }

    public int getExistValue() throws Exception {
        if (this.m_director != null) {
            return this.m_director.getExistValue();
        }
        return -1;
    }

    protected void invalidateFurtherSteps(StepType stepType) throws Exception {
        Vector vector = this.getStepKeys();
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            StepType stepType2 = (StepType)iterator.next();
            WizardStepState wizardStepState = this.getStep(stepType2);
            if (stepType2 == stepType) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            if (StepType.DATA_STEP == stepType) {
                if (StepType.NAME_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
                } else if (StepType.SETTING_STEP == stepType2 && wizardStepState.getState() != StepStateType.UNLOADED) {
                    this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
                }
            }
            if (StepType.FINISH_STEP != stepType2 || wizardStepState.getState() == StepStateType.UNLOADED) continue;
            this.setStepState(wizardStepState, StepStateType.INCONSISTENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish(Vector vector) throws Exception {
        boolean bl = true;
        FileImportProcess fileImportProcess = null;
        try {
            fileImportProcess = new FileImportProcess(this.m_director);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TRANSFORMATION_FINISH_DIALOG_TITLE"), fileImportProcess, true);
            fileImportProcess.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("FILEIMPORT_FINISH_DIALOG_TITLE"), ResourceUtilities.getUILabel("FILEIMPORT_FINISH_DIALOG_DESC"));
            if (fileImportProcess.getException() != null) {
                this.doAbortCancel(fileImportProcess.getException());
            } else if (progressBar.hasUserCancelled()) {
                // empty if block
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            throw throwable;
        }
    }
}

