/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.datasources.TargetValueDataSource;
import oracle.dmt.dm4j.wizard.director.minings.ModelBuildLoader;
import oracle.dmt.dm4j.wizard.director.minings.TargetValueExtractProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.AttributeImportanceModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.ClassificationModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.RegressionModelBuildState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ClassificationAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelTargetValueState;
import oracle.dmt.dm4j.wizard.state.miningsteps.RegressionAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetStateError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.TargetStateWarning;

public class TargetState
extends WizardStepState {
    private TargetValueDataSource m_targetValues;
    private StringBuffer m_targetAttribute = new StringBuffer(0);

    public TargetState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public Vector getAttributes() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getAttributesFromLDSDataSource(true, true);
    }

    public Vector getInEligibleTargetAttributes() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getInEligibleTargetAttributes();
    }

    public void setTargetAttribute(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_targetAttribute.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.unsetTargetAttribute(this.m_targetAttribute.toString());
            WizardStepState wizardStepState = (WizardStepState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
            String string3 = "categorical";
            if (wizardStepState instanceof ClassificationAlgorithmState) {
                string3 = "categorical";
            } else if (wizardStepState instanceof RegressionAlgorithmState) {
                string3 = "numerical";
            }
            int n = this.getLDSDataSource().getFirstRowByColumnValue(1, string);
            this.getLDSDataSource().setData(5, n, "target");
            this.getLDSDataSource().setData(3, n, string3);
            this.getLDSDataSource().setData(0, n, Boolean.TRUE);
            this.m_targetAttribute.setLength(0);
            this.m_targetAttribute.append(string);
        }
    }

    protected void unsetTargetAttribute(String string) {
        if (string.length() != 0) {
            int n = this.getLDSDataSource().getFirstRowByColumnValue(1, string);
            String string2 = (String)this.getLDSDataSource().getData(7, n);
            this.getLDSDataSource().setData(5, n, string2);
            this.getLDSDataSource().setData(5, n, "active");
        }
    }

    public String getTargetAttribute() {
        return this.m_targetAttribute.toString();
    }

    private void setTargetValues(TargetValueDataSource targetValueDataSource) {
        this.m_targetValues = targetValueDataSource;
    }

    private Vector getTargetValues() {
        return this.m_targetValues.getAttributes(0);
    }

    public LDSDataSource getLDSDataSource() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getLDSDataSource();
    }

    protected void refreshOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
        this.m_targetAttribute = new StringBuffer(0);
        this.loadNew();
    }

    protected void loadOld() throws Exception {
        ModelBuildLoader modelBuildLoader = (ModelBuildLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        modelBuildLoader.buildTargetAttribute(this);
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        TargetValueExtractProcess targetValueExtractProcess = null;
        try {
            ModelTargetValueState modelTargetValueState = (ModelTargetValueState)this.getparentWizardState().getStep(StepType.TARGET_VALUE_STEP);
            WizardState wizardState = (WizardState)this.getparentWizardState();
            if (modelTargetValueState != null && wizardState.isNew()) {
                targetValueExtractProcess = new TargetValueExtractProcess((DataState)this.getparentWizardState().getStep(StepType.DATA_STEP));
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("TARGET_VALUE_EXTRACT_DIALOG_TITLE"), targetValueExtractProcess, true);
                targetValueExtractProcess.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("TARGET_VALUE_EXTRACT_DIALOG_TITLE"), ResourceUtilities.getUILabel("TARGET_VALUE_EXTRACT_DESCRIPTION"));
                if (targetValueExtractProcess.getException() != null) {
                    this.getparentWizardState().doAbortCancel(targetValueExtractProcess.getException());
                } else if (progressBar.hasUserCancelled()) {
                    bl = false;
                    this.setState(StepStateType.DIRTY);
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadNew() throws Exception {
        if (this.getparentWizardState().getBrowserContext().getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            String string = this.getparentWizardState().getBrowserContext().getActivity().getTargetColumn().getAlias();
            this.setTargetAttribute(string);
        }
    }

    protected void validateCommonTargetAttribute(Vector vector) throws Exception {
        if (this.m_targetAttribute.length() == 0) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("TARGET_NAME")};
            vector.add(new StateValidation(TargetStateError.TARGET_EMPTY, string, stringArray));
            return;
        }
        int n = this.getLDSDataSource().getAttributeIndex(this.m_targetAttribute.toString());
        Object object = this.getLDSDataSource().getData(10, n);
        int n2 = object != null ? (Integer)this.getLDSDataSource().getData(10, n) : 0;
        if (n2 == 0) {
            vector.add(new StateValidation(TargetStateError.TARGET_ALL_NULLS));
        }
    }

    protected void validateCategoricalTargetAttribute(Vector vector) throws Exception {
        if (!(this.getparentWizardState() instanceof ClassificationModelBuildState) && !(this.getparentWizardState() instanceof AttributeImportanceModelBuildState)) {
            return;
        }
        int n = this.getLDSDataSource().getAttributeIndex(this.m_targetAttribute.toString());
        String string = (String)this.getLDSDataSource().getData(2, n);
        int n2 = (Integer)this.getLDSDataSource().getData(10, n);
        if (n2 < 2) {
            vector.add(new StateValidation(TargetStateError.TARGET_LESS_THAN_2_VALUES));
            return;
        }
        int n3 = ((Float)this.getLDSDataSource().getData(11, n)).intValue();
        if (n3 > 0) {
            vector.add(new StateValidation(TargetStateWarning.TARGET_CONTAINS_NULLS));
        }
        if (string.equals("FLOAT")) {
            vector.add(new StateValidation(TargetStateWarning.TARGET_IS_FLOAT));
        }
        UserPreferences userPreferences = UserPreferences.getInstance();
        boolean bl = (Boolean)this.getLDSDataSource().getData(15, n);
        if (bl) {
            vector.add(new StateValidation(TargetStateWarning.TARGET_IS_UNIQUE));
        }
        if (n2 > userPreferences.getMaxCategoricalBin()) {
            String string2 = ResourceUtilities.getstateExceptionMessage("TARGET_DISTINCT_COUNT_HIGH");
            String[] stringArray = new String[]{Integer.toString(n2), Integer.toString(userPreferences.getMaxCategoricalBin())};
            vector.add(new StateValidation(TargetStateWarning.TARGET_DISTINCT_COUNT_HIGH, string2, stringArray));
        }
    }

    protected void validateRegressionTargetAttribute(Vector vector) throws Exception {
        if (!(this.getparentWizardState() instanceof RegressionModelBuildState)) {
            return;
        }
        int n = this.getLDSDataSource().getAttributeIndex(this.m_targetAttribute.toString());
        String string = (String)this.getLDSDataSource().getData(2, n);
        if (!string.equals("FLOAT") && !string.equals("NUMBER")) {
            vector.add(new StateValidation(TargetStateError.TARGET_REGRESSION_INVALID_DATATYPE));
            return;
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateCommonTargetAttribute(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateCategoricalTargetAttribute(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateRegressionTargetAttribute(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }
}

