/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.director.minings.MiningLoader;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.SequenceAttributeStateError;

public class SequenceAttributeState
extends WizardStepState {
    private Vector m_sequenceAttributesIdx = null;
    private StringBuffer m_sequenceAttribute = new StringBuffer(0);
    private boolean m_newWizard = true;
    private boolean m_optional = false;
    private boolean m_useCaseId = true;

    public SequenceAttributeState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public Vector getInSequenceAttributes() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return dataState.getInEligibleTextSequenceAttributes(false);
    }

    public void syncSequenceAttribute(String string) {
        if (string != null) {
            int n = this.getLDSDataSource().getFirstRowByColumnValue(1, string);
            if (n >= 0) {
                this.setSequenceAttribute(string);
            } else {
                this.selectDefaultSequenceAttribute();
            }
        }
    }

    public void setSequenceAttribute(String string) {
        if (string != null) {
            String string2 = this.m_sequenceAttribute.toString();
            if (!string.equals(string2)) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.unsetSequenceAttribute(this.m_sequenceAttribute.toString());
                WizardStepState wizardStepState = (WizardStepState)this.getparentWizardState().getStep(StepType.ALGORITHM_STEP);
                int n = this.getLDSDataSource().getFirstRowByColumnValue(1, string);
                this.getLDSDataSource().setData(5, n, "caseId");
                this.getLDSDataSource().setData(0, n, Boolean.TRUE);
                this.m_sequenceAttribute.setLength(0);
                this.m_sequenceAttribute.append(string);
                this.m_useCaseId = true;
            }
        } else if (this.m_sequenceAttribute.length() > 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.unsetSequenceAttribute(this.m_sequenceAttribute.toString());
            this.m_sequenceAttribute.setLength(0);
            this.m_useCaseId = false;
        }
    }

    protected void unsetSequenceAttribute(String string) {
        if (string.length() != 0) {
            int n = this.getLDSDataSource().getFirstRowByColumnValue(1, string);
            String string2 = (String)this.getLDSDataSource().getData(7, n);
            this.getLDSDataSource().setData(5, n, string2);
            Boolean bl = (Boolean)this.getLDSDataSource().getData(8, n);
            this.getLDSDataSource().setData(0, n, bl);
        }
    }

    public String getSequenceAttribute() {
        return this.m_sequenceAttribute.length() > 0 ? this.m_sequenceAttribute.toString() : null;
    }

    public String getSequenceAttributeDataType() {
        String string = null;
        if (this.m_sequenceAttribute.length() > 0) {
            LDSDataSource lDSDataSource = this.getLDSDataSource();
            string = lDSDataSource.getAttributeDataType(this.m_sequenceAttribute.toString());
        }
        return string;
    }

    public LDSDataSource getLDSDataSource() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return dataState.getLDSDataSource();
    }

    protected void selectDefaultSequenceAttribute() {
        if (!this.m_sequenceAttributesIdx.isEmpty()) {
            if (this.getparentWizardState().getBrowserContext().getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                String string = this.getparentWizardState().getBrowserContext().getActivity().getCaseColumn().getName();
                this.setSequenceAttribute(string);
            } else {
                String string = this.getLDSDataSource().getCaseIdAttributeName();
                if (string.length() > 0) {
                    this.setSequenceAttribute(string);
                } else {
                    String string2 = (String)this.m_sequenceAttributesIdx.get(0);
                    this.setSequenceAttribute((String)this.getLDSDataSource().getData(1, Integer.parseInt(string2)));
                }
            }
        }
    }

    protected void refreshOld() throws Exception {
        this.loadOld();
    }

    protected void refreshNew() throws Exception {
        this.loadNew();
    }

    protected void loadOld() throws Exception {
        this.m_newWizard = false;
        this.loadDefault();
        MiningLoader miningLoader = ((WizardState)this.getparentWizardState()).getMiningLoader();
        miningLoader.buildSequenceAttribute(this);
        if (!this.isCaseIdOptional() && this.getSequenceAttribute() == null) {
            this.selectDefaultSequenceAttribute();
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    public void setUseCaseId(boolean bl) {
        if (this.m_useCaseId != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useCaseId = bl;
            if (!bl) {
                this.setSequenceAttribute(null);
            } else {
                this.selectDefaultSequenceAttribute();
            }
        }
    }

    public boolean isCaseIdUsed() {
        return this.m_useCaseId;
    }

    public void setCaseIdOptional(boolean bl) {
        if (this.m_optional != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_optional = bl;
        }
    }

    public boolean isCaseIdOptional() {
        return this.m_optional;
    }

    protected void loadDefault() {
        this.m_sequenceAttribute.setLength(0);
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        this.m_sequenceAttributesIdx = dataState.getInEligibleTextSequenceAttributes(false);
        this.setCaseIdOptional(false);
    }

    protected void loadNew() throws Exception {
        this.m_newWizard = true;
        this.loadDefault();
        this.selectDefaultSequenceAttribute();
    }

    protected void validateSequenceAttribute(Vector vector) throws Exception {
        if ((this.isCaseIdOptional() && this.isCaseIdUsed() || !this.isCaseIdOptional()) && this.m_sequenceAttribute.length() == 0) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SEQUENCEID_SEQID_NAME")};
            vector.add(new StateValidation(SequenceAttributeStateError.SEQUENCE_ATTR_EMPTY, string, stringArray));
            return;
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateSequenceAttribute(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }
}

