/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import javax.datamining.algorithm.svm.KernelFunction;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.director.minings.RegressionModelBuildLoader;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.DataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.GeneralizedLinearModelAlgorithmState;
import oracle.dmt.dm4j.wizard.state.miningsteps.ModelDataState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SupportVectorMachineAlgorithmState;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class RegressionAlgorithmState
extends WizardStepState {
    private boolean m_supportVectorMachineSelected = false;
    private boolean m_generalizedLinearModelSelected = false;
    private SupportVectorMachineAlgorithmState m_svmAlgorithmState;
    private GeneralizedLinearModelAlgorithmState m_glmAlgorithmState;

    public RegressionAlgorithmState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            AbstractActivity abstractActivity = this.getparentWizardState().getBrowserContext().getActivity();
            ActivityType activityType = abstractActivity.getType();
            if (activityType == ActivityType.SVM_REGRESSION) {
                this.setSupportVectorMachineSelected(true);
            } else if (activityType == ActivityType.GLM_REGRESSION) {
                this.setGeneralizedLinearModelSelected(true);
            }
        }
    }

    public void setSupportVectorMachineSelected(boolean bl) {
        if (!this.m_supportVectorMachineSelected == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_supportVectorMachineSelected = bl;
            if (bl) {
                this.m_generalizedLinearModelSelected = false;
            }
        }
    }

    public void setGeneralizedLinearModelSelected(boolean bl) {
        if (!this.m_generalizedLinearModelSelected == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_generalizedLinearModelSelected = bl;
            if (bl) {
                this.m_supportVectorMachineSelected = false;
            }
        }
    }

    public boolean getSupportVectorMachineSelected() {
        return this.m_supportVectorMachineSelected;
    }

    public boolean isSupportVectorMachineSelected() {
        return this.m_supportVectorMachineSelected;
    }

    public boolean getGeneralizedLinearModelSelected() {
        return this.m_generalizedLinearModelSelected;
    }

    public boolean isGeneralizedLinearModelSelected() {
        return this.m_generalizedLinearModelSelected;
    }

    public LDSDataSource getLDSDataSource() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getLDSDataSource();
    }

    public int getAttributeCount() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getAttributeCountFromLDSDataSource();
    }

    public int getActiveAttributeCountExcludingTargets() {
        ModelDataState modelDataState = (ModelDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return modelDataState.getActiveAttributeCountExcludingTargets();
    }

    public int getCaseCount() {
        DataState dataState = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return dataState.getCaseCount();
    }

    public SupportVectorMachineAlgorithmState getSupportVectorMachine() {
        if (this.m_svmAlgorithmState == null) {
            this.loadDefaultSVMSetting();
        }
        return this.m_svmAlgorithmState;
    }

    public void setSupportVectorMachineAlgorithm(SupportVectorMachineAlgorithmState supportVectorMachineAlgorithmState) {
        this.m_svmAlgorithmState = supportVectorMachineAlgorithmState;
    }

    public GeneralizedLinearModelAlgorithmState getGeneralizedLinearModel() {
        if (this.m_glmAlgorithmState == null) {
            this.loadDefaultGLMSetting();
        }
        return this.m_glmAlgorithmState;
    }

    public void setGeneralizedLinearModelAlgorithm(GeneralizedLinearModelAlgorithmState generalizedLinearModelAlgorithmState) {
        this.m_glmAlgorithmState = generalizedLinearModelAlgorithmState;
    }

    protected void refreshOld() throws Exception {
    }

    protected void refreshNew() throws Exception {
    }

    public boolean allowAlgorithmSelection() {
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        return !browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }

    protected void loadOld() throws Exception {
        RegressionModelBuildLoader regressionModelBuildLoader = (RegressionModelBuildLoader)((WizardState)this.getparentWizardState()).getMiningLoader();
        regressionModelBuildLoader.buildAlgorithmSetting(this);
        this.getSupportVectorMachine();
        this.getGeneralizedLinearModel();
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadNew() throws Exception {
        this.loadDefaults();
    }

    protected void loadDefaults() {
        this.loadDefaultSVMSetting();
        this.loadDefaultGLMSetting();
    }

    protected void loadDefaultSVMSetting() {
        this.m_svmAlgorithmState = new SupportVectorMachineAlgorithmState(this, KernelFunction.systemDetermined, new Double(0.001), new Double(0.0), new Double(0.0), new Integer(50), new Double(0.0), true);
    }

    protected void loadDefaultGLMSetting() {
        this.m_glmAlgorithmState = new GeneralizedLinearModelAlgorithmState(this, new Double(0.95), false, false, null, false);
    }

    public void validate(Vector vector) throws Exception {
        if (this.isSupportVectorMachineSelected()) {
            this.m_svmAlgorithmState.validate(vector);
        }
        if (this.isGeneralizedLinearModelSelected()) {
            this.m_glmAlgorithmState.validate(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }
}

