/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.miningsteps;

import java.util.Vector;
import javax.datamining.algorithm.svm.KernelFunction;
import oracle.dmt.dm4j.activity.steps.AnomalyDetectionBuildStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.minings.WizardStepState;
import oracle.dmt.dm4j.wizard.state.miningsteps.SupportVectorMachineAlgorithmState;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.miningsteps.SupportVectorMachineAlgorithmStateError;

public class OneClassSVMAlgorithmState
extends SupportVectorMachineAlgorithmState {
    private Double m_outlierRate;
    private Double m_defaultOutlierRate;
    private AnomalyDetectionBuildStepOptions m_options = null;

    public OneClassSVMAlgorithmState(WizardStepState wizardStepState, KernelFunction kernelFunction, Double d, Double d2, Double d3, Integer n, Double d4, boolean bl) {
        super(wizardStepState, kernelFunction, d, d2, d3, n, bl);
        this.initialize(d4);
    }

    public OneClassSVMAlgorithmState(KernelFunction kernelFunction, Double d, Double d2, Double d3, Integer n, Double d4, boolean bl) {
        super(kernelFunction, d, d2, d3, n, bl);
        this.initialize(d4);
    }

    private void initialize(Double d) {
        BrowserContext browserContext = this.m_wizardStepState.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            this.m_options = (AnomalyDetectionBuildStepOptions)browserContext.getOptions();
        }
        this.m_outlierRate = this.m_options != null ? this.m_options.getOutliner() : d;
        this.m_defaultOutlierRate = this.m_outlierRate;
    }

    public void setOutlierRate(Double d) {
        if (this.m_outlierRate == null || d == null || this.m_outlierRate.compareTo(d) != 0) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_outlierRate = d;
        }
    }

    public Double getOutlierRate() {
        return this.m_outlierRate;
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        this.validateOutlierRate(vector);
    }

    protected void validateOutlierRate(Vector vector) throws Exception {
        if (this.m_outlierRate == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("ALGO_SVM_OUTLINER")};
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_OUTLINER_EMPTY, string, stringArray));
            return;
        }
        if (this.m_outlierRate <= 0.0 || this.m_outlierRate > 1.0) {
            vector.add(new StateValidation(SupportVectorMachineAlgorithmStateError.ALGO_SVM_OUTLINER_INVALID));
        }
    }

    public void restoreSettingsToDefault() {
        super.restoreSettingsToDefault();
        this.setOutlierRate(this.m_defaultOutlierRate);
    }
}

